/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.util.Collection;
import java.util.HashSet;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.local.persistence.CryptoLink;
import org.subshare.local.persistence.CryptoLinkDao;
import org.subshare.local.persistence.UserIdentityLink;
import org.subshare.local.persistence.UserIdentityLinkDao;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

public class UserRepoKeyPublicKeyDao
extends Dao<UserRepoKeyPublicKey, UserRepoKeyPublicKeyDao> {
    private static final Logger logger = LoggerFactory.getLogger(UserRepoKeyPublicKeyDao.class);

    public UserRepoKeyPublicKey getUserRepoKeyPublicKeyOrFail(Uid userRepoKeyId) {
        UserRepoKeyPublicKey key = this.getUserRepoKeyPublicKey(userRepoKeyId);
        if (key == null) {
            throw new IllegalArgumentException("There is no UserRepoKeyPublicKey with this userRepoKeyId: " + userRepoKeyId);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRepoKeyPublicKey getUserRepoKeyPublicKey(Uid userRepoKeyId) {
        AssertUtil.assertNotNull((String)"userRepoKeyId", (Object)userRepoKeyId);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getUserRepoKeyPublicKey_userRepoKeyId");
        try {
            UserRepoKeyPublicKey key;
            UserRepoKeyPublicKey userRepoKeyPublicKey = key = (UserRepoKeyPublicKey)((Object)query.execute((Object)userRepoKeyId.toString()));
            return userRepoKeyPublicKey;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UserRepoKeyPublicKey> getUserRepoKeyPublicKeysChangedAfter(long localRevision) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getUserRepoKeyPublicKeysChangedAfter_localRevision");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection keys = (Collection)query.execute((Object)localRevision);
            logger.debug("getUserRepoKeyPublicKeysChangedAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            keys = this.load(keys);
            logger.debug("getUserRepoKeyPublicKeysChangedAfter: Loading result-set with {} elements took {} ms.", (Object)keys.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = keys;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public void deletePersistent(UserRepoKeyPublicKey entity) {
        this.deleteDependentObjects(entity);
        this.pm().flush();
        this.assertNothingSigned(entity);
        super.deletePersistent((Entity)entity);
    }

    public void deletePersistentAll(Collection<? extends UserRepoKeyPublicKey> entities) {
        for (UserRepoKeyPublicKey userRepoKeyPublicKey : entities) {
            this.deleteDependentObjects(userRepoKeyPublicKey);
        }
        this.pm().flush();
        for (UserRepoKeyPublicKey userRepoKeyPublicKey : entities) {
            this.assertNothingSigned(userRepoKeyPublicKey);
        }
        super.deletePersistentAll(entities);
    }

    protected void deleteDependentObjects(UserRepoKeyPublicKey userRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"userRepoKeyPublicKey", (Object)((Object)userRepoKeyPublicKey));
        UserIdentityLinkDao userIdentityLinkDao = (UserIdentityLinkDao)this.getDao(UserIdentityLinkDao.class);
        HashSet<UserIdentityLink> userIdentityLinks = new HashSet<UserIdentityLink>();
        userIdentityLinks.addAll(userIdentityLinkDao.getUserIdentityLinksOf(userRepoKeyPublicKey));
        userIdentityLinks.addAll(userIdentityLinkDao.getUserIdentityLinksFor(userRepoKeyPublicKey));
        userIdentityLinkDao.deletePersistentAll(userIdentityLinks);
    }

    protected void assertNothingSigned(UserRepoKeyPublicKey userRepoKeyPublicKey) {
        Uid signingUserRepoKeyId = userRepoKeyPublicKey.getUserRepoKeyId();
        Collection<CryptoLink> cryptoLinks = ((CryptoLinkDao)this.getDao(CryptoLinkDao.class)).getCryptoLinksSignedBy(signingUserRepoKeyId);
        if (!cryptoLinks.isEmpty()) {
            throw new IllegalStateException(String.format("Cannot delete UserRepoKeyPublicKey with userRepoKeyId=%s, because these objects are signed with this key: %s", signingUserRepoKeyId, cryptoLinks));
        }
    }
}

