/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import java.util.Collection;
import java.util.List;

public final class AssertUtil {
    private AssertUtil() {
    }

    public static final <T> T assertNotNull(String name, T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("%s == null", name));
        }
        return object;
    }

    public static final <T> T assertNotNull(String name, T object, String additionalInfoTemplate, Object ... additionalInfoArgs) {
        if (additionalInfoTemplate == null) {
            return AssertUtil.assertNotNull(name, object);
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("%s == null :: ", name) + String.format(additionalInfoTemplate, additionalInfoArgs));
        }
        return object;
    }

    public static final <T> T[] assertNotNullAndNoNullElement(String name, T[] array) {
        AssertUtil.assertNotNull(name, array);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException(String.format("%s[%s] == null", name, i));
        }
        return array;
    }

    public static final <E, T extends Collection<E>> T assertNotNullAndNoNullElement(String name, T collection) {
        AssertUtil.assertNotNull(name, collection);
        int i = -1;
        for (E element : collection) {
            ++i;
            if (element != null) continue;
            throw new IllegalArgumentException(String.format("%s[%s] == null", name, i));
        }
        return collection;
    }

    public static final <T> List<T> assertNotEmpty(String name, List<T> list) {
        AssertUtil.assertNotNull(name, list);
        if (list.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s == empty", name));
        }
        return list;
    }
}

