/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.UrlEncoder;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class UrlUtil {
    private UrlUtil() {
    }

    public static URL canonicalizeURL(URL url) {
        if (url == null) {
            return null;
        }
        URL result = url;
        String query = url.getQuery();
        if (query != null && query.isEmpty()) {
            query = null;
            result = null;
        }
        String path = url.getPath();
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
            result = null;
        }
        if (result == null) {
            String file = query == null ? path : path + '?' + query;
            try {
                result = new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static File getFile(URL url) {
        try {
            return OioFileFactory.createFile(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL appendEncodedPath(URL url, String path) {
        AssertUtil.assertNotNull("url", url);
        if (path == null || path.isEmpty()) {
            return url;
        }
        return UrlUtil.appendEncodedPath(url, Collections.singletonList(path));
    }

    public static URL appendNonEncodedPath(URL url, String path) {
        AssertUtil.assertNotNull("url", url);
        if (path == null || path.isEmpty()) {
            return url;
        }
        String[] pathSegments = path.split("/");
        ArrayList<String> encodedPathSegments = new ArrayList<String>(pathSegments.length);
        for (String pathSegment : pathSegments) {
            encodedPathSegments.add(UrlEncoder.encode(pathSegment));
        }
        return UrlUtil.appendEncodedPath(url, encodedPathSegments);
    }

    private static URL appendEncodedPath(URL url, List<String> pathSegments) {
        AssertUtil.assertNotNull("url", url);
        if (pathSegments == null || pathSegments.isEmpty()) {
            return url;
        }
        try {
            StringBuilder urlString = new StringBuilder(url.toExternalForm());
            for (String ps : pathSegments) {
                if (ps == null || ps.isEmpty()) continue;
                if (ps.startsWith("/") && UrlUtil.getLastChar(urlString) == '/') {
                    urlString.append(ps.substring(1));
                    continue;
                }
                if (!ps.startsWith("/") && UrlUtil.getLastChar(urlString) != '/') {
                    urlString.append('/').append(ps);
                    continue;
                }
                urlString.append(ps);
            }
            return new URL(urlString.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static char getLastChar(StringBuilder stringBuilder) {
        AssertUtil.assertNotNull("stringBuilder", stringBuilder);
        int index = stringBuilder.length() - 1;
        if (index < 0) {
            return '\u0000';
        }
        return stringBuilder.charAt(index);
    }

    public static final URI urlToUri(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return new URI(url.getProtocol(), url.getAuthority(), url.getPath(), url.getQuery(), url.getRef());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

