/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util.childprocess;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDumpedStreamThread
extends Thread {
    private static final String CHARSET_NAME_UTF_8 = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(LogDumpedStreamThread.class);
    private static final long logMaxAge = 5000L;
    private static final long logAfterNoWritePeriod = 500L;
    private static final int logWhenBufferExceedsSize = 51200;
    private final ByteArrayOutputStream bufferOutputStream = new ByteArrayOutputStream();
    private volatile boolean forceInterrupt = false;
    private Long firstNonLoggedWriteTimestamp = null;
    private long lastWriteTimestamp = 0L;
    private volatile StringBuffer outputStringBuffer;
    private volatile int outputStringBufferMaxLength = 0x100000;
    private Logger childProcessLogger;

    public LogDumpedStreamThread(String childProcessLoggerName) {
        this(childProcessLoggerName == null ? null : LoggerFactory.getLogger((String)childProcessLoggerName));
    }

    public LogDumpedStreamThread(Logger childProcessLogger) {
        this.childProcessLogger = childProcessLogger == null ? logger : childProcessLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] data, int length) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        ByteArrayOutputStream byteArrayOutputStream = this.bufferOutputStream;
        synchronized (byteArrayOutputStream) {
            this.bufferOutputStream.write(data, 0, length);
            this.lastWriteTimestamp = System.currentTimeMillis();
            if (this.firstNonLoggedWriteTimestamp == null) {
                this.firstNonLoggedWriteTimestamp = this.lastWriteTimestamp;
            }
        }
    }

    public void setOutputStringBuffer(StringBuffer outputStringBuffer) {
        this.outputStringBuffer = outputStringBuffer;
    }

    public StringBuffer getOutputStringBuffer() {
        return this.outputStringBuffer;
    }

    public void setOutputStringBufferMaxLength(int outputStringBufferMaxLength) {
        this.outputStringBufferMaxLength = outputStringBufferMaxLength;
    }

    public int getOutputStringBufferMaxLength() {
        return this.outputStringBufferMaxLength;
    }

    @Override
    public void interrupt() {
        this.forceInterrupt = true;
        super.interrupt();
    }

    @Override
    public boolean isInterrupted() {
        return this.forceInterrupt || super.isInterrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = this.bufferOutputStream;
                synchronized (byteArrayOutputStream) {
                    try {
                        this.bufferOutputStream.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.processBuffer(false);
                }
            }
            catch (Throwable e) {
                logger.error("run: " + e, e);
            }
        }
        this.processBuffer(true);
    }

    public void flushBuffer() {
        this.processBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBuffer(boolean force) {
        ByteArrayOutputStream byteArrayOutputStream = this.bufferOutputStream;
        synchronized (byteArrayOutputStream) {
            if (this.bufferOutputStream.size() > 0) {
                long firstNonLoggedWriteAge = this.firstNonLoggedWriteTimestamp == null ? 0L : System.currentTimeMillis() - this.firstNonLoggedWriteTimestamp;
                long noWritePeriod = System.currentTimeMillis() - this.lastWriteTimestamp;
                if (force || firstNonLoggedWriteAge > 5000L || noWritePeriod > 500L || this.bufferOutputStream.size() > 51200) {
                    String currentBufferString;
                    try {
                        currentBufferString = this.bufferOutputStream.toString(CHARSET_NAME_UTF_8);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    StringBuffer outputStringBuffer = this.getOutputStringBuffer();
                    if (outputStringBuffer != null) {
                        int newOutputStringBufferLength = outputStringBuffer.length() + currentBufferString.length();
                        if (newOutputStringBufferLength > this.outputStringBufferMaxLength) {
                            int lastCharPositionToDelete;
                            for (lastCharPositionToDelete = newOutputStringBufferLength - this.outputStringBufferMaxLength; outputStringBuffer.length() > lastCharPositionToDelete && outputStringBuffer.charAt(lastCharPositionToDelete) != '\n'; ++lastCharPositionToDelete) {
                            }
                            lastCharPositionToDelete = Math.min(lastCharPositionToDelete, outputStringBuffer.length() - 1);
                            outputStringBuffer.delete(0, lastCharPositionToDelete + 1);
                        }
                        outputStringBuffer.append(currentBufferString);
                    }
                    this.childProcessLogger.info('\n' + this.prefixEveryLine(currentBufferString));
                    this.bufferOutputStream.reset();
                }
            }
        }
    }

    private String prefixEveryLine(String s) {
        try {
            String line;
            StringBuilder result = new StringBuilder();
            String prefix = "  >>> ";
            BufferedReader r = new BufferedReader(new StringReader(s));
            while (null != (line = r.readLine())) {
                result.append("  >>> ").append(line).append('\n');
            }
            return result.toString();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }
}

