/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.client.locker.transport;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.client.ClientBuilderDefaultValuesDecorator;
import co.codewizards.cloudstore.rest.client.CloudStoreRestClient;
import co.codewizards.cloudstore.rest.client.CredentialsProvider;
import co.codewizards.cloudstore.rest.client.request.Request;
import co.codewizards.cloudstore.rest.client.ssl.DynamicX509TrustManagerCallback;
import co.codewizards.cloudstore.rest.client.ssl.SSLContextBuilder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.ClientBuilder;
import org.subshare.core.locker.LockerEncryptedDataFile;
import org.subshare.core.locker.transport.AbstractLockerTransport;
import org.subshare.rest.client.locker.transport.RestLockerTransportFactory;
import org.subshare.rest.client.locker.transport.request.GetLockerContentVersions;
import org.subshare.rest.client.locker.transport.request.GetLockerEncryptedDataFile;
import org.subshare.rest.client.locker.transport.request.PutLockerEncryptedDataFile;

public class RestLockerTransport
extends AbstractLockerTransport {
    private CloudStoreRestClient client;
    private final CredentialsProvider nullCredentialsProvider = new CredentialsProvider(){

        public String getUserName() {
            return null;
        }

        public String getPassword() {
            return null;
        }
    };

    public List<Uid> getVersions() {
        List result = (List)this.getClient().execute((Request)new GetLockerContentVersions(this.getPgpKeyOrFail().getPgpKeyId(), this.getLockerContentOrFail().getName()));
        return result;
    }

    public void addMergedVersions(List<Uid> serverVersions) {
        AssertUtil.assertNotNull((String)"serverVersions", serverVersions);
        throw new UnsupportedOperationException("Merging is only supported on the client side.");
    }

    public List<LockerEncryptedDataFile> getEncryptedDataFiles() {
        List<Uid> versions = this.getVersions();
        ArrayList<LockerEncryptedDataFile> result = new ArrayList<LockerEncryptedDataFile>(versions.size());
        for (Uid version : versions) {
            LockerEncryptedDataFile lockerEncryptedDataFile = (LockerEncryptedDataFile)this.getClient().execute((Request)new GetLockerEncryptedDataFile(this.getPgpKeyOrFail().getPgpKeyId(), this.getLockerContentOrFail().getName(), version));
            if (lockerEncryptedDataFile == null) continue;
            result.add(lockerEncryptedDataFile);
        }
        return result;
    }

    public void putEncryptedDataFile(LockerEncryptedDataFile encryptedDataFile) {
        this.getClient().execute((Request)new PutLockerEncryptedDataFile(encryptedDataFile));
    }

    protected CloudStoreRestClient getClient() {
        if (this.client == null) {
            ClientBuilder clientBuilder = this.createClientBuilder();
            CloudStoreRestClient c = new CloudStoreRestClient(this.getUrl(), clientBuilder);
            c.setCredentialsProvider(this.nullCredentialsProvider);
            this.client = c;
        }
        return this.client;
    }

    private ClientBuilder createClientBuilder() {
        ClientBuilderDefaultValuesDecorator builder = new ClientBuilderDefaultValuesDecorator();
        try {
            builder.sslContext(SSLContextBuilder.create().remoteURL(this.getUrl()).callback(this.getDynamicX509TrustManagerCallback()).build());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    protected DynamicX509TrustManagerCallback getDynamicX509TrustManagerCallback() {
        RestLockerTransportFactory lockerTransportFactory = (RestLockerTransportFactory)this.getLockerTransportFactory();
        Class<? extends DynamicX509TrustManagerCallback> klass = lockerTransportFactory.getDynamicX509TrustManagerCallbackClass();
        if (klass == null) {
            throw new IllegalStateException("dynamicX509TrustManagerCallbackClass is not set!");
        }
        try {
            DynamicX509TrustManagerCallback instance = klass.newInstance();
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not instantiate class %s: %s", klass.getName(), e.toString()), e);
        }
    }
}

