/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.assignownertrust.selectownertrust;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import javafx.fxml.FXML;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.subshare.core.pgp.PgpOwnerTrust;
import org.subshare.core.user.User;
import org.subshare.gui.pgp.assignownertrust.AssignOwnerTrustData;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class SelectOwnerTrustPane
extends WizardPageContentGridPane {
    private AssignOwnerTrustData assignOwnerTrustData;
    @FXML
    private ToggleGroup toggleGroup;
    @FXML
    private TextField userTextField;
    @FXML
    private VBox radioButtonBox;
    private Map<PgpOwnerTrust, RadioButton> ownerTrust2RadioButton = new HashMap<PgpOwnerTrust, RadioButton>();
    @FXML
    private Text selectedOwnerTrustDescriptionText;

    public SelectOwnerTrustPane(AssignOwnerTrustData assignOwnerTrustData) {
        this.assignOwnerTrustData = (AssignOwnerTrustData)AssertUtil.assertNotNull((String)"assignOwnerTrustData", (Object)assignOwnerTrustData);
        FxmlUtil.loadDynamicComponentFxml(SelectOwnerTrustPane.class, this);
        this.populateUserTextField();
        this.populateRadioButtonBox();
        assignOwnerTrustData.ownerTrustProperty().addListener(observable -> this.updateToggleGroup());
        this.updateToggleGroup();
    }

    @Override
    protected boolean isComplete() {
        return this.assignOwnerTrustData.getOwnerTrust() != null && this.assignOwnerTrustData.getOwnerTrust() != PgpOwnerTrust.UNSPECIFIED;
    }

    private void populateUserTextField() {
        User user = this.assignOwnerTrustData.getUser();
        StringBuilder sb = new StringBuilder();
        if (user != null) {
            if (!StringUtil.isEmpty((String)user.getFirstName())) {
                sb.append(user.getFirstName());
            }
            if (!StringUtil.isEmpty((String)user.getLastName())) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(user.getLastName());
            }
            String email = null;
            for (String e : user.getEmails()) {
                if (StringUtil.isEmpty((String)e)) continue;
                email = e;
                break;
            }
            if (!StringUtil.isEmpty(email)) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append('<').append(email).append('>');
            }
        }
        this.userTextField.setText(sb.toString());
    }

    private void updateToggleGroup() {
        PgpOwnerTrust ownerTrust = (PgpOwnerTrust)this.assignOwnerTrustData.ownerTrustProperty().get();
        RadioButton radioButton = this.ownerTrust2RadioButton.get(ownerTrust);
        this.toggleGroup.selectToggle((Toggle)radioButton);
        this.selectedOwnerTrustDescriptionText.setText(ownerTrust == null ? null : ownerTrust.getDescription());
        this.updateComplete();
    }

    private void populateRadioButtonBox() {
        this.radioButtonBox.getChildren().clear();
        for (PgpOwnerTrust ownerTrust : PgpOwnerTrust.values()) {
            if (PgpOwnerTrust.UNSPECIFIED == ownerTrust) continue;
            RadioButton radioButton = new RadioButton(ownerTrust.getAnswer());
            radioButton.setUserData((Object)ownerTrust);
            radioButton.setToggleGroup(this.toggleGroup);
            this.radioButtonBox.getChildren().add((Object)radioButton);
            this.ownerTrust2RadioButton.put(ownerTrust, radioButton);
        }
        this.toggleGroup.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            PgpOwnerTrust ownerTrust = newValue == null ? null : SelectOwnerTrustPane.getOwnerTrust((RadioButton)newValue);
            this.assignOwnerTrustData.setOwnerTrust(ownerTrust);
            this.selectedOwnerTrustDescriptionText.setText(ownerTrust == null ? null : ownerTrust.getDescription());
        });
    }

    private static PgpOwnerTrust getOwnerTrust(RadioButton radioButton) {
        AssertUtil.assertNotNull((String)"radioButton", (Object)radioButton);
        return (PgpOwnerTrust)AssertUtil.assertNotNull((String)"radioButton.userData", (Object)radioButton.getUserData());
    }
}

