/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpSignature;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.pgp.keytree.CertificationPgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;

public class CertificationsPgpKeyTreeItem
extends PgpKeyTreeItem<PgpKey> {
    private final String userId;
    private boolean childrenInitialised;

    public CertificationsPgpKeyTreeItem(PgpKey pgpKey, String userId) {
        super(AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey));
        this.userId = (String)AssertUtil.assertNotNull((String)"userId", (Object)userId);
    }

    public ObservableList<TreeItem<PgpKeyTreeItem<?>>> getChildren() {
        ObservableList children = super.getChildren();
        if (!this.childrenInitialised) {
            this.childrenInitialised = true;
            Pgp pgp = PgpLs.getPgpOrFail();
            PgpKey pgpKey = (PgpKey)this.getValueObject();
            Collection signatures = pgp.getCertifications(pgpKey);
            for (PgpSignature signature : signatures) {
                if (signature.getUserId() != null && !this.userId.equals(signature.getUserId())) continue;
                this.getChildren().add((Object)new CertificationPgpKeyTreeItem(pgp, signature));
            }
        }
        return children;
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getName() {
        return "Certifications";
    }
}

