/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import org.subshare.core.pgp.Pgp;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.pgp.keytree.PgpKeyTreePane;

public class PgpKeyTreeItem<T>
extends TreeItem<PgpKeyTreeItem<?>> {
    private T valueObject;
    private Pgp pgp;
    private final BooleanProperty checked = new SimpleBooleanProperty((Object)this, "checked"){

        public void set(boolean newValue) {
            super.set(newValue);
            if (newValue) {
                PgpKeyTreeItem.this.getPgpKeyTreePane().getCheckedTreeItems().add((Object)PgpKeyTreeItem.this);
            } else {
                PgpKeyTreeItem.this.getPgpKeyTreePane().getCheckedTreeItems().remove((Object)PgpKeyTreeItem.this);
            }
        }
    };
    private final PropertyChangeListener trustDbPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PgpKeyTreeItem.this.updateKeyValidityAndOwnerTrust();
        }
    };
    private boolean trustDbPropertyChangeListenerHooked;
    private final StringProperty keyValidity = new SimpleStringProperty((Object)this, "keyValidity");
    private final StringProperty ownerTrust = new SimpleStringProperty((Object)this, "ownerTrust");

    public PgpKeyTreeItem(T valueObject) {
        this(valueObject, null);
    }

    public PgpKeyTreeItem(T valueObject, Node graphic) {
        this.setValue((Object)this);
        this.valueObject = valueObject;
        this.setGraphic(graphic);
    }

    protected void updateKeyValidityAndOwnerTrust() {
        this.keyValidity.set((Object)this.getKeyValidity());
        this.ownerTrust.set((Object)this.getOwnerTrust());
    }

    protected T getValueObject() {
        return this.valueObject;
    }

    public BooleanProperty checkedProperty() {
        return this.checked;
    }

    public boolean isChecked() {
        return this.checked.get();
    }

    public void setChecked(boolean checked) {
        this.checked.set(checked);
    }

    public String getName() {
        return this.getValueObject().toString();
    }

    public String getKeyId() {
        return null;
    }

    public String getKeyValidity() {
        return null;
    }

    public ReadOnlyStringProperty keyValidityProperty() {
        if (this.keyValidity.get() == null && this.getKeyValidity() != null) {
            this.hookTrustDbPropertyChangeListener();
            this.updateKeyValidityAndOwnerTrust();
        }
        return this.keyValidity;
    }

    public String getOwnerTrust() {
        return null;
    }

    public ReadOnlyStringProperty ownerTrustProperty() {
        if (this.ownerTrust.get() == null && this.getOwnerTrust() != null) {
            this.hookTrustDbPropertyChangeListener();
            this.updateKeyValidityAndOwnerTrust();
        }
        return this.ownerTrust;
    }

    public String getCreated() {
        return null;
    }

    public String getValidTo() {
        return null;
    }

    public String getAlgorithm() {
        return null;
    }

    public String getStrength() {
        return null;
    }

    public String getUsage() {
        return null;
    }

    protected TreeTableView<PgpKeyTreeItem<?>> getTreeTableView() {
        return this.getPgpKeyTreePane().getTreeTableView();
    }

    protected PgpKeyTreePane getPgpKeyTreePane() {
        PgpKeyTreeItem parent = (PgpKeyTreeItem)this.getParent();
        AssertUtil.assertNotNull((String)"parent", (Object)((Object)parent));
        return parent.getPgpKeyTreePane();
    }

    public <I extends PgpKeyTreeItem<?>> I getThisOrParentPgpKeyTreeItemOfType(Class<I> type) {
        AssertUtil.assertNotNull((String)"type", type);
        if (type.isInstance((Object)this)) {
            return (I)((Object)((PgpKeyTreeItem)((Object)type.cast((Object)this))));
        }
        PgpKeyTreeItem parent = (PgpKeyTreeItem)this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getThisOrParentPgpKeyTreeItemOfType(type);
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getName(), this.valueObject);
    }

    protected Pgp getPgp() {
        if (this.pgp == null) {
            PgpKeyTreeItem parent = (PgpKeyTreeItem)this.getParent();
            this.pgp = parent != null ? parent.getPgp() : PgpLs.getPgpOrFail();
        }
        return this.pgp;
    }

    protected void hookTrustDbPropertyChangeListener() {
        if (!this.trustDbPropertyChangeListenerHooked) {
            this.trustDbPropertyChangeListenerHooked = true;
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.getPgp(), (PropertyBase)Pgp.PropertyEnum.trustdb, (PropertyChangeListener)this.trustDbPropertyChangeListener);
        }
    }
}

