/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javafx.application.Platform;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.user.User;
import org.subshare.gui.pgp.keytree.PgpKeyPgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreePane;

public class UserRootPgpKeyTreeItem
extends PgpKeyTreeItem<User> {
    private final PgpKeyTreePane pgpKeyTreePane;
    private final PropertyChangeListener userPgpKeyIdsPropertyChangeListener = event -> Platform.runLater(() -> this.updatePgpKeyChildren());
    private final Map<PgpKeyId, PgpKeyPgpKeyTreeItem> pgpKeyId2PgpKeyPgpKeyTreeItem = new HashMap<PgpKeyId, PgpKeyPgpKeyTreeItem>();

    public UserRootPgpKeyTreeItem(PgpKeyTreePane pgpKeyTreePane, User user) {
        super(AssertUtil.assertNotNull((String)"user", (Object)user));
        this.pgpKeyTreePane = (PgpKeyTreePane)((Object)AssertUtil.assertNotNull((String)"pgpKeyTreePane", (Object)((Object)pgpKeyTreePane)));
        PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)user, (PropertyBase)User.PropertyEnum.pgpKeyIds, (PropertyChangeListener)this.userPgpKeyIdsPropertyChangeListener);
        this.updatePgpKeyChildren();
    }

    @Override
    protected PgpKeyTreePane getPgpKeyTreePane() {
        return this.pgpKeyTreePane;
    }

    private void updatePgpKeyChildren() {
        User user = (User)this.getValueObject();
        HashSet<PgpKeyId> pgpKeyIds = new HashSet<PgpKeyId>();
        for (PgpKey pgpKey : user.getPgpKeys()) {
            PgpKeyId pgpKeyId = pgpKey.getPgpKeyId();
            pgpKeyIds.add(pgpKeyId);
            if (this.pgpKeyId2PgpKeyPgpKeyTreeItem.containsKey(pgpKeyId)) continue;
            PgpKeyPgpKeyTreeItem child = new PgpKeyPgpKeyTreeItem(pgpKey);
            this.pgpKeyId2PgpKeyPgpKeyTreeItem.put(pgpKeyId, child);
            this.getChildren().add((Object)child);
        }
        Iterator<Map.Entry<PgpKeyId, PgpKeyPgpKeyTreeItem>> it = this.pgpKeyId2PgpKeyPgpKeyTreeItem.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<PgpKeyId, PgpKeyPgpKeyTreeItem> me = it.next();
            if (pgpKeyIds.contains(me.getKey())) continue;
            this.getChildren().remove((Object)me.getValue());
            it.remove();
        }
    }
}

