/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.client.locker.transport.request;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.client.request.AbstractRequest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.subshare.core.locker.LockerEncryptedDataFile;
import org.subshare.core.pgp.PgpKeyId;

public class GetLockerEncryptedDataFile
extends AbstractRequest<LockerEncryptedDataFile> {
    private final PgpKeyId pgpKeyId;
    private final String lockerContentName;
    private final Uid lockerContentVersion;

    public GetLockerEncryptedDataFile(PgpKeyId pgpKeyId, String lockerContentName, Uid lockerContentVersion) {
        this.pgpKeyId = (PgpKeyId)AssertUtil.assertNotNull((String)"pgpKeyId", (Object)pgpKeyId);
        this.lockerContentName = (String)AssertUtil.assertNotNull((String)"lockerContentName", (Object)lockerContentName);
        this.lockerContentVersion = (Uid)AssertUtil.assertNotNull((String)"lockerContentVersion", (Object)lockerContentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LockerEncryptedDataFile execute() {
        InputStream in;
        WebTarget webTarget = this.createWebTarget(new String[]{"_Locker", GetLockerEncryptedDataFile.urlEncode((String)this.pgpKeyId.toString()), GetLockerEncryptedDataFile.urlEncode((String)this.lockerContentName), GetLockerEncryptedDataFile.urlEncode((String)this.lockerContentVersion.toString())});
        try {
            in = (InputStream)this.assignCredentials(webTarget.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE})).get(InputStream.class);
        }
        catch (WebApplicationException x) {
            if (x.getResponse().getStatus() != Response.Status.NOT_FOUND.getStatusCode()) throw x;
            return null;
        }
        try {
            try {
                LockerEncryptedDataFile result;
                if (!in.markSupported()) {
                    in = new BufferedInputStream(in);
                }
                in.mark(10);
                if (in.read() < 0) {
                    LockerEncryptedDataFile x = null;
                    return x;
                }
                in.reset();
                LockerEncryptedDataFile lockerEncryptedDataFile = result = new LockerEncryptedDataFile(in);
                return lockerEncryptedDataFile;
            }
            finally {
                in.close();
            }
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public boolean isResultNullable() {
        return true;
    }
}

