/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.client.pgp.transport;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.client.ClientBuilderDefaultValuesDecorator;
import co.codewizards.cloudstore.rest.client.CloudStoreRestClient;
import co.codewizards.cloudstore.rest.client.CredentialsProvider;
import co.codewizards.cloudstore.rest.client.request.Request;
import co.codewizards.cloudstore.rest.client.ssl.DynamicX509TrustManagerCallback;
import co.codewizards.cloudstore.rest.client.ssl.SSLContextBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Set;
import javax.ws.rs.client.ClientBuilder;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.transport.AbstractPgpTransport;
import org.subshare.rest.client.pgp.transport.RestPgpTransportFactory;
import org.subshare.rest.client.pgp.transport.request.GetLocalRevisionRequest;
import org.subshare.rest.client.pgp.transport.request.GetPgpPublicKeys;
import org.subshare.rest.client.pgp.transport.request.PutPgpPublicKeys;

public class RestPgpTransport
extends AbstractPgpTransport {
    private CloudStoreRestClient client;
    private final CredentialsProvider nullCredentialsProvider = new CredentialsProvider(){

        public String getUserName() {
            return null;
        }

        public String getPassword() {
            return null;
        }
    };

    protected DynamicX509TrustManagerCallback getDynamicX509TrustManagerCallback() {
        RestPgpTransportFactory pgpTransportFactory = (RestPgpTransportFactory)this.getPgpTransportFactory();
        Class<? extends DynamicX509TrustManagerCallback> klass = pgpTransportFactory.getDynamicX509TrustManagerCallbackClass();
        if (klass == null) {
            throw new IllegalStateException("dynamicX509TrustManagerCallbackClass is not set!");
        }
        try {
            DynamicX509TrustManagerCallback instance = klass.newInstance();
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not instantiate class %s: %s", klass.getName(), e.toString()), e);
        }
    }

    protected CloudStoreRestClient getClient() {
        if (this.client == null) {
            ClientBuilder clientBuilder = this.createClientBuilder();
            CloudStoreRestClient c = new CloudStoreRestClient(this.getUrl(), clientBuilder);
            c.setCredentialsProvider(this.nullCredentialsProvider);
            this.client = c;
        }
        return this.client;
    }

    private ClientBuilder createClientBuilder() {
        ClientBuilderDefaultValuesDecorator builder = new ClientBuilderDefaultValuesDecorator();
        try {
            builder.sslContext(SSLContextBuilder.create().remoteURL(this.getUrl()).callback(this.getDynamicX509TrustManagerCallback()).build());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    public long getLocalRevision() {
        Long localRevision = (Long)this.getClient().execute((Request)new GetLocalRevisionRequest());
        return (Long)AssertUtil.assertNotNull((String)"localRevision", (Object)localRevision);
    }

    public Set<PgpKeyId> getMasterKeyIds() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPublicKeys(Set<PgpKeyId> pgpKeyIds, long changedAfterLocalRevision, OutputStream out) {
        InputStream in = (InputStream)this.getClient().execute((Request)new GetPgpPublicKeys(pgpKeyIds, changedAfterLocalRevision));
        if (in == null) {
            return;
        }
        try {
            byte[] buf = new byte[65536];
            try {
                int bytesRead;
                while ((bytesRead = in.read(buf)) >= 0) {
                    out.write(buf, 0, bytesRead);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void importKeys(InputStream in) {
        this.getClient().execute((Request)new PutPgpPublicKeys(in));
    }
}

