/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.dto.jaxb;

import co.codewizards.cloudstore.core.dto.jaxb.CloudStoreJaxbContext;
import co.codewizards.cloudstore.core.io.NoCloseInputStream;
import co.codewizards.cloudstore.core.io.NoCloseOutputStream;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public abstract class DtoIo<D> {
    private final Class<D> dtoClass;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    protected DtoIo() {
        Class c;
        ParameterizedType superclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] actualTypeArguments = superclass.getActualTypeArguments();
        if (actualTypeArguments == null || actualTypeArguments.length < 1) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " has no generic type argument!");
        }
        this.dtoClass = c = (Class)actualTypeArguments[0];
        if (this.dtoClass == null) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " has no generic type argument!");
        }
    }

    public byte[] serialize(D dto) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serialize(dto, out);
        return out.toByteArray();
    }

    public void serialize(D dto, OutputStream out) {
        AssertUtil.assertNotNull("dto", dto);
        AssertUtil.assertNotNull("out", out);
        try {
            this.getMarshaller().marshal(dto, (OutputStream)new NoCloseOutputStream(out));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] serializeWithGz(D dto) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializeWithGz(dto, out);
        return out.toByteArray();
    }

    public void serializeWithGz(D dto, OutputStream out) {
        AssertUtil.assertNotNull("dto", dto);
        AssertUtil.assertNotNull("out", out);
        try (GZIPOutputStream gzOut = new GZIPOutputStream(new NoCloseOutputStream(out));){
            this.getMarshaller().marshal(dto, (OutputStream)gzOut);
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public void serialize(D dto, File file) {
        AssertUtil.assertNotNull("dto", dto);
        AssertUtil.assertNotNull("file", file);
        try (BufferedOutputStream out = new BufferedOutputStream(file.createOutputStream());){
            this.getMarshaller().marshal(dto, (OutputStream)out);
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException("Writing file '" + file.getAbsolutePath() + "' failed: " + e, e);
        }
    }

    public void serializeWithGz(D dto, File file) {
        AssertUtil.assertNotNull("dto", dto);
        AssertUtil.assertNotNull("file", file);
        try (BufferedOutputStream out = new BufferedOutputStream(file.createOutputStream());
             GZIPOutputStream gzOut = new GZIPOutputStream(out);){
            this.getMarshaller().marshal(dto, (OutputStream)gzOut);
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException("Writing file '" + file.getAbsolutePath() + "' failed: " + e, e);
        }
    }

    public D deserialize(byte[] in) {
        AssertUtil.assertNotNull("in", in);
        return this.deserialize(new ByteArrayInputStream(in));
    }

    public D deserialize(InputStream in) {
        AssertUtil.assertNotNull("in", in);
        try {
            return this.dtoClass.cast(this.getUnmarshaller().unmarshal((InputStream)new NoCloseInputStream(in)));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public D deserializeWithGz(byte[] in) {
        AssertUtil.assertNotNull("in", in);
        return this.deserializeWithGz(new ByteArrayInputStream(in));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public D deserializeWithGz(InputStream in) {
        AssertUtil.assertNotNull("in", in);
        try (GZIPInputStream gzIn = new GZIPInputStream(new NoCloseInputStream(in));){
            D d = this.dtoClass.cast(this.getUnmarshaller().unmarshal((InputStream)gzIn));
            return d;
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public D deserialize(File file) {
        AssertUtil.assertNotNull("file", file);
        try (BufferedInputStream in = new BufferedInputStream(file.createInputStream());){
            D d = this.dtoClass.cast(this.getUnmarshaller().unmarshal((InputStream)in));
            return d;
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException("Reading file '" + file.getAbsolutePath() + "' failed: " + e, e);
        }
    }

    /*
     * Exception decompiling
     */
    public D deserializeWithGz(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Marshaller getMarshaller() {
        if (this.marshaller == null) {
            try {
                this.marshaller = CloudStoreJaxbContext.getJaxbContext().createMarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.marshaller;
    }

    private Unmarshaller getUnmarshaller() {
        if (this.unmarshaller == null) {
            try {
                this.unmarshaller = CloudStoreJaxbContext.getJaxbContext().createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.unmarshaller;
    }
}

