/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.UrlEncoder;
import java.io.BufferedInputStream;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtil {
    public static final String CHARSET_NAME_UTF_8 = "UTF-8";
    public static final long GIGABYTE = 0x40000000L;
    public static final String COLLISION_FILE_NAME_INFIX = ".collision";
    private static File tempDir = null;
    private static final Logger logger = LoggerFactory.getLogger(IOUtil.class);

    private IOUtil() {
    }

    @Deprecated
    public static String getRelativePath(File baseDir, String file) throws IOException {
        baseDir = baseDir.isAbsolute() ? OioFileFactory.createFile(IOUtil.simplifyPath(baseDir)) : OioFileFactory.createFile(IOUtil.simplifyPath(baseDir.getAbsoluteFile()));
        File tmpF = OioFileFactory.createFile(file);
        File absFile = tmpF.isAbsolute() ? tmpF : OioFileFactory.createFile(baseDir, file);
        File dest = absFile;
        File b = baseDir;
        String up = "";
        while (b.getParentFile() != null) {
            String res = IOUtil._getRelativePath(b, dest.getAbsolutePath());
            if (res != null) {
                return up + res;
            }
            up = ".." + OioFileFactory.FILE_SEPARATOR + up;
            b = b.getParentFile();
        }
        return absFile.getAbsolutePath();
    }

    @Deprecated
    public static String getRelativePath(File baseDir, File file) throws IOException {
        return IOUtil.getRelativePath(baseDir, file.getPath());
    }

    @Deprecated
    public static String getRelativePath(String baseDir, String file) throws IOException {
        return IOUtil.getRelativePath(OioFileFactory.createFile(baseDir), file);
    }

    private static String _getRelativePath(File baseDir, String file) throws IOException {
        File tmpF = OioFileFactory.createFile(file);
        File absFile = tmpF.isAbsolute() ? tmpF : OioFileFactory.createFile(baseDir, file);
        String absFileStr = null;
        String baseDirStr = null;
        block8: for (int mode_base = 0; mode_base < 2; ++mode_base) {
            switch (mode_base) {
                case 0: {
                    baseDirStr = IOUtil.simplifyPath(baseDir);
                    break;
                }
                case 1: {
                    baseDirStr = baseDir.getCanonicalPath();
                    break;
                }
                default: {
                    throw new IllegalStateException("this should never happen!");
                }
            }
            for (int mode_abs = 0; mode_abs < 2; ++mode_abs) {
                baseDirStr = IOUtil.addFinalSlash(baseDirStr);
                switch (mode_abs) {
                    case 0: {
                        absFileStr = IOUtil.simplifyPath(absFile);
                        break;
                    }
                    case 1: {
                        absFileStr = absFile.getCanonicalPath();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("this should never happen!");
                    }
                }
                if (absFileStr.startsWith(baseDirStr)) continue block8;
                if (mode_base < 1 || mode_abs < 1) continue;
                return null;
            }
        }
        if (baseDirStr == null) {
            throw new NullPointerException("baseDirStr == null");
        }
        if (absFileStr == null) {
            throw new NullPointerException("absFileStr == null");
        }
        return absFileStr.substring(baseDirStr.length(), absFileStr.length());
    }

    public static String simplifyPath(File path) {
        logger.debug("simplifyPath: path='{}'", (Object)path);
        LinkedList<String> dirs = new LinkedList<String>();
        String pathStr = path.getAbsolutePath();
        boolean startWithSeparator = pathStr.startsWith(OioFileFactory.FILE_SEPARATOR);
        StringTokenizer tk = new StringTokenizer(pathStr, OioFileFactory.FILE_SEPARATOR, false);
        while (tk.hasMoreTokens()) {
            String dir = tk.nextToken();
            if (".".equals(dir)) continue;
            if ("..".equals(dir)) {
                if (dirs.isEmpty()) continue;
                dirs.removeLast();
                continue;
            }
            dirs.addLast(dir);
        }
        logger.debug("simplifyPath: dirs='{}'", dirs);
        StringBuffer sb = new StringBuffer();
        for (String dir : dirs) {
            if (startWithSeparator || sb.length() > 0) {
                sb.append(OioFileFactory.FILE_SEPARATOR);
            }
            sb.append(dir);
        }
        return sb.toString();
    }

    public static long transferStreamData(InputStream in, OutputStream out, long inputOffset, long inputLen) throws IOException {
        return IOUtil.transferStreamData(in, out, inputOffset, inputLen, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transferStreamData(InputStream in, OutputStream out, long inputOffset, long inputLen, ProgressMonitor monitor) throws IOException {
        byte[] buf = new byte[16384];
        if (monitor != null) {
            if (inputLen < 0L) {
                monitor.beginTask("Copying data", 100);
            } else {
                monitor.beginTask("Copying data", (int)(inputLen / (long)buf.length) + 1);
            }
        }
        try {
            int bytesRead;
            int transferred = 0;
            if (inputOffset > 0L && in.skip(inputOffset) != inputOffset) {
                throw new IOException("Input skip failed (offset " + inputOffset + ")");
            }
            while ((bytesRead = inputLen >= 0L ? in.read(buf, 0, (int)Math.min((long)buf.length, inputLen - (long)transferred)) : in.read(buf)) >= 0) {
                if (bytesRead > 0) {
                    out.write(buf, 0, bytesRead);
                    if (monitor != null && inputLen >= 0L) {
                        monitor.worked(1);
                    }
                    transferred += bytesRead;
                }
                if (inputLen < 0L || (long)transferred < inputLen) continue;
            }
            out.flush();
            long l = transferred;
            return l;
        }
        finally {
            if (monitor != null) {
                if (inputLen < 0L) {
                    monitor.worked(100);
                }
                monitor.done();
            }
        }
    }

    public static long transferStreamData(InputStream in, OutputStream out) throws IOException {
        return IOUtil.transferStreamData(in, out, 0L, -1L);
    }

    @Deprecated
    public static boolean deleteDirectoryRecursively(File dir) {
        if (!dir.existsNoFollow()) {
            return true;
        }
        try {
            if (dir.delete()) {
                return true;
            }
        }
        catch (SecurityException e) {
            return false;
        }
        if (dir.isDirectory()) {
            File[] content;
            for (File f : content = dir.listFiles()) {
                if (f.isDirectory()) {
                    IOUtil.deleteDirectoryRecursively(f);
                    continue;
                }
                try {
                    f.delete();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        try {
            return dir.delete();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    @Deprecated
    public static boolean deleteDirectoryRecursively(String dir) {
        File dirF = OioFileFactory.createFile(dir);
        return IOUtil.deleteDirectoryRecursively(dirF);
    }

    public static synchronized File createUniqueIncrementalFolder(File rootFolder, String prefix) throws IOException {
        for (int n = 0; n < Integer.MAX_VALUE; ++n) {
            File f = OioFileFactory.createFile(rootFolder, String.format("%s%x", prefix, n));
            if (f.exists()) continue;
            if (!f.mkdirs()) {
                throw new IOException("The directory " + f.getAbsolutePath() + " could not be created");
            }
            return f;
        }
        throw new IOException("Iterated to Integer.MAX_VALUE and could not find a unique folder!");
    }

    public static synchronized File createUniqueRandomFolder(File rootFolder, String prefix, long maxIterations, long uniqueOutOf) throws IOException {
        long count = 0L;
        while (++count <= maxIterations) {
            File f = OioFileFactory.createFile(rootFolder, String.format("%s%x", prefix, (long)(Math.random() * (double)uniqueOutOf)));
            if (f.exists()) continue;
            if (!f.mkdirs()) {
                throw new IOException("The directory " + f.getAbsolutePath() + " could not be created");
            }
            return f;
        }
        throw new IOException("Reached end of maxIteration(" + maxIterations + "), but could not acquire a unique fileName for folder " + rootFolder);
    }

    public static File createUniqueRandomFolder(File rootFolder, String prefix) throws IOException {
        return IOUtil.createUniqueRandomFolder(rootFolder, prefix, 10000L, 10000L);
    }

    public static File getFile(File file, String ... subDirs) {
        File f = file;
        for (String subDir : subDirs) {
            f = OioFileFactory.createFile(f, subDir);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(File file, String text, String encoding) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        OutputStream out = null;
        OutputStreamWriter w = null;
        try {
            out = file.createOutputStream();
            w = new OutputStreamWriter(out, encoding);
            w.write(text);
        }
        finally {
            if (w != null) {
                w.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File f, String encoding) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        if (f.length() > 0x40000000L) {
            throw new IllegalArgumentException("File exceeds 1073741824 bytes: " + f.getAbsolutePath());
        }
        StringBuffer sb = new StringBuffer();
        try (InputStream fin = f.createInputStream();
             InputStreamReader reader = new InputStreamReader(fin, encoding);){
            int bytesRead;
            char[] cbuf = new char[1024];
            while ((bytesRead = reader.read(cbuf)) > 0) {
                sb.append(cbuf, 0, bytesRead);
            }
        }
        return sb.toString();
    }

    public static String readTextFile(File f) throws FileNotFoundException, IOException {
        return IOUtil.readTextFile(f, CHARSET_NAME_UTF_8);
    }

    public static void writeTextFile(File file, String text) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        IOUtil.writeTextFile(file, text, CHARSET_NAME_UTF_8);
    }

    public static String readTextFile(InputStream in, String encoding) throws FileNotFoundException, IOException {
        int bytesRead;
        StringBuffer sb = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(in, encoding);
        char[] cbuf = new char[1024];
        while ((bytesRead = reader.read(cbuf)) > 0) {
            sb.append(cbuf, 0, bytesRead);
            if ((long)sb.length() <= 0x40000000L) continue;
            throw new IllegalArgumentException("Text exceeds 1073741824 bytes!");
        }
        return sb.toString();
    }

    public static String readTextFile(InputStream in) throws FileNotFoundException, IOException {
        return IOUtil.readTextFile(in, CHARSET_NAME_UTF_8);
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int lastIndex = fileName.lastIndexOf(".");
        if (lastIndex < 0) {
            return null;
        }
        return fileName.substring(lastIndex + 1);
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int lastIndex = fileName.lastIndexOf(".");
        if (lastIndex < 0) {
            return fileName;
        }
        return fileName.substring(0, lastIndex);
    }

    public static File getTempDir() {
        if (tempDir == null) {
            tempDir = OioFileFactory.createFile(System.getProperty("java.io.tmpdir"));
        }
        return tempDir;
    }

    public static File createUserTempDir(String prefix, String suffix) throws IOException {
        File userTempDir = IOUtil.getUserTempDir(prefix, suffix);
        if (userTempDir.isDirectory()) {
            return userTempDir;
        }
        if (userTempDir.exists() && !userTempDir.isDirectory()) {
            throw new IOException("The user-dependent temp directory's path exists already, but is no directory: " + userTempDir.getPath());
        }
        if (!userTempDir.mkdirs() && !userTempDir.isDirectory()) {
            throw new IOException("The user-dependent temp directory could not be created: " + userTempDir.getPath());
        }
        return userTempDir;
    }

    public static File getUserTempDir(String prefix, String suffix) {
        String userNameDir = (prefix == null ? "" : prefix) + String.valueOf(IOUtil.getUserName()) + (suffix == null ? "" : suffix);
        userNameDir = UrlEncoder.encode(userNameDir.replace('*', '_'));
        return OioFileFactory.createFile(IOUtil.getTempDir(), userNameDir);
    }

    private static String getUserName() {
        return System.getProperty("user.name");
    }

    public static File getUserHome() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new IllegalStateException("System property user.home is not set! This should never happen!");
        }
        return OioFileFactory.createFile(userHome);
    }

    public static boolean compareInputStreams(InputStream inputStream1, InputStream inputStream2) throws IOException {
        int b1;
        InputStream in2;
        AssertUtil.assertNotNull("inputStream1", inputStream1);
        AssertUtil.assertNotNull("inputStream2", inputStream2);
        InputStream in1 = inputStream1.markSupported() ? inputStream1 : new BufferedInputStream(inputStream1);
        InputStream inputStream = in2 = inputStream2.markSupported() ? inputStream2 : new BufferedInputStream(inputStream2);
        while ((b1 = in1.read()) >= 0) {
            int b2 = in2.read();
            if (b1 == b2) continue;
            return false;
        }
        return in2.read() < 0;
    }

    /*
     * Exception decompiling
     */
    public static boolean compareFiles(File f1, File f2) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void copyDirectory(File sourceDirectory, File destinationDirectory) throws IOException {
        IOUtil.copyDirectory(sourceDirectory, destinationDirectory, null);
    }

    public static void copyDirectory(File sourceDirectory, File destinationDirectory, FileFilter fileFilter) throws IOException {
        File[] files;
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            throw new IOException("No such source directory: " + sourceDirectory.getAbsolutePath());
        }
        if (destinationDirectory.exists()) {
            if (!destinationDirectory.isDirectory()) {
                throw new IOException("Destination exists but is not a directory: " + sourceDirectory.getAbsolutePath());
            }
        } else {
            destinationDirectory.mkdirs();
        }
        for (File file : files = sourceDirectory.listFiles(fileFilter)) {
            File destinationFile = OioFileFactory.createFile(destinationDirectory, file.getName());
            if (file.isDirectory()) {
                if (destinationDirectory.getAbsoluteFile().equals(file.getAbsoluteFile())) {
                    logger.warn("copyDirectory: Skipping directory, because it equals the destination: {}", (Object)file.getAbsoluteFile());
                    continue;
                }
                IOUtil.copyDirectory(file, destinationFile, fileFilter);
                continue;
            }
            IOUtil.copyFile(file, destinationFile);
        }
        destinationDirectory.setLastModified(sourceDirectory.lastModified());
    }

    public static void copyResource(Class<?> sourceResClass, String sourceResName, String destinationFilename) throws IOException {
        IOUtil.copyResource(sourceResClass, sourceResName, OioFileFactory.createFile(destinationFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyResource(Class<?> sourceResClass, String sourceResName, File destinationFile) throws IOException {
        InputStream source = null;
        OutputStream destination = null;
        try {
            source = sourceResClass.getResourceAsStream(sourceResName);
            if (source == null) {
                throw new FileNotFoundException("Class " + sourceResClass.getName() + " could not find resource " + sourceResName);
            }
            if (destinationFile.exists()) {
                if (!destinationFile.isFile()) throw new IOException("FileCopy: destination is not a file: " + destinationFile.getCanonicalPath());
                if (!destinationFile.canWrite()) {
                    throw new IOException("FileCopy: destination file is unwriteable: " + destinationFile.getCanonicalPath());
                }
            } else {
                File parentdir = destinationFile.getAbsoluteFile().getParentFile();
                if (parentdir == null || !parentdir.exists()) {
                    throw new IOException("FileCopy: destination's parent directory doesn't exist: " + destinationFile.getCanonicalPath());
                }
                if (!parentdir.canWrite()) {
                    throw new IOException("FileCopy: destination's parent directory is unwriteable: " + destinationFile.getCanonicalPath());
                }
            }
            destination = destinationFile.createOutputStream();
            IOUtil.transferStreamData(source, destination);
            return;
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void copyFile(File sourceFile, File destinationFile) throws IOException {
        IOUtil.copyFile(sourceFile, destinationFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(File sourceFile, File destinationFile, ProgressMonitor monitor) throws IOException {
        InputStream source = null;
        OutputStream destination = null;
        try {
            if (!sourceFile.exists() || !sourceFile.isFile()) {
                throw new IOException("FileCopy: no such source file: " + sourceFile.getCanonicalPath());
            }
            if (!sourceFile.canRead()) {
                throw new IOException("FileCopy: source file is unreadable: " + sourceFile.getCanonicalPath());
            }
            if (destinationFile.exists()) {
                if (!destinationFile.isFile()) throw new IOException("FileCopy: destination is not a file: " + destinationFile.getCanonicalPath());
                if (!destinationFile.canWrite()) {
                    throw new IOException("FileCopy: destination file is unwriteable: " + destinationFile.getCanonicalPath());
                }
            } else {
                File parentdir = destinationFile.getParentFile();
                if (parentdir == null || !parentdir.exists()) {
                    throw new IOException("FileCopy: destination directory doesn't exist: " + destinationFile.getCanonicalPath());
                }
                if (!parentdir.canWrite()) {
                    throw new IOException("FileCopy: destination directory is unwriteable: " + destinationFile.getCanonicalPath());
                }
            }
            source = sourceFile.createInputStream();
            destination = destinationFile.createOutputStream();
            IOUtil.transferStreamData(source, destination, 0L, sourceFile.length(), monitor);
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
            }
        }
        destinationFile.setLastModified(sourceFile.lastModified());
    }

    public static String addFinalSlash(String directory) {
        if (directory.endsWith(OioFileFactory.FILE_SEPARATOR)) {
            return directory;
        }
        return directory + OioFileFactory.FILE_SEPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceTemplateVariables(File destinationFile, File templateFile, String characterSet, Map<?, ?> variables) throws IOException {
        if (!destinationFile.isAbsolute()) {
            throw new IllegalArgumentException("destinationFile is not absolute: " + destinationFile.getPath());
        }
        logger.info("Creating destination file \"" + destinationFile.getAbsolutePath() + "\" from template \"" + templateFile.getAbsolutePath() + "\".");
        File destinationDirectory = destinationFile.getParentFile();
        if (!destinationDirectory.exists()) {
            logger.info("Directory for destination file does not exist. Creating it: " + destinationDirectory.getAbsolutePath());
            if (!destinationDirectory.mkdirs()) {
                logger.error("Creating directory for destination file failed: " + destinationDirectory.getAbsolutePath());
            }
        }
        try (InputStream fin = templateFile.createInputStream();
             InputStreamReader fr = characterSet != null ? new InputStreamReader(fin, characterSet) : new InputStreamReader(fin);
             OutputStream fos = destinationFile.createOutputStream();
             OutputStreamWriter fw = characterSet != null ? new OutputStreamWriter(fos, characterSet) : new OutputStreamWriter(fos);){
            IOUtil.replaceTemplateVariables(fw, fr, variables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replaceTemplateVariables(String template, Map<?, ?> variables) {
        String string;
        StringReader r = new StringReader(template);
        StringWriter w = new StringWriter();
        try {
            IOUtil.replaceTemplateVariables(w, r, variables);
            w.flush();
            string = w.toString();
            r.close();
        }
        catch (Throwable throwable) {
            try {
                r.close();
                w.close();
                throw throwable;
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
        w.close();
        return string;
    }

    public static void replaceTemplateVariables(Writer writer, Reader reader, Map<?, ?> variables) throws IOException {
        StreamTokenizer stk = new StreamTokenizer(reader);
        stk.resetSyntax();
        stk.wordChars(0, Integer.MAX_VALUE);
        stk.ordinaryChar(36);
        stk.ordinaryChar(123);
        stk.ordinaryChar(125);
        stk.ordinaryChar(10);
        String variableName = null;
        StringBuilder tmpBuf = new StringBuilder();
        ParserExpects parserExpects = ParserExpects.NORMAL;
        while (stk.nextToken() != -1) {
            String stringToWrite = null;
            if (stk.ttype == -3) {
                switch (parserExpects) {
                    case VARIABLE: {
                        parserExpects = ParserExpects.BRACKET_CLOSE;
                        variableName = stk.sval;
                        tmpBuf.append(variableName);
                        break;
                    }
                    case NORMAL: {
                        stringToWrite = stk.sval;
                        break;
                    }
                    default: {
                        parserExpects = ParserExpects.NORMAL;
                        stringToWrite = tmpBuf.toString() + stk.sval;
                        tmpBuf.setLength(0);
                        break;
                    }
                }
            } else if (stk.ttype == 10) {
                stringToWrite = new String(Character.toChars(stk.ttype));
                if (parserExpects != ParserExpects.NORMAL) {
                    parserExpects = ParserExpects.NORMAL;
                    tmpBuf.append(stringToWrite);
                    stringToWrite = tmpBuf.toString();
                    tmpBuf.setLength(0);
                }
            } else if (stk.ttype == 36) {
                if (parserExpects != ParserExpects.NORMAL) {
                    stringToWrite = tmpBuf.toString();
                    tmpBuf.setLength(0);
                }
                tmpBuf.appendCodePoint(stk.ttype);
                parserExpects = ParserExpects.BRACKET_OPEN;
            } else if (stk.ttype == 123) {
                switch (parserExpects) {
                    case NORMAL: {
                        stringToWrite = new String(Character.toChars(stk.ttype));
                        break;
                    }
                    case BRACKET_OPEN: {
                        tmpBuf.appendCodePoint(stk.ttype);
                        parserExpects = ParserExpects.VARIABLE;
                        break;
                    }
                    default: {
                        parserExpects = ParserExpects.NORMAL;
                        tmpBuf.appendCodePoint(stk.ttype);
                        stringToWrite = tmpBuf.toString();
                        tmpBuf.setLength(0);
                        break;
                    }
                }
            } else if (stk.ttype == 125) {
                switch (parserExpects) {
                    case NORMAL: {
                        stringToWrite = new String(Character.toChars(stk.ttype));
                        break;
                    }
                    case BRACKET_CLOSE: {
                        parserExpects = ParserExpects.NORMAL;
                        tmpBuf.appendCodePoint(stk.ttype);
                        if (variableName == null) {
                            throw new IllegalStateException("variableName is null!!!");
                        }
                        Object variableValue = variables.get(variableName);
                        String string = stringToWrite = variableValue == null ? null : variableValue.toString();
                        if (stringToWrite == null) {
                            logger.warn("Variable " + tmpBuf.toString() + " occuring in template is unknown!");
                            stringToWrite = tmpBuf.toString();
                        } else {
                            stringToWrite = IOUtil.replaceTemplateVariables(stringToWrite, variables);
                        }
                        tmpBuf.setLength(0);
                        break;
                    }
                    default: {
                        parserExpects = ParserExpects.NORMAL;
                        tmpBuf.appendCodePoint(stk.ttype);
                        stringToWrite = tmpBuf.toString();
                        tmpBuf.setLength(0);
                    }
                }
            }
            if (stringToWrite == null) continue;
            writer.write(stringToWrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        try (InputStream is = file.createInputStream();){
            int offset;
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        return bytes;
    }

    public static File createCollisionFile(File file) {
        File parentFile = file.getParentFile();
        String fileName = file.getName();
        String fileExtension = IOUtil.nullToEmptyString(IOUtil.getFileExtension(fileName));
        if (!fileExtension.isEmpty()) {
            fileExtension = '.' + fileExtension;
        }
        File result = OioFileFactory.createFile(parentFile, String.format("%s.%s%s%s", fileName, Long.toString(System.currentTimeMillis(), 36) + new Uid(), COLLISION_FILE_NAME_INFIX, fileExtension));
        return result;
    }

    private static String nullToEmptyString(String s) {
        return s == null ? "" : s;
    }

    public static void deleteOrFail(File file) throws IOException {
        file.delete();
        if (file.isSymbolicLink() || file.exists()) {
            throw new IOException("Could not delete file (it still exists after deletion): " + file);
        }
    }

    public static int readOrFail(InputStream in) throws IOException {
        int read = in.read();
        if (read < 0) {
            throw new IOException("Premature end of stream!");
        }
        return read;
    }

    public static void readOrFail(InputStream in, byte[] buf, int off, int len) throws IOException {
        int bytesRead;
        AssertUtil.assertNotNull("buf", buf);
        if (off < 0) {
            throw new IllegalArgumentException("off < 0");
        }
        if (len == 0) {
            return;
        }
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        while ((bytesRead = in.read(buf, off, len)) >= 0) {
            if (bytesRead > 0) {
                off += bytesRead;
                len -= bytesRead;
            }
            if (len < 0) {
                throw new IllegalStateException("len < 0");
            }
            if (len != 0) continue;
            return;
        }
        throw new IOException("Premature end of stream!");
    }

    public static byte[] longToBytes(long value) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(value >>> 8 * (bytes.length - 1 - i));
        }
        return bytes;
    }

    public static long bytesToLong(byte[] bytes) {
        AssertUtil.assertNotNull("bytes", bytes);
        if (bytes.length != 8) {
            throw new IllegalArgumentException("bytes.length != 8");
        }
        long value = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            value |= (long)(bytes[i] & 0xFF) << 8 * (bytes.length - 1 - i);
        }
        return value;
    }

    public static byte[] intToBytes(int value) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(value >>> 8 * (bytes.length - 1 - i));
        }
        return bytes;
    }

    public static int bytesToInt(byte[] bytes) {
        AssertUtil.assertNotNull("bytes", bytes);
        if (bytes.length != 4) {
            throw new IllegalArgumentException("bytes.length != 4");
        }
        int value = 0;
        for (int i = 0; i < bytes.length; ++i) {
            value = (int)((long)value | (long)(bytes[i] & 0xFF) << 8 * (bytes.length - 1 - i));
        }
        return value;
    }

    private static enum ParserExpects {
        NORMAL,
        BRACKET_OPEN,
        VARIABLE,
        BRACKET_CLOSE;

    }
}

