/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto.internal.mac;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Mac;
import org.subshare.crypto.MACCalculator;

public class MACCalculatorImpl
implements MACCalculator {
    private final Mac macEngine;
    private final int keySize;
    private final int ivSize;
    private CipherParameters parameters;
    private String algorithmName;

    public MACCalculatorImpl(Mac macEngine, int keySize, int ivSize) {
        if (macEngine == null) {
            throw new IllegalArgumentException("macEngine == null");
        }
        this.macEngine = macEngine;
        this.keySize = keySize;
        this.ivSize = ivSize;
    }

    public void init(CipherParameters params) throws IllegalArgumentException {
        this.macEngine.init(params);
        this.parameters = params;
    }

    @Override
    public CipherParameters getParameters() {
        return this.parameters;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public int getIVSize() {
        return this.ivSize;
    }

    @Override
    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithmName() {
        if (this.algorithmName != null) {
            return this.algorithmName;
        }
        return this.macEngine.getAlgorithmName();
    }

    public int getMacSize() {
        return this.macEngine.getMacSize();
    }

    public void update(byte in) throws IllegalStateException {
        this.macEngine.update(in);
    }

    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        this.macEngine.update(in, inOff, len);
    }

    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        return this.macEngine.doFinal(out, outOff);
    }

    @Override
    public byte[] doFinal(byte[] in) throws IllegalStateException {
        byte[] mac = new byte[this.getMacSize()];
        this.update(in, 0, in.length);
        this.doFinal(mac, 0);
        return mac;
    }

    public void reset() {
        this.macEngine.reset();
    }
}

