/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.core.invoke.Invoker;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRef;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRefWithRefId;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncDecRefCountQueue {
    private static final Logger logger = LoggerFactory.getLogger(IncDecRefCountQueue.class);
    protected static final long INC_DEC_REF_COUNT_PERIOD_MS = 5000L;
    private final List<ObjectRefWithRefId> incEntries = Collections.synchronizedList(new LinkedList());
    private final List<ObjectRefWithRefId> decEntries = Collections.synchronizedList(new LinkedList());
    private final Timer incDecRefCountTimer = new Timer("incDecRefCountTimer-" + Integer.toHexString(System.identityHashCode(this)), true);
    private final TimerTask incDecRefCountTimerTask = new TimerTask(){

        @Override
        public void run() {
            try {
                ObjectRefWithRefId[] incEntries = IncDecRefCountQueue.this.popIncEntries();
                if (incEntries.length > 0) {
                    IncDecRefCountQueue.this.invoker.invokeStatic(ObjectRef.class, "*objectRef_incRefCount*", (Class[])null, new Object[]{incEntries});
                }
            }
            catch (Exception x) {
                logger.error("incDecRefCountTimerTask.run: " + x, (Throwable)x);
            }
            try {
                ObjectRefWithRefId[] decEntries = IncDecRefCountQueue.this.popDecEntries();
                if (decEntries.length > 0) {
                    IncDecRefCountQueue.this.invoker.invokeStatic(ObjectRef.class, "*objectRef_decRefCount*", (Class[])null, new Object[]{decEntries});
                }
            }
            catch (Exception x) {
                logger.error("incDecRefCountTimerTask.run: " + x, (Throwable)x);
            }
        }
    };
    private final Invoker invoker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectRefWithRefId[] popIncEntries() {
        ObjectRefWithRefId[] result;
        List<ObjectRefWithRefId> list = this.incEntries;
        synchronized (list) {
            result = this.incEntries.toArray(new ObjectRefWithRefId[this.incEntries.size()]);
            this.incEntries.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectRefWithRefId[] popDecEntries() {
        ObjectRefWithRefId[] result;
        List<ObjectRefWithRefId> list = this.decEntries;
        synchronized (list) {
            result = this.decEntries.toArray(new ObjectRefWithRefId[this.decEntries.size()]);
            this.decEntries.clear();
        }
        return result;
    }

    public IncDecRefCountQueue(Invoker invoker) {
        this.invoker = (Invoker)AssertUtil.assertNotNull((String)"invoker", (Object)invoker);
        this.incDecRefCountTimer.schedule(this.incDecRefCountTimerTask, 5000L, 5000L);
    }

    public void incRefCount(ObjectRef objectRef, Uid refId) {
        this.incEntries.add(new ObjectRefWithRefId(objectRef, refId));
    }

    public void decRefCount(ObjectRef objectRef, Uid refId) {
        this.decEntries.add(new ObjectRefWithRefId(objectRef, refId));
    }
}

