/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.provider;

import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.core.provider.JavaNativeMessageBodyReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

class ExtObjectInputStream
extends ObjectInputStream {
    private ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
    private ClassLoader staticClassLoader = JavaNativeMessageBodyReader.getClassLoader();

    public ExtObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        block7: {
            try {
                return super.resolveClass(desc);
            }
            catch (ClassNotFoundException x) {
                Util.doNothing();
            }
            catch (NoClassDefFoundError x) {
                Util.doNothing();
            }
            try {
                return Class.forName(desc.getName(), false, this.contextClassLoader);
            }
            catch (ClassNotFoundException x) {
                if (this.staticClassLoader == null) {
                    throw x;
                }
            }
            catch (NoClassDefFoundError x) {
                if (this.staticClassLoader != null) break block7;
                throw x;
            }
        }
        return Class.forName(desc.getName(), false, this.staticClassLoader);
    }
}

