/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.io;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.UUID;

public interface InputStreamSource {
    public InputStream createInputStream() throws IOException;

    public void discard() throws IOException;

    public static class Helper {
        public static InputStreamSource createInputStreamSource(final byte[] bytes) {
            return new InputStreamSource(){
                private byte[] byteArray;
                {
                    this.byteArray = bytes;
                }

                @Override
                public InputStream createInputStream() throws IOException {
                    return new ByteArrayInputStream(this.byteArray == null ? new byte[]{} : this.byteArray){

                        @Override
                        public void close() throws IOException {
                            1.access$002(this, null);
                            super.close();
                        }
                    };
                }

                @Override
                public void discard() {
                }

                static /* synthetic */ byte[] access$002(1 x0, byte[] x1) {
                    x0.byteArray = x1;
                    return x1;
                }
            };
        }

        public static InputStreamSource createInputStreamSource(Uid uid) {
            return Helper.createInputStreamSource(uid == null ? null : uid.toBytes());
        }

        public static InputStreamSource createInputStreamSource(UUID uuid) {
            return Helper.createInputStreamSource(uuid == null ? null : new Uid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()));
        }

        public static InputStreamSource createInputStreamSource(boolean b) {
            byte[] byArray;
            if (b) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            return Helper.createInputStreamSource(byArray);
        }

        public static InputStreamSource createInputStreamSource(Boolean b) {
            if (b == null) {
                return Helper.createInputStreamSource((byte[])null);
            }
            return Helper.createInputStreamSource((boolean)b);
        }

        public static InputStreamSource createInputStreamSource(byte value) {
            return Helper.createInputStreamSource(new byte[]{value});
        }

        public static InputStreamSource createInputStreamSource(Byte value) {
            if (value == null) {
                return Helper.createInputStreamSource((byte[])null);
            }
            return Helper.createInputStreamSource((byte)value);
        }

        public static InputStreamSource createInputStreamSource(int value) {
            return Helper.createInputStreamSource(IOUtil.intToBytes((int)value));
        }

        public static InputStreamSource createInputStreamSource(Integer value) {
            if (value == null) {
                return Helper.createInputStreamSource((byte[])null);
            }
            return Helper.createInputStreamSource((int)value);
        }

        public static InputStreamSource createInputStreamSource(long value) {
            return Helper.createInputStreamSource(IOUtil.longToBytes((long)value));
        }

        public static InputStreamSource createInputStreamSource(Long value) {
            if (value == null) {
                return Helper.createInputStreamSource((byte[])null);
            }
            return Helper.createInputStreamSource((long)value);
        }

        public static InputStreamSource createInputStreamSource(String value) {
            if (value == null) {
                return Helper.createInputStreamSource((byte[])null);
            }
            try {
                return Helper.createInputStreamSource(value.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public static InputStreamSource createInputStreamSource(Date value) {
            return Helper.createInputStreamSource(value == null ? null : Long.valueOf(value.getTime()));
        }

        public static InputStreamSource createInputStreamSource(final InputStream in) {
            if (in == null) {
                return Helper.createInputStreamSource((byte[])null);
            }
            return new InputStreamSource(){

                @Override
                public InputStream createInputStream() throws IOException {
                    return in;
                }

                @Override
                public void discard() throws IOException {
                    in.close();
                }
            };
        }

        public static InputStreamSource createInputStreamSource(final File file) {
            if (file == null) {
                return Helper.createInputStreamSource((byte[])null);
            }
            return new InputStreamSource(){

                @Override
                public InputStream createInputStream() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public void discard() {
                }
            };
        }
    }
}

