/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.subshare.core.pgp.ImportKeysResult;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpDecoder;
import org.subshare.core.pgp.PgpEncoder;
import org.subshare.core.pgp.PgpKey;

public abstract class AbstractPgp
implements Pgp {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public PgpEncoder createEncoder(InputStream in, OutputStream out) {
        PgpEncoder encoder = this._createEncoder();
        encoder.setInputStream(in);
        encoder.setOutputStream(out);
        return encoder;
    }

    protected abstract PgpEncoder _createEncoder();

    @Override
    public PgpDecoder createDecoder(InputStream in, OutputStream out) {
        PgpDecoder decoder = this._createDecoder();
        decoder.setInputStream(in);
        decoder.setOutputStream(out);
        return decoder;
    }

    protected abstract PgpDecoder _createDecoder();

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(Pgp.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(Pgp.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    protected void firePropertyChange(Pgp.Property property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }

    @Override
    public void exportPublicKeysWithSecretKeys(Set<PgpKey> pgpKeys, File file) {
        AssertUtil.assertNotNull((String)"pgpKeys", pgpKeys);
        try (OutputStream out = ((File)AssertUtil.assertNotNull((String)"file", (Object)file)).createOutputStream();){
            this.exportPublicKeysWithSecretKeys(pgpKeys, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void exportPublicKeys(Set<PgpKey> pgpKeys, File file) {
        AssertUtil.assertNotNull((String)"pgpKeys", pgpKeys);
        try (OutputStream out = ((File)AssertUtil.assertNotNull((String)"file", (Object)file)).createOutputStream();){
            this.exportPublicKeys(pgpKeys, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] exportPublicKeys(Set<PgpKey> pgpKeys) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.exportPublicKeys(pgpKeys, bout);
        return bout.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImportKeysResult importKeys(File file) {
        try (InputStream in = ((File)AssertUtil.assertNotNull((String)"file", (Object)file)).createInputStream();){
            ImportKeysResult importKeysResult = this.importKeys(in);
            return importKeysResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImportKeysResult importKeys(byte[] data) {
        return this.importKeys(new ByteArrayInputStream(data));
    }
}

