/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.gnupg;

import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.pgp.AbstractPgpDecoder;
import org.subshare.core.pgp.MissingSigningPgpKeyException;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.gnupg.BcPgpKey;
import org.subshare.core.pgp.gnupg.BcWithLocalGnuPgPgp;

public class BcPgpDecoder
extends AbstractPgpDecoder {
    private static final Logger logger = LoggerFactory.getLogger(BcPgpDecoder.class);
    private final BcWithLocalGnuPgPgp pgp;

    public BcPgpDecoder(BcWithLocalGnuPgPgp pgp) {
        this.pgp = (BcWithLocalGnuPgPgp)AssertUtil.assertNotNull((String)"pgp", (Object)pgp);
    }

    @Override
    public void decode() throws SignatureException, IOException {
        this.setDecryptPgpKey(null);
        this.setSignPgpKey(null);
        this.setPgpSignature(null);
        this.setSignPgpKeyIds(null);
        InputStream in = this.getInputStreamOrFail();
        InputStream signIn = this.getSignInputStream();
        if (signIn == null) {
            in = PGPUtil.getDecoderStream((InputStream)in);
        }
        if (signIn != null) {
            signIn = PGPUtil.getDecoderStream((InputStream)signIn);
            this.decodePlainWithDetachedSignature(in, signIn);
        } else {
            PGPObjectFactory pgpF = new PGPObjectFactory(in, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            PGPEncryptedDataList enc = null;
            PGPCompressedData comp = null;
            Object o = pgpF.nextObject();
            if (o instanceof PGPEncryptedDataList) {
                enc = (PGPEncryptedDataList)o;
            } else if (o instanceof PGPCompressedData) {
                enc = null;
                comp = (PGPCompressedData)o;
            } else {
                o = pgpF.nextObject();
                if (o instanceof PGPEncryptedDataList) {
                    enc = (PGPEncryptedDataList)o;
                } else if (o instanceof PGPCompressedData) {
                    enc = null;
                    comp = (PGPCompressedData)o;
                }
            }
            if (enc != null) {
                this.decodeEncrypted(enc);
            } else if (comp != null) {
                this.decodeCompressed(comp);
            } else {
                throw new IllegalStateException("WTF?!");
            }
        }
    }

    private void decodePlainWithDetachedSignature(InputStream in, InputStream signIn) throws SignatureException, IOException {
        AssertUtil.assertNotNull((String)"in", (Object)in);
        AssertUtil.assertNotNull((String)"signIn", (Object)signIn);
        PGPObjectFactory pgpF = new PGPObjectFactory(signIn, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPOnePassSignatureList onePassSignatureList = null;
        PGPSignatureList signatureList = null;
        try {
            Object message = pgpF.nextObject();
            while (message != null) {
                if (message instanceof PGPOnePassSignatureList) {
                    onePassSignatureList = (PGPOnePassSignatureList)message;
                } else if (message instanceof PGPSignatureList) {
                    signatureList = (PGPSignatureList)message;
                } else {
                    throw new PGPException("message unknown message type.");
                }
                message = pgpF.nextObject();
            }
            if (onePassSignatureList == null || signatureList == null) {
                throw new PGPException("Poor PGP. Signatures not found.");
            }
            this.verifySignature(onePassSignatureList, signatureList, in, this.getOutputStreamOrFail());
        }
        catch (PGPException x) {
            throw new IOException(x);
        }
    }

    private void decodeCompressed(PGPCompressedData comp) throws SignatureException, IOException {
        try {
            PGPObjectFactory plainFact = new PGPObjectFactory(comp.getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            Object message = null;
            PGPOnePassSignatureList onePassSignatureList = null;
            PGPSignatureList signatureList = null;
            PGPCompressedData compressedData = null;
            message = plainFact.nextObject();
            ByteArrayOutputStream actualOutput = new ByteArrayOutputStream();
            while (message != null) {
                if (message instanceof PGPCompressedData) {
                    compressedData = (PGPCompressedData)message;
                    plainFact = new PGPObjectFactory(compressedData.getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                    message = plainFact.nextObject();
                }
                if (message instanceof PGPLiteralData) {
                    Streams.pipeAll((InputStream)((PGPLiteralData)message).getInputStream(), (OutputStream)actualOutput);
                } else if (message instanceof PGPOnePassSignatureList) {
                    onePassSignatureList = (PGPOnePassSignatureList)message;
                } else if (message instanceof PGPSignatureList) {
                    signatureList = (PGPSignatureList)message;
                } else {
                    throw new PGPException("message unknown message type.");
                }
                message = plainFact.nextObject();
            }
            actualOutput.close();
            byte[] output = actualOutput.toByteArray();
            if (onePassSignatureList == null || signatureList == null) {
                throw new PGPException("Poor PGP. Signatures not found.");
            }
            this.verifySignature(onePassSignatureList, signatureList, new ByteArrayInputStream(output), this.getOutputStreamOrFail());
        }
        catch (PGPException x) {
            throw new IOException(x);
        }
    }

    private void decodeEncrypted(PGPEncryptedDataList enc) throws SignatureException, IOException {
        try {
            Iterator it = enc.getEncryptedDataObjects();
            PgpKey decryptPgpKey = null;
            PGPPrivateKey sKey = null;
            PGPPublicKeyEncryptedData pbe = null;
            ArrayList<PgpKeyId> encryptPgpKeyIds = new ArrayList<PgpKeyId>();
            while (sKey == null && it.hasNext()) {
                char[] passphrase;
                PGPSecretKey secretKey;
                pbe = (PGPPublicKeyEncryptedData)it.next();
                PgpKeyId pgpKeyId = new PgpKeyId(pbe.getKeyID());
                encryptPgpKeyIds.add(pgpKeyId);
                BcPgpKey bcPgpKey = this.pgp.getBcPgpKey(pgpKeyId);
                if (bcPgpKey == null || (secretKey = bcPgpKey.getSecretKey()) == null || secretKey.isPrivateKeyEmpty()) continue;
                if (secretKey.getKeyEncryptionAlgorithm() != 0) {
                    passphrase = this.getPgpAuthenticationCallbackOrFail().getPassphrase(bcPgpKey.getPgpKey());
                    if (passphrase == null) {
                        secretKey = null;
                    }
                } else {
                    passphrase = null;
                }
                if (secretKey == null) continue;
                sKey = secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passphrase));
                decryptPgpKey = (PgpKey)AssertUtil.assertNotNull((String)"bcPgpKey.pgpKey", (Object)bcPgpKey.getPgpKey());
            }
            logger.debug("decodeEncrypted: encryptingPgpKeyIds={}", encryptPgpKeyIds);
            if (sKey == null) {
                if (!encryptPgpKeyIds.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Data is encrypted for the PGP keys %s, which we do not have a private key for!", encryptPgpKeyIds));
                }
                throw new IllegalArgumentException("message not found.");
            }
            this.setDecryptPgpKey(decryptPgpKey);
            BcPublicKeyDataDecryptorFactory dataDecryptorFactory = new BcPublicKeyDataDecryptorFactory(sKey);
            InputStream clear = pbe.getDataStream((PublicKeyDataDecryptorFactory)dataDecryptorFactory);
            PGPObjectFactory plainFact = new PGPObjectFactory(clear, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            Object message = null;
            PGPOnePassSignatureList onePassSignatureList = null;
            PGPSignatureList signatureList = null;
            PGPCompressedData compressedData = null;
            message = plainFact.nextObject();
            ByteArrayOutputStream actualOutput = new ByteArrayOutputStream();
            while (message != null) {
                if (message instanceof PGPCompressedData) {
                    compressedData = (PGPCompressedData)message;
                    plainFact = new PGPObjectFactory(compressedData.getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                    message = plainFact.nextObject();
                }
                if (message instanceof PGPLiteralData) {
                    Streams.pipeAll((InputStream)((PGPLiteralData)message).getInputStream(), (OutputStream)actualOutput);
                } else if (message instanceof PGPOnePassSignatureList) {
                    onePassSignatureList = (PGPOnePassSignatureList)message;
                } else if (message instanceof PGPSignatureList) {
                    signatureList = (PGPSignatureList)message;
                } else {
                    throw new PGPException("message unknown message type.");
                }
                message = plainFact.nextObject();
            }
            actualOutput.close();
            byte[] output = actualOutput.toByteArray();
            if (onePassSignatureList != null && signatureList != null) {
                this.verifySignature(onePassSignatureList, signatureList, new ByteArrayInputStream(output), this.getOutputStreamOrFail());
            }
            if (this.getPgpSignature() == null) {
                this.getOutputStreamOrFail().write(output);
            }
            if (pbe.isIntegrityProtected() && !pbe.verify()) {
                throw new PGPException("Data is integrity protected but integrity is lost.");
            }
        }
        catch (PGPException x) {
            throw new IOException(x);
        }
    }

    private void verifySignature(PGPOnePassSignatureList onePassSignatureList, PGPSignatureList signatureList, InputStream signedDataIn, OutputStream signedDataOut) throws SignatureException, IOException {
        AssertUtil.assertNotNull((String)"onePassSignatureList", (Object)onePassSignatureList);
        AssertUtil.assertNotNull((String)"signatureList", (Object)signatureList);
        AssertUtil.assertNotNull((String)"signedDataIn", (Object)signedDataIn);
        this.setSignPgpKey(null);
        this.setPgpSignature(null);
        this.setSignPgpKeyIds(null);
        if (onePassSignatureList.size() == 0) {
            return;
        }
        HashSet<PgpKeyId> pgpKeyIds = new HashSet<PgpKeyId>();
        try {
            PGPPublicKey publicKey = null;
            for (int i = 0; i < onePassSignatureList.size(); ++i) {
                int bytesRead;
                BcPgpKey bcPgpKey;
                PGPOnePassSignature ops = onePassSignatureList.get(i);
                pgpKeyIds.add(new PgpKeyId(ops.getKeyID()));
                if (this.getPgpSignature() != null || (bcPgpKey = this.pgp.getBcPgpKey(new PgpKeyId(ops.getKeyID()))) == null) continue;
                publicKey = bcPgpKey.getPublicKey();
                ops.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), publicKey);
                byte[] buf = new byte[65536];
                while ((bytesRead = signedDataIn.read(buf)) > 0) {
                    ops.update(buf, 0, bytesRead);
                    if (signedDataOut == null) continue;
                    signedDataOut.write(buf, 0, bytesRead);
                }
                PGPSignature signature = signatureList.get(i);
                if (ops.verify(signature)) {
                    this.setSignPgpKey(bcPgpKey.getPgpKey());
                    this.setPgpSignature(this.pgp.createPgpSignature(signature));
                    continue;
                }
                throw new SignatureException("Signature verification failed!");
            }
        }
        catch (PGPException x) {
            throw new IOException(x);
        }
        this.setSignPgpKeyIds(pgpKeyIds);
        logger.debug("verifySignature: signingPgpKeyIds={}", pgpKeyIds);
        if (this.getPgpSignature() == null && this.isFailOnMissingSignPgpKey()) {
            throw new MissingSigningPgpKeyException(pgpKeyIds, "The data was signed using the following PGP-keys, of which none could be found in the local key-ring: " + pgpKeyIds);
        }
    }
}

