/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.gnupg;

import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.CollectionUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.DSAParametersGenerator;
import org.bouncycastle.crypto.generators.ElGamalParametersGenerator;
import org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;
import org.bouncycastle.openpgp.wot.OwnerTrust;
import org.bouncycastle.openpgp.wot.TrustDb;
import org.bouncycastle.openpgp.wot.Validity;
import org.bouncycastle.openpgp.wot.key.PgpKeyRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.pgp.AbstractPgp;
import org.subshare.core.pgp.CreatePgpKeyParam;
import org.subshare.core.pgp.ImportKeysResult;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpDecoder;
import org.subshare.core.pgp.PgpEncoder;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpKeyValidity;
import org.subshare.core.pgp.PgpOwnerTrust;
import org.subshare.core.pgp.PgpSignature;
import org.subshare.core.pgp.PgpSignatureType;
import org.subshare.core.pgp.PgpUserId;
import org.subshare.core.pgp.PgpUserIdNameHash;
import org.subshare.core.pgp.gnupg.BcPgpDecoder;
import org.subshare.core.pgp.gnupg.BcPgpEncoder;
import org.subshare.core.pgp.gnupg.BcPgpKey;
import org.subshare.core.pgp.gnupg.GnuPgDir;
import org.subshare.core.pgp.gnupg.TrustDbFactory;
import org.subshare.crypto.CryptoRegistry;

public class BcWithLocalGnuPgPgp
extends AbstractPgp {
    private static final Logger logger = LoggerFactory.getLogger(BcWithLocalGnuPgPgp.class);
    private File configDir;
    private File gnuPgDir;
    private File pubringFile;
    private File secringFile;
    private File trustDbFile;
    private volatile long pubringFileLastModified = Long.MIN_VALUE;
    private volatile long secringFileLastModified = Long.MIN_VALUE;
    private Map<PgpKeyId, BcPgpKey> pgpKeyId2bcPgpKey;
    private Map<PgpKeyId, BcPgpKey> pgpKeyId2masterKey;
    private Properties gpgProperties;
    private final Map<String, Object> pgpKeyIdRange2Mutex = new HashMap<String, Object>();
    private final Map<String, Properties> pgpKeyIdRange2LocalRevisionProperties = Collections.synchronizedMap(new HashMap());
    private SecureRandom secureRandom;
    private PgpKeyRegistry pgpKeyRegistry;
    private TrustDbFactory trustDbFactory;
    private static final String PGP_PROPERTY_KEY_PUBRING_FILE_LAST_MODIFIED = "pubringFileLastModified";
    private static final String PGP_PROPERTY_KEY_SECRING_FILE_LAST_MODIFIED = "secringFileLastModified";
    private static final String PGP_PROPERTY_KEY_LOCAL_REVISION = "localRevision";

    @Deprecated
    public BcWithLocalGnuPgPgp() {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    public File getGnuPgDir() {
        if (this.gnuPgDir == null) {
            this.gnuPgDir = GnuPgDir.getInstance().getFile();
        }
        return this.gnuPgDir;
    }

    @Override
    public Collection<PgpKey> getMasterKeys() {
        this.loadIfNeeded();
        ArrayList<PgpKey> pgpKeys = new ArrayList<PgpKey>(this.pgpKeyId2masterKey.size());
        for (BcPgpKey bcPgpKey : this.pgpKeyId2masterKey.values()) {
            pgpKeys.add(bcPgpKey.getPgpKey());
        }
        return Collections.unmodifiableList(pgpKeys);
    }

    @Override
    public PgpKey getPgpKey(PgpKeyId pgpKeyId) {
        AssertUtil.assertNotNull((String)"pgpKeyId", (Object)pgpKeyId);
        this.loadIfNeeded();
        if (PgpKey.TEST_DUMMY_PGP_KEY_ID.equals(pgpKeyId)) {
            return PgpKey.TEST_DUMMY_PGP_KEY;
        }
        BcPgpKey bcPgpKey = this.pgpKeyId2bcPgpKey.get(pgpKeyId);
        PgpKey result = bcPgpKey == null ? null : bcPgpKey.getPgpKey();
        return result;
    }

    @Override
    public synchronized void exportPublicKeysWithSecretKeys(Set<PgpKey> pgpKeys, OutputStream out) {
        AssertUtil.assertNotNull((String)"pgpKeys", pgpKeys);
        AssertUtil.assertNotNull((String)"out", (Object)out);
        if (!(out instanceof BCPGOutputStream)) {
            out = new BCPGOutputStream(out);
        }
        try {
            for (PgpKey pgpKey : pgpKeys) {
                BcPgpKey bcPgpKey = this.getBcPgpKeyOrFail(pgpKey);
                bcPgpKey.getPublicKeyRing().encode(out);
                PGPSecretKeyRing secretKeyRing = bcPgpKey.getSecretKeyRing();
                if (secretKeyRing == null) continue;
                secretKeyRing.encode(out);
            }
            out.flush();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    public byte[] exportPublicKeysWithSecretKeys(Set<PgpKey> pgpKeys) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.exportPublicKeysWithSecretKeys(pgpKeys, bout);
        return bout.toByteArray();
    }

    @Override
    public synchronized void exportPublicKeys(Set<PgpKey> pgpKeys, OutputStream out) {
        AssertUtil.assertNotNull((String)"pgpKeys", pgpKeys);
        AssertUtil.assertNotNull((String)"out", (Object)out);
        if (!(out instanceof BCPGOutputStream)) {
            out = new BCPGOutputStream(out);
        }
        try {
            for (PgpKey pgpKey : pgpKeys) {
                BcPgpKey bcPgpKey = this.getBcPgpKeyOrFail(pgpKey);
                bcPgpKey.getPublicKeyRing().encode(out);
            }
            out.flush();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    public synchronized ImportKeysResult importKeys(InputStream in) {
        AssertUtil.assertNotNull((String)"in", (Object)in);
        ImportKeysResult importKeysResult = new ImportKeysResult();
        boolean modified = false;
        try {
            Object o;
            in = PGPUtil.getDecoderStream((InputStream)in);
            PGPObjectFactory pgpF = new PGPObjectFactory(in, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            while ((o = pgpF.nextObject()) != null) {
                if (o instanceof PGPPublicKeyRing) {
                    modified |= this.importPublicKeyRing(importKeysResult, (PGPPublicKeyRing)o);
                    continue;
                }
                if (o instanceof PGPSecretKeyRing) {
                    modified |= this.importSecretKeyRing(importKeysResult, (PGPSecretKeyRing)o);
                    continue;
                }
                throw new IllegalStateException("Unexpected object in InputStream (only PGPPublicKeyRing and PGPSecretKeyRing are supported): " + o);
            }
        }
        catch (IOException | PGPException x) {
            throw new RuntimeException(x);
        }
        if (modified) {
            this.incLocalRevision();
        }
        return importKeysResult;
    }

    private boolean importPublicKeyRing(ImportKeysResult importKeysResult, PGPPublicKeyRing publicKeyRing) throws IOException, PGPException {
        PGPPublicKeyRingCollection oldPublicKeyRingCollection;
        AssertUtil.assertNotNull((String)"publicKeyRing", (Object)publicKeyRing);
        File pubringFile = this.getPubringFile();
        if (!pubringFile.isFile()) {
            oldPublicKeyRingCollection = new PGPPublicKeyRingCollection((InputStream)new ByteArrayInputStream(new byte[0]), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        } else {
            try (BufferedInputStream in = new BufferedInputStream(pubringFile.createInputStream());){
                oldPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            }
        }
        PGPPublicKeyRingCollection newPublicKeyRingCollection = oldPublicKeyRingCollection;
        newPublicKeyRingCollection = this.mergePublicKeyRing(importKeysResult, newPublicKeyRingCollection, publicKeyRing);
        if (oldPublicKeyRingCollection != newPublicKeyRingCollection) {
            File tmpFile = OioFileFactory.createFile((File)pubringFile.getParentFile(), (String[])new String[]{pubringFile.getName() + ".tmp"});
            try (BufferedOutputStream out = new BufferedOutputStream(tmpFile.createOutputStream());){
                newPublicKeyRingCollection.encode((OutputStream)out);
            }
            pubringFile.delete();
            tmpFile.renameTo(pubringFile);
            this.markStale();
            return true;
        }
        return false;
    }

    public void markStale() {
        this.pubringFileLastModified = 0L;
    }

    private PGPPublicKeyRingCollection mergePublicKeyRing(ImportKeysResult importKeysResult, PGPPublicKeyRingCollection publicKeyRingCollection, PGPPublicKeyRing publicKeyRing) throws PGPException {
        AssertUtil.assertNotNull((String)"publicKeyRingCollection", (Object)publicKeyRingCollection);
        AssertUtil.assertNotNull((String)"publicKeyRing", (Object)publicKeyRing);
        PgpKeyId masterKeyId = new PgpKeyId(publicKeyRing.getPublicKey().getKeyID());
        ImportKeysResult.ImportedMasterKey importedMasterKey = importKeysResult.getPgpKeyId2ImportedMasterKey().get(masterKeyId);
        if (importedMasterKey == null) {
            importedMasterKey = new ImportKeysResult.ImportedMasterKey(masterKeyId);
            importKeysResult.getPgpKeyId2ImportedMasterKey().put(masterKeyId, importedMasterKey);
        }
        Iterator it = publicKeyRing.getPublicKeys();
        while (it.hasNext()) {
            ImportKeysResult.ImportedSubKey importedSubKey;
            PGPPublicKey publicKey = (PGPPublicKey)it.next();
            PgpKeyId subKeyId = new PgpKeyId(publicKey.getKeyID());
            if (masterKeyId.equals(subKeyId) || (importedSubKey = importedMasterKey.getPgpKeyId2ImportedSubKey().get(subKeyId)) != null) continue;
            importedSubKey = new ImportKeysResult.ImportedSubKey(subKeyId, importedMasterKey);
            importedMasterKey.getPgpKeyId2ImportedSubKey().put(subKeyId, importedSubKey);
        }
        PGPPublicKeyRing oldPublicKeyRing = publicKeyRingCollection.getPublicKeyRing(publicKeyRing.getPublicKey().getKeyID());
        if (oldPublicKeyRing == null) {
            publicKeyRingCollection = PGPPublicKeyRingCollection.addPublicKeyRing((PGPPublicKeyRingCollection)publicKeyRingCollection, (PGPPublicKeyRing)publicKeyRing);
        } else {
            PGPPublicKeyRing newPublicKeyRing = oldPublicKeyRing;
            Iterator it2 = publicKeyRing.getPublicKeys();
            while (it2.hasNext()) {
                PGPPublicKey publicKey = (PGPPublicKey)it2.next();
                newPublicKeyRing = this.mergePublicKey(newPublicKeyRing, publicKey);
            }
            if (newPublicKeyRing != oldPublicKeyRing) {
                PGPPublicKeyRing pkr = (publicKeyRingCollection = PGPPublicKeyRingCollection.removePublicKeyRing((PGPPublicKeyRingCollection)publicKeyRingCollection, (PGPPublicKeyRing)oldPublicKeyRing)).getPublicKeyRing(publicKeyRing.getPublicKey().getKeyID());
                if (pkr != null) {
                    throw new IllegalStateException("PGPPublicKeyRingCollection.removePublicKeyRing(...) had no effect!");
                }
                publicKeyRingCollection = PGPPublicKeyRingCollection.addPublicKeyRing((PGPPublicKeyRingCollection)publicKeyRingCollection, (PGPPublicKeyRing)newPublicKeyRing);
            }
        }
        return publicKeyRingCollection;
    }

    private PGPPublicKeyRing mergePublicKey(PGPPublicKeyRing publicKeyRing, PGPPublicKey publicKey) {
        AssertUtil.assertNotNull((String)"publicKeyRing", (Object)publicKeyRing);
        AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
        PGPPublicKey oldPublicKey = publicKeyRing.getPublicKey(publicKey.getKeyID());
        if (oldPublicKey == null) {
            publicKeyRing = PGPPublicKeyRing.insertPublicKey((PGPPublicKeyRing)publicKeyRing, (PGPPublicKey)publicKey);
        } else {
            PGPSignature signature;
            Iterator it;
            PGPPublicKey newPublicKey = oldPublicKey;
            Iterator it2 = CollectionUtil.nullToEmpty((Iterator)publicKey.getKeySignatures());
            while (it2.hasNext()) {
                PGPSignature signature2 = (PGPSignature)it2.next();
                newPublicKey = this.mergeKeySignature(newPublicKey, signature2);
            }
            Iterator uit = CollectionUtil.nullToEmpty((Iterator)publicKey.getUserIDs());
            while (uit.hasNext()) {
                String userId = (String)uit.next();
                it = CollectionUtil.nullToEmpty((Iterator)publicKey.getSignaturesForID(userId));
                while (it.hasNext()) {
                    signature = (PGPSignature)it.next();
                    newPublicKey = this.mergeUserIdSignature(newPublicKey, userId, signature);
                }
            }
            uit = CollectionUtil.nullToEmpty((Iterator)publicKey.getUserAttributes());
            while (uit.hasNext()) {
                PGPUserAttributeSubpacketVector userAttribute = (PGPUserAttributeSubpacketVector)uit.next();
                it = CollectionUtil.nullToEmpty((Iterator)publicKey.getSignaturesForUserAttribute(userAttribute));
                while (it.hasNext()) {
                    signature = (PGPSignature)it.next();
                    newPublicKey = this.mergeUserAttributeSignature(newPublicKey, userAttribute, signature);
                }
            }
            if (newPublicKey != oldPublicKey) {
                PGPPublicKey pk = (publicKeyRing = PGPPublicKeyRing.removePublicKey((PGPPublicKeyRing)publicKeyRing, (PGPPublicKey)oldPublicKey)).getPublicKey(publicKey.getKeyID());
                if (pk != null) {
                    throw new IllegalStateException("PGPPublicKeyRing.removePublicKey(...) had no effect!");
                }
                publicKeyRing = PGPPublicKeyRing.insertPublicKey((PGPPublicKeyRing)publicKeyRing, (PGPPublicKey)newPublicKey);
            }
        }
        return publicKeyRing;
    }

    private PGPPublicKey mergeKeySignature(PGPPublicKey publicKey, PGPSignature signature) {
        AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
        AssertUtil.assertNotNull((String)"signature", (Object)signature);
        PGPSignature oldSignature = BcWithLocalGnuPgPgp.getKeySignature(publicKey, signature);
        if (oldSignature == null) {
            publicKey = PGPPublicKey.addCertification((PGPPublicKey)publicKey, (PGPSignature)signature);
        }
        return publicKey;
    }

    private PGPPublicKey mergeUserIdSignature(PGPPublicKey publicKey, String userId, PGPSignature signature) {
        AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
        AssertUtil.assertNotNull((String)"userId", (Object)userId);
        AssertUtil.assertNotNull((String)"signature", (Object)signature);
        PGPSignature oldSignature = BcWithLocalGnuPgPgp.getUserIdSignature(publicKey, userId, signature);
        if (oldSignature == null) {
            publicKey = PGPPublicKey.addCertification((PGPPublicKey)publicKey, (String)userId, (PGPSignature)signature);
        }
        return publicKey;
    }

    private PGPPublicKey mergeUserAttributeSignature(PGPPublicKey publicKey, PGPUserAttributeSubpacketVector userAttribute, PGPSignature signature) {
        AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
        AssertUtil.assertNotNull((String)"userAttribute", (Object)userAttribute);
        AssertUtil.assertNotNull((String)"signature", (Object)signature);
        PGPSignature oldSignature = BcWithLocalGnuPgPgp.getUserAttributeSignature(publicKey, userAttribute, signature);
        if (oldSignature == null) {
            publicKey = PGPPublicKey.addCertification((PGPPublicKey)publicKey, (PGPUserAttributeSubpacketVector)userAttribute, (PGPSignature)signature);
        }
        return publicKey;
    }

    private static PGPSignature getKeySignature(PGPPublicKey publicKey, PGPSignature signature) {
        AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
        AssertUtil.assertNotNull((String)"signature", (Object)signature);
        Iterator it = CollectionUtil.nullToEmpty((Iterator)publicKey.getKeySignatures());
        while (it.hasNext()) {
            PGPSignature s = (PGPSignature)it.next();
            if (!BcWithLocalGnuPgPgp.isSignatureEqual(s, signature)) continue;
            return s;
        }
        return null;
    }

    private static PGPSignature getUserIdSignature(PGPPublicKey publicKey, String userId, PGPSignature signature) {
        AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
        AssertUtil.assertNotNull((String)"userId", (Object)userId);
        AssertUtil.assertNotNull((String)"signature", (Object)signature);
        Iterator it = CollectionUtil.nullToEmpty((Iterator)publicKey.getSignaturesForID(userId));
        while (it.hasNext()) {
            PGPSignature s = (PGPSignature)it.next();
            if (!BcWithLocalGnuPgPgp.isSignatureEqual(s, signature)) continue;
            return s;
        }
        return null;
    }

    private static PGPSignature getUserAttributeSignature(PGPPublicKey publicKey, PGPUserAttributeSubpacketVector userAttribute, PGPSignature signature) {
        AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
        AssertUtil.assertNotNull((String)"userAttribute", (Object)userAttribute);
        AssertUtil.assertNotNull((String)"signature", (Object)signature);
        Iterator it = CollectionUtil.nullToEmpty((Iterator)publicKey.getSignaturesForUserAttribute(userAttribute));
        while (it.hasNext()) {
            PGPSignature s = (PGPSignature)it.next();
            if (!BcWithLocalGnuPgPgp.isSignatureEqual(s, signature)) continue;
            return s;
        }
        return null;
    }

    private static boolean isSignatureEqual(PGPSignature one, PGPSignature two) {
        return Util.equal((long)one.getKeyID(), (long)two.getKeyID()) && Util.equal((Object)one.getCreationTime(), (Object)two.getCreationTime()) && Util.equal((int)one.getHashAlgorithm(), (int)two.getHashAlgorithm()) && Util.equal((int)one.getKeyAlgorithm(), (int)two.getKeyAlgorithm()) && Util.equal((int)one.getSignatureType(), (int)two.getSignatureType());
    }

    private boolean importSecretKeyRing(ImportKeysResult importKeysResult, PGPSecretKeyRing secretKeyRing) throws IOException, PGPException {
        PGPSecretKeyRingCollection oldSecretKeyRingCollection;
        AssertUtil.assertNotNull((String)"secretKeyRing", (Object)secretKeyRing);
        File secringFile = this.getSecringFile();
        if (!secringFile.isFile()) {
            oldSecretKeyRingCollection = new PGPSecretKeyRingCollection((InputStream)new ByteArrayInputStream(new byte[0]), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        } else {
            try (BufferedInputStream in = new BufferedInputStream(secringFile.createInputStream());){
                oldSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            }
        }
        PGPSecretKeyRingCollection newSecretKeyRingCollection = oldSecretKeyRingCollection;
        newSecretKeyRingCollection = this.mergeSecretKeyRing(importKeysResult, newSecretKeyRingCollection, secretKeyRing);
        if (oldSecretKeyRingCollection != newSecretKeyRingCollection) {
            File tmpFile = OioFileFactory.createFile((File)secringFile.getParentFile(), (String[])new String[]{secringFile.getName() + ".tmp"});
            try (BufferedOutputStream out = new BufferedOutputStream(tmpFile.createOutputStream());){
                newSecretKeyRingCollection.encode((OutputStream)out);
            }
            secringFile.delete();
            tmpFile.renameTo(secringFile);
            this.secringFileLastModified = 0L;
            return true;
        }
        return false;
    }

    private PGPSecretKeyRingCollection mergeSecretKeyRing(ImportKeysResult importKeysResult, PGPSecretKeyRingCollection secretKeyRingCollection, PGPSecretKeyRing secretKeyRing) throws PGPException {
        AssertUtil.assertNotNull((String)"secretKeyRingCollection", (Object)secretKeyRingCollection);
        AssertUtil.assertNotNull((String)"secretKeyRing", (Object)secretKeyRing);
        PgpKeyId masterKeyId = new PgpKeyId(secretKeyRing.getSecretKey().getKeyID());
        ImportKeysResult.ImportedMasterKey importedMasterKey = importKeysResult.getPgpKeyId2ImportedMasterKey().get(masterKeyId);
        if (importedMasterKey == null) {
            importedMasterKey = new ImportKeysResult.ImportedMasterKey(masterKeyId);
            importKeysResult.getPgpKeyId2ImportedMasterKey().put(masterKeyId, importedMasterKey);
        }
        Iterator it = secretKeyRing.getSecretKeys();
        while (it.hasNext()) {
            ImportKeysResult.ImportedSubKey importedSubKey;
            PGPSecretKey secretKey = (PGPSecretKey)it.next();
            PgpKeyId subKeyId = new PgpKeyId(secretKey.getKeyID());
            if (masterKeyId.equals(subKeyId) || (importedSubKey = importedMasterKey.getPgpKeyId2ImportedSubKey().get(subKeyId)) != null) continue;
            importedSubKey = new ImportKeysResult.ImportedSubKey(subKeyId, importedMasterKey);
            importedMasterKey.getPgpKeyId2ImportedSubKey().put(subKeyId, importedSubKey);
        }
        PGPSecretKeyRing oldSecretKeyRing = secretKeyRingCollection.getSecretKeyRing(secretKeyRing.getSecretKey().getKeyID());
        if (oldSecretKeyRing == null) {
            secretKeyRingCollection = PGPSecretKeyRingCollection.addSecretKeyRing((PGPSecretKeyRingCollection)secretKeyRingCollection, (PGPSecretKeyRing)secretKeyRing);
        } else {
            PGPSecretKeyRing newSecretKeyRing = oldSecretKeyRing;
            Iterator it2 = secretKeyRing.getSecretKeys();
            while (it2.hasNext()) {
                PGPSecretKey secretKey = (PGPSecretKey)it2.next();
                newSecretKeyRing = this.mergeSecretKey(newSecretKeyRing, secretKey);
            }
            if (newSecretKeyRing != oldSecretKeyRing) {
                secretKeyRingCollection = PGPSecretKeyRingCollection.removeSecretKeyRing((PGPSecretKeyRingCollection)secretKeyRingCollection, (PGPSecretKeyRing)oldSecretKeyRing);
                secretKeyRingCollection = PGPSecretKeyRingCollection.addSecretKeyRing((PGPSecretKeyRingCollection)secretKeyRingCollection, (PGPSecretKeyRing)newSecretKeyRing);
            }
        }
        return secretKeyRingCollection;
    }

    private PGPSecretKeyRing mergeSecretKey(PGPSecretKeyRing secretKeyRing, PGPSecretKey secretKey) {
        AssertUtil.assertNotNull((String)"secretKeyRing", (Object)secretKeyRing);
        AssertUtil.assertNotNull((String)"secretKey", (Object)secretKey);
        PGPSecretKey oldSecretKey = secretKeyRing.getSecretKey(secretKey.getKeyID());
        if (oldSecretKey == null) {
            secretKeyRing = PGPSecretKeyRing.insertSecretKey((PGPSecretKeyRing)secretKeyRing, (PGPSecretKey)secretKey);
        }
        return secretKeyRing;
    }

    public BcPgpKey getBcPgpKeyOrFail(PgpKey pgpKey) {
        BcPgpKey bcPgpKey = this.getBcPgpKey(pgpKey);
        if (bcPgpKey == null) {
            throw new IllegalArgumentException("Unknown pgpKey with pgpKeyId=" + pgpKey.getPgpKeyId());
        }
        return bcPgpKey;
    }

    public BcPgpKey getBcPgpKey(PgpKey pgpKey) {
        PgpKeyId pgpKeyId = ((PgpKey)AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey)).getPgpKeyId();
        return this.getBcPgpKey(pgpKeyId);
    }

    public BcPgpKey getBcPgpKey(PgpKeyId pgpKeyId) {
        AssertUtil.assertNotNull((String)"pgpKeyId", (Object)pgpKeyId);
        this.loadIfNeeded();
        BcPgpKey bcPgpKey = this.pgpKeyId2bcPgpKey.get(pgpKeyId);
        return bcPgpKey;
    }

    @Override
    protected PgpDecoder _createDecoder() {
        return new BcPgpDecoder(this);
    }

    @Override
    protected PgpEncoder _createEncoder() {
        return new BcPgpEncoder(this);
    }

    protected File getPubringFile() {
        if (this.pubringFile == null) {
            File gnuPgDir = this.getGnuPgDir();
            gnuPgDir.mkdirs();
            this.pubringFile = OioFileFactory.createFile((File)gnuPgDir, (String[])new String[]{"pubring.gpg"});
        }
        return this.pubringFile;
    }

    protected File getSecringFile() {
        if (this.secringFile == null) {
            File gnuPgDir = this.getGnuPgDir();
            gnuPgDir.mkdirs();
            this.secringFile = OioFileFactory.createFile((File)gnuPgDir, (String[])new String[]{"secring.gpg"});
        }
        return this.secringFile;
    }

    protected File getTrustDbFile() {
        if (this.trustDbFile == null) {
            File gnuPgDir = this.getGnuPgDir();
            gnuPgDir.mkdirs();
            this.trustDbFile = OioFileFactory.createFile((File)gnuPgDir, (String[])new String[]{"trustdb.gpg"});
        }
        return this.trustDbFile;
    }

    protected synchronized void loadIfNeeded() {
        if (this.pgpKeyId2bcPgpKey == null || this.getPubringFile().lastModified() != this.pubringFileLastModified || this.getSecringFile().lastModified() != this.secringFileLastModified) {
            logger.debug("loadIfNeeded: invoking load().");
            this.load();
        } else {
            logger.trace("loadIfNeeded: *not* invoking load().");
        }
    }

    protected synchronized void load() {
        long pubringFileLastModified;
        long secringFileLastModified;
        HashMap<PgpKeyId, BcPgpKey> pgpKeyId2masterKey;
        HashMap<PgpKeyId, BcPgpKey> pgpKeyId2bcPgpKey;
        block36: {
            pgpKeyId2bcPgpKey = new HashMap<PgpKeyId, BcPgpKey>();
            pgpKeyId2masterKey = new HashMap<PgpKeyId, BcPgpKey>();
            try {
                PGPPublicKeyRingCollection pgpPublicKeyRingCollection;
                Object masterKey;
                File secringFile = this.getSecringFile();
                logger.debug("load: secringFile='{}'", (Object)secringFile);
                secringFileLastModified = secringFile.lastModified();
                if (secringFile.isFile()) {
                    PGPSecretKeyRingCollection pgpSecretKeyRingCollection;
                    try (BufferedInputStream in = new BufferedInputStream(secringFile.createInputStream());){
                        pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                    }
                    Iterator it1 = pgpSecretKeyRingCollection.getKeyRings();
                    while (it1.hasNext()) {
                        PGPSecretKeyRing keyRing = (PGPSecretKeyRing)it1.next();
                        masterKey = null;
                        Iterator it2 = keyRing.getPublicKeys();
                        while (it2.hasNext()) {
                            PGPPublicKey publicKey = (PGPPublicKey)it2.next();
                            masterKey = this.enlistPublicKey(pgpKeyId2bcPgpKey, pgpKeyId2masterKey, (BcPgpKey)masterKey, (PGPKeyRing)keyRing, publicKey);
                        }
                        Iterator it3 = keyRing.getSecretKeys();
                        while (it3.hasNext()) {
                            PGPSecretKey secretKey = (PGPSecretKey)it3.next();
                            PgpKeyId pgpKeyId = new PgpKeyId(secretKey.getKeyID());
                            BcPgpKey bcPgpKey = (BcPgpKey)pgpKeyId2bcPgpKey.get(pgpKeyId);
                            if (bcPgpKey == null) {
                                throw new IllegalStateException("Secret key does not have corresponding public key in secret key ring! pgpKeyId=" + pgpKeyId);
                            }
                            bcPgpKey.setSecretKey(secretKey);
                            logger.debug("load: read secretKey with pgpKeyId={}", (Object)pgpKeyId);
                        }
                    }
                }
                File pubringFile = this.getPubringFile();
                logger.debug("load: pubringFile='{}'", (Object)pubringFile);
                pubringFileLastModified = pubringFile.lastModified();
                if (!pubringFile.isFile()) break block36;
                BufferedInputStream in = new BufferedInputStream(pubringFile.createInputStream());
                masterKey = null;
                try {
                    pgpPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                }
                catch (Throwable it3) {
                    masterKey = it3;
                    throw it3;
                }
                finally {
                    if (in != null) {
                        if (masterKey != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable it3) {
                                ((Throwable)masterKey).addSuppressed(it3);
                            }
                        } else {
                            ((InputStream)in).close();
                        }
                    }
                }
                Iterator it1 = pgpPublicKeyRingCollection.getKeyRings();
                while (it1.hasNext()) {
                    PGPPublicKeyRing keyRing = (PGPPublicKeyRing)it1.next();
                    BcPgpKey masterKey2 = null;
                    Iterator it2 = keyRing.getPublicKeys();
                    while (it2.hasNext()) {
                        PGPPublicKey publicKey = (PGPPublicKey)it2.next();
                        masterKey2 = this.enlistPublicKey(pgpKeyId2bcPgpKey, pgpKeyId2masterKey, masterKey2, (PGPKeyRing)keyRing, publicKey);
                    }
                }
            }
            catch (IOException | PGPException x) {
                throw new RuntimeException(x);
            }
        }
        for (BcPgpKey bcPgpKey : pgpKeyId2bcPgpKey.values()) {
            if (bcPgpKey.getPublicKey() == null) {
                throw new IllegalStateException("bcPgpKey.publicKey == null :: keyId = " + bcPgpKey.getPgpKeyId());
            }
            if (bcPgpKey.getPublicKeyRing() != null) continue;
            throw new IllegalStateException("bcPgpKey.publicKeyRing == null :: keyId = " + bcPgpKey.getPgpKeyId());
        }
        this.secringFileLastModified = secringFileLastModified;
        this.pubringFileLastModified = pubringFileLastModified;
        this.pgpKeyId2bcPgpKey = pgpKeyId2bcPgpKey;
        this.pgpKeyId2masterKey = pgpKeyId2masterKey;
    }

    @Override
    public Collection<PgpSignature> getCertifications(PgpKey pgpKey) {
        PgpSignature pgpSignature;
        PGPSignature bcPgpSignature;
        Iterator itSig;
        BcPgpKey bcPgpKey = this.getBcPgpKeyOrFail(pgpKey);
        PGPPublicKey publicKey = bcPgpKey.getPublicKey();
        ArrayList<PgpSignature> result = new ArrayList<PgpSignature>();
        IdentityHashMap<PGPSignature, PGPSignature> bcPgpSignatures = new IdentityHashMap<PGPSignature, PGPSignature>();
        LinkedHashSet<String> userIds = new LinkedHashSet<String>();
        Iterator userIDsIterator = CollectionUtil.nullToEmpty((Iterator)publicKey.getUserIDs());
        while (userIDsIterator.hasNext()) {
            String userId = (String)userIDsIterator.next();
            userIds.add(userId);
            itSig = CollectionUtil.nullToEmpty((Iterator)publicKey.getSignaturesForID(userId));
            while (itSig.hasNext()) {
                bcPgpSignature = (PGPSignature)itSig.next();
                bcPgpSignatures.put(bcPgpSignature, bcPgpSignature);
                pgpSignature = this.createPgpSignature(bcPgpSignature);
                if (!pgpSignature.getSignatureType().isCertification()) continue;
                pgpSignature.setUserId(userId);
                result.add(pgpSignature);
            }
        }
        Iterator userAttributesIterator = CollectionUtil.nullToEmpty((Iterator)publicKey.getUserAttributes());
        while (userAttributesIterator.hasNext()) {
            PGPUserAttributeSubpacketVector userAttribute = (PGPUserAttributeSubpacketVector)userAttributesIterator.next();
            itSig = CollectionUtil.nullToEmpty((Iterator)publicKey.getSignaturesForUserAttribute(userAttribute));
            while (itSig.hasNext()) {
                bcPgpSignature = (PGPSignature)itSig.next();
                bcPgpSignatures.put(bcPgpSignature, bcPgpSignature);
                pgpSignature = this.createPgpSignature(bcPgpSignature);
                if (!pgpSignature.getSignatureType().isCertification()) continue;
                PgpUserIdNameHash nameHash = PgpUserIdNameHash.createFromUserAttribute(userAttribute);
                pgpSignature.setNameHash(nameHash);
                result.add(pgpSignature);
            }
        }
        Iterator it = CollectionUtil.nullToEmpty((Iterator)publicKey.getKeySignatures());
        while (it.hasNext()) {
            PgpSignatureType signatureType;
            PGPSignature bcPgpSignature2 = (PGPSignature)it.next();
            if (bcPgpSignatures.containsKey(bcPgpSignature2) || !(signatureType = this.signatureTypeToEnum(bcPgpSignature2.getSignatureType())).isCertification()) continue;
            result.add(this.createPgpSignature(bcPgpSignature2));
        }
        return Collections.unmodifiableList(result);
    }

    public PgpSignature createPgpSignature(PGPSignature bcPgpSignature) {
        PgpSignature pgpSignature = new PgpSignature();
        pgpSignature.setPgpKeyId(new PgpKeyId(bcPgpSignature.getKeyID()));
        pgpSignature.setCreated(bcPgpSignature.getCreationTime());
        pgpSignature.setSignatureType(this.signatureTypeToEnum(bcPgpSignature.getSignatureType()));
        return pgpSignature;
    }

    @Override
    public Collection<PgpKey> getMasterKeysWithSecretKey() {
        ArrayList<PgpKey> result = new ArrayList<PgpKey>();
        Collection<PgpKey> masterKeys = this.getMasterKeys();
        for (PgpKey pgpKey : masterKeys) {
            if (!pgpKey.isSecretKeyAvailable()) continue;
            result.add(pgpKey);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public PgpKeyValidity getKeyValidity(PgpKey pgpKey) {
        AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey);
        if (pgpKey.getMasterKey() != null) {
            pgpKey = pgpKey.getMasterKey();
        }
        try (TrustDb trustDb = this.createTrustDb();){
            BcPgpKey bcPgpKey = this.getBcPgpKeyOrFail(pgpKey);
            PGPPublicKey publicKey = bcPgpKey.getPublicKey();
            if (trustDb.isDisabled(publicKey)) {
                PgpKeyValidity pgpKeyValidity = PgpKeyValidity.DISABLED;
                return pgpKeyValidity;
            }
            if (publicKey.isRevoked()) {
                PgpKeyValidity pgpKeyValidity = PgpKeyValidity.REVOKED;
                return pgpKeyValidity;
            }
            if (trustDb.isExpired(publicKey)) {
                PgpKeyValidity pgpKeyValidity = PgpKeyValidity.EXPIRED;
                return pgpKeyValidity;
            }
            Validity validity = trustDb.getValidity(publicKey);
            PgpKeyValidity pgpKeyValidity = BcWithLocalGnuPgPgp.toPgpKeyValidity(validity);
            return pgpKeyValidity;
        }
    }

    @Override
    public PgpKeyValidity getKeyValidity(PgpKey pgpKey, String userId) {
        AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey);
        AssertUtil.assertNotNull((String)"userId", (Object)userId);
        if (pgpKey.getMasterKey() != null) {
            pgpKey = pgpKey.getMasterKey();
        }
        try (TrustDb trustDb = this.createTrustDb();){
            BcPgpKey bcPgpKey = this.getBcPgpKeyOrFail(pgpKey);
            PGPPublicKey publicKey = bcPgpKey.getPublicKey();
            if (trustDb.isDisabled(publicKey)) {
                PgpKeyValidity pgpKeyValidity = PgpKeyValidity.DISABLED;
                return pgpKeyValidity;
            }
            if (publicKey.isRevoked()) {
                PgpKeyValidity pgpKeyValidity = PgpKeyValidity.REVOKED;
                return pgpKeyValidity;
            }
            if (trustDb.isExpired(publicKey)) {
                PgpKeyValidity pgpKeyValidity = PgpKeyValidity.EXPIRED;
                return pgpKeyValidity;
            }
            Validity validity = trustDb.getValidity(publicKey);
            PgpKeyValidity pgpKeyValidity = BcWithLocalGnuPgPgp.toPgpKeyValidity(validity);
            return pgpKeyValidity;
        }
    }

    private static PgpKeyValidity toPgpKeyValidity(Validity validity) {
        switch ((Validity)((Object)AssertUtil.assertNotNull((String)"validity", (Object)((Object)validity)))) {
            case NONE: 
            case UNDEFINED: {
                return PgpKeyValidity.NOT_TRUSTED;
            }
            case MARGINAL: {
                return PgpKeyValidity.MARGINAL;
            }
            case FULL: {
                return PgpKeyValidity.FULL;
            }
            case ULTIMATE: {
                return PgpKeyValidity.ULTIMATE;
            }
        }
        throw new IllegalStateException("Unknown validity: " + (Object)((Object)validity));
    }

    @Override
    public void setDisabled(PgpKey pgpKey, boolean disabled) {
        AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey);
        if (pgpKey.getMasterKey() != null) {
            pgpKey = pgpKey.getMasterKey();
        }
        try (TrustDb trustDb = this.createTrustDb();){
            BcPgpKey bcPgpKey = this.getBcPgpKeyOrFail(pgpKey);
            PGPPublicKey publicKey = bcPgpKey.getPublicKey();
            trustDb.setDisabled(publicKey, disabled);
            this.markStale();
        }
    }

    @Override
    public PgpOwnerTrust getOwnerTrust(PgpKey pgpKey) {
        AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey);
        if (pgpKey.getMasterKey() != null) {
            pgpKey = pgpKey.getMasterKey();
        }
        Throwable throwable = null;
        try (TrustDb trustDb = this.createTrustDb();){
            BcPgpKey bcPgpKey = this.getBcPgpKeyOrFail(pgpKey);
            PGPPublicKey publicKey = bcPgpKey.getPublicKey();
            OwnerTrust ownerTrust = trustDb.getOwnerTrust(publicKey);
            if (ownerTrust == null) {
                PgpOwnerTrust pgpOwnerTrust = PgpOwnerTrust.UNSPECIFIED;
                return pgpOwnerTrust;
            }
            switch (ownerTrust) {
                case UNKNOWN: {
                    PgpOwnerTrust pgpOwnerTrust = PgpOwnerTrust.UNKNOWN;
                    return pgpOwnerTrust;
                }
                case NEVER: {
                    PgpOwnerTrust pgpOwnerTrust = PgpOwnerTrust.NEVER;
                    return pgpOwnerTrust;
                }
                case MARGINAL: {
                    PgpOwnerTrust pgpOwnerTrust = PgpOwnerTrust.MARGINAL;
                    return pgpOwnerTrust;
                }
                case FULL: {
                    PgpOwnerTrust pgpOwnerTrust = PgpOwnerTrust.FULL;
                    return pgpOwnerTrust;
                }
                case ULTIMATE: {
                    PgpOwnerTrust pgpOwnerTrust = PgpOwnerTrust.ULTIMATE;
                    return pgpOwnerTrust;
                }
            }
            try {
                throw new IllegalStateException("Unknown ownerTrust: " + (Object)((Object)ownerTrust));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setOwnerTrust(PgpKey pgpKey, PgpOwnerTrust ownerTrust) {
        AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey);
        AssertUtil.assertNotNull((String)"ownerTrust", (Object)((Object)ownerTrust));
        if (ownerTrust == PgpOwnerTrust.UNSPECIFIED) {
            throw new IllegalArgumentException("ownerTrust cannot be set to UNSPECIFIED!");
        }
        if (pgpKey.getMasterKey() != null) {
            pgpKey = pgpKey.getMasterKey();
        }
        try (TrustDb trustDb = this.createTrustDb();){
            BcPgpKey bcPgpKey = this.getBcPgpKeyOrFail(pgpKey);
            PGPPublicKey publicKey = bcPgpKey.getPublicKey();
            switch (ownerTrust) {
                case UNKNOWN: {
                    trustDb.setOwnerTrust(publicKey, OwnerTrust.UNKNOWN);
                    return;
                }
                case NEVER: {
                    trustDb.setOwnerTrust(publicKey, OwnerTrust.NEVER);
                    return;
                }
                case MARGINAL: {
                    trustDb.setOwnerTrust(publicKey, OwnerTrust.MARGINAL);
                    return;
                }
                case FULL: {
                    trustDb.setOwnerTrust(publicKey, OwnerTrust.FULL);
                    return;
                }
                case ULTIMATE: {
                    trustDb.setOwnerTrust(publicKey, OwnerTrust.ULTIMATE);
                    return;
                }
                default: {
                    throw new IllegalStateException("Unknown ownerTrustLevel: " + (Object)((Object)ownerTrust));
                }
            }
        }
    }

    @Override
    public void updateTrustDb() {
        try (TrustDb trustDb = this.createTrustDb();){
            trustDb.updateTrustDb();
            this.firePropertyChange(Pgp.PropertyEnum.trustdb, null, null);
        }
    }

    private BcPgpKey enlistPublicKey(Map<PgpKeyId, BcPgpKey> pgpKeyId2bcPgpKey, Map<PgpKeyId, BcPgpKey> pgpKeyId2masterKey, BcPgpKey masterKey, PGPKeyRing keyRing, PGPPublicKey publicKey) {
        PgpKeyId pgpKeyId = new PgpKeyId(publicKey.getKeyID());
        BcPgpKey bcPgpKey = pgpKeyId2bcPgpKey.get(pgpKeyId);
        if (bcPgpKey == null) {
            bcPgpKey = new BcPgpKey(this, pgpKeyId);
            pgpKeyId2bcPgpKey.put(pgpKeyId, bcPgpKey);
        }
        if (keyRing instanceof PGPSecretKeyRing) {
            bcPgpKey.setSecretKeyRing((PGPSecretKeyRing)keyRing);
        } else if (keyRing instanceof PGPPublicKeyRing) {
            bcPgpKey.setPublicKeyRing((PGPPublicKeyRing)keyRing);
        } else {
            throw new IllegalArgumentException("keyRing is neither an instance of PGPSecretKeyRing nor PGPPublicKeyRing!");
        }
        bcPgpKey.setPublicKey(publicKey);
        if (publicKey.isMasterKey()) {
            masterKey = bcPgpKey;
            pgpKeyId2masterKey.put(bcPgpKey.getPgpKeyId(), bcPgpKey);
        } else {
            if (masterKey == null) {
                throw new IllegalStateException("First key is a non-master key!");
            }
            bcPgpKey.setMasterKey(masterKey);
            masterKey.getSubKeyIds().add(bcPgpKey.getPgpKeyId());
        }
        return masterKey;
    }

    private PgpSignatureType signatureTypeToEnum(int signatureType) {
        switch (signatureType) {
            case 0: {
                return PgpSignatureType.BINARY_DOCUMENT;
            }
            case 1: {
                return PgpSignatureType.CANONICAL_TEXT_DOCUMENT;
            }
            case 2: {
                return PgpSignatureType.STAND_ALONE;
            }
            case 16: {
                return PgpSignatureType.DEFAULT_CERTIFICATION;
            }
            case 17: {
                return PgpSignatureType.NO_CERTIFICATION;
            }
            case 18: {
                return PgpSignatureType.CASUAL_CERTIFICATION;
            }
            case 19: {
                return PgpSignatureType.POSITIVE_CERTIFICATION;
            }
            case 24: {
                return PgpSignatureType.SUBKEY_BINDING;
            }
            case 25: {
                return PgpSignatureType.PRIMARYKEY_BINDING;
            }
            case 31: {
                return PgpSignatureType.DIRECT_KEY;
            }
            case 32: {
                return PgpSignatureType.KEY_REVOCATION;
            }
            case 40: {
                return PgpSignatureType.SUBKEY_REVOCATION;
            }
            case 48: {
                return PgpSignatureType.CERTIFICATION_REVOCATION;
            }
            case 64: {
                return PgpSignatureType.TIMESTAMP;
            }
        }
        throw new IllegalArgumentException("Unknown signatureType: " + signatureType);
    }

    private int signatureTypeFromEnum(PgpSignatureType signatureType) {
        switch ((PgpSignatureType)((Object)AssertUtil.assertNotNull((String)"signatureType", (Object)((Object)signatureType)))) {
            case BINARY_DOCUMENT: {
                return 0;
            }
            case CANONICAL_TEXT_DOCUMENT: {
                return 1;
            }
            case STAND_ALONE: {
                return 2;
            }
            case DEFAULT_CERTIFICATION: {
                return 16;
            }
            case NO_CERTIFICATION: {
                return 17;
            }
            case CASUAL_CERTIFICATION: {
                return 18;
            }
            case POSITIVE_CERTIFICATION: {
                return 19;
            }
            case SUBKEY_BINDING: {
                return 24;
            }
            case PRIMARYKEY_BINDING: {
                return 25;
            }
            case DIRECT_KEY: {
                return 31;
            }
            case KEY_REVOCATION: {
                return 32;
            }
            case SUBKEY_REVOCATION: {
                return 40;
            }
            case CERTIFICATION_REVOCATION: {
                return 48;
            }
            case TIMESTAMP: {
                return 64;
            }
        }
        throw new IllegalArgumentException("Unknown signatureType: " + (Object)((Object)signatureType));
    }

    private File getConfigDir() {
        if (this.configDir == null) {
            this.configDir = ConfigDir.getInstance().getFile();
        }
        return this.configDir;
    }

    private File getGpgPropertiesFile() {
        return OioFileFactory.createFile((File)this.getConfigDir(), (String[])new String[]{"gpg.properties"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLocalRevision() {
        long localRevision;
        Properties gpgProperties = this.getGpgProperties();
        this.loadIfNeeded();
        long pubringFileLastModified = this.pubringFileLastModified;
        long secringFileLastModified = this.secringFileLastModified;
        boolean needIncLocalRevision = false;
        Properties properties = gpgProperties;
        synchronized (properties) {
            localRevision = PropertiesUtil.getPropertyValueAsLong((Properties)gpgProperties, (String)PGP_PROPERTY_KEY_LOCAL_REVISION, (long)-1L);
            if (localRevision < 0L) {
                needIncLocalRevision = true;
            } else {
                long oldPubringFileLastModified = PropertiesUtil.getPropertyValueAsLong((Properties)gpgProperties, (String)PGP_PROPERTY_KEY_PUBRING_FILE_LAST_MODIFIED, (long)0L);
                long oldSecringFileLastModified = PropertiesUtil.getPropertyValueAsLong((Properties)gpgProperties, (String)PGP_PROPERTY_KEY_SECRING_FILE_LAST_MODIFIED, (long)0L);
                if (oldPubringFileLastModified != pubringFileLastModified || oldSecringFileLastModified != secringFileLastModified) {
                    needIncLocalRevision = true;
                }
            }
        }
        if (needIncLocalRevision) {
            return this.incLocalRevision();
        }
        return localRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incLocalRevision() {
        long localRevision;
        Properties gpgProperties = this.getGpgProperties();
        this.loadIfNeeded();
        long pubringFileLastModified = this.pubringFileLastModified;
        long secringFileLastModified = this.secringFileLastModified;
        Properties properties = gpgProperties;
        synchronized (properties) {
            localRevision = PropertiesUtil.getPropertyValueAsLong((Properties)gpgProperties, (String)PGP_PROPERTY_KEY_LOCAL_REVISION, (long)-1L) + 1L;
            gpgProperties.setProperty(PGP_PROPERTY_KEY_LOCAL_REVISION, Long.toString(localRevision));
            gpgProperties.setProperty(PGP_PROPERTY_KEY_PUBRING_FILE_LAST_MODIFIED, Long.toString(pubringFileLastModified));
            gpgProperties.setProperty(PGP_PROPERTY_KEY_SECRING_FILE_LAST_MODIFIED, Long.toString(secringFileLastModified));
            this.writeGpgProperties();
        }
        this.firePropertyChange(Pgp.PropertyEnum.localRevision, localRevision - 1L, localRevision);
        return localRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getGpgProperties() {
        block30: {
            if (this.gpgProperties == null) {
                try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getGpgPropertiesFile(), 30000L);){
                    Lock lock = lockFile.getLock();
                    lock.lock();
                    try {
                        if (this.gpgProperties != null) break block30;
                        Properties p = new Properties();
                        try (InputStream in = lockFile.createInputStream();){
                            p.load(in);
                        }
                        this.gpgProperties = p;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (IOException x) {
                    throw new RuntimeException(x);
                }
            }
        }
        return this.gpgProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGpgProperties() {
        Properties gpgProperties;
        Properties properties = gpgProperties = this.getGpgProperties();
        synchronized (properties) {
            try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getGpgPropertiesFile(), 30000L);
                 OutputStream out = lockFile.createOutputStream();){
                gpgProperties.store(out, null);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getLocalRevisionProperties(PgpKeyId pgpKeyId) {
        String pgpKeyIdRange = this.getPgpKeyIdRange(pgpKeyId);
        Object object = this.getPgpKeyIdRangeMutex(pgpKeyIdRange);
        synchronized (object) {
            Properties properties = this.pgpKeyIdRange2LocalRevisionProperties.get(pgpKeyIdRange);
            if (properties == null) {
                properties = new Properties();
                try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getLocalRevisionPropertiesFile(pgpKeyIdRange), 30000L);
                     InputStream in = lockFile.createInputStream();){
                    properties.load(in);
                }
                catch (IOException x) {
                    throw new RuntimeException(x);
                }
                this.pgpKeyIdRange2LocalRevisionProperties.put(pgpKeyIdRange, properties);
            }
            return properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLocalRevisionProperties(PgpKeyId pgpKeyId) {
        String pgpKeyIdRange = this.getPgpKeyIdRange(pgpKeyId);
        Object object = this.getPgpKeyIdRangeMutex(pgpKeyIdRange);
        synchronized (object) {
            Properties properties = this.pgpKeyIdRange2LocalRevisionProperties.get(pgpKeyIdRange);
            if (properties != null) {
                try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getLocalRevisionPropertiesFile(pgpKeyIdRange), 30000L);
                     OutputStream out = lockFile.createOutputStream();){
                    properties.store(out, null);
                }
                catch (IOException x) {
                    throw new RuntimeException(x);
                }
            }
        }
    }

    private File getLocalRevisionPropertiesFile(String pgpKeyIdRange) {
        AssertUtil.assertNotNull((String)"pgpKeyIdRange", (Object)pgpKeyIdRange);
        File dir = OioFileFactory.createFile((File)this.getConfigDir(), (String[])new String[]{"gpgLocalRevision"});
        File file = OioFileFactory.createFile((File)dir, (String[])new String[]{pgpKeyIdRange + ".properties"});
        file.getParentFile().mkdirs();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPgpKeyIdRangeMutex(String pgpKeyIdRange) {
        AssertUtil.assertNotNull((String)"pgpKeyIdRange", (Object)pgpKeyIdRange);
        Map<String, Object> map = this.pgpKeyIdRange2Mutex;
        synchronized (map) {
            Object mutex = this.pgpKeyIdRange2Mutex.get(pgpKeyIdRange);
            if (mutex == null) {
                mutex = pgpKeyIdRange;
                this.pgpKeyIdRange2Mutex.put(pgpKeyIdRange, mutex);
            }
            return mutex;
        }
    }

    private String getPgpKeyIdRange(PgpKeyId pgpKeyId) {
        AssertUtil.assertNotNull((String)"pgpKeyId", (Object)pgpKeyId);
        int range1 = (int)pgpKeyId.longValue() & 0xFF;
        return HashUtil.encodeHexStr((byte[])new byte[]{(byte)range1});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLocalRevision(PgpKey pgpKey) {
        BcPgpKey bcPgpKey = this.getBcPgpKeyOrFail(pgpKey);
        PgpKeyId pgpKeyId = pgpKey.getPgpKeyId();
        String pgpKeyIdRange = this.getPgpKeyIdRange(pgpKeyId);
        long globalLocalRevision = this.getLocalRevision();
        Object object = this.getPgpKeyIdRangeMutex(pgpKeyIdRange);
        synchronized (object) {
            Properties localRevisionProperties = this.getLocalRevisionProperties(pgpKeyId);
            String propertyKeyPrefix = pgpKeyId.toString() + '.';
            String globalLocalRevisionPropertyKey = propertyKeyPrefix + "globalLocalRevision";
            String localRevisionPropertyKey = propertyKeyPrefix + PGP_PROPERTY_KEY_LOCAL_REVISION;
            long oldGlobalLocalRevision = PropertiesUtil.getPropertyValueAsLong((Properties)localRevisionProperties, (String)globalLocalRevisionPropertyKey, (long)-1L);
            long localRevision = PropertiesUtil.getPropertyValueAsLong((Properties)localRevisionProperties, (String)localRevisionPropertyKey, (long)-1L);
            if (globalLocalRevision != oldGlobalLocalRevision || localRevision < 0L) {
                String secretKeySha1;
                String publicKeySha1;
                String publicKeySha1PropertyKey = propertyKeyPrefix + "publicKeySha1";
                String secretKeySha1PropertyKey = propertyKeyPrefix + "secretKeySha1";
                String oldPublicKeySha1 = localRevisionProperties.getProperty(publicKeySha1PropertyKey);
                String oldSecretKeySha1 = localRevisionProperties.getProperty(secretKeySha1PropertyKey);
                try {
                    publicKeySha1 = HashUtil.sha1((byte[])bcPgpKey.getPublicKey().getEncoded());
                    secretKeySha1 = bcPgpKey.getSecretKey() == null ? null : HashUtil.sha1((byte[])bcPgpKey.getSecretKey().getEncoded());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                localRevisionProperties.setProperty(globalLocalRevisionPropertyKey, Long.toString(globalLocalRevision));
                if (!Util.equal((Object)oldPublicKeySha1, (Object)publicKeySha1) || !Util.equal((Object)oldSecretKeySha1, (Object)secretKeySha1) || localRevision < 0L) {
                    localRevisionProperties.setProperty(publicKeySha1PropertyKey, publicKeySha1);
                    if (StringUtil.isEmpty((String)secretKeySha1)) {
                        localRevisionProperties.remove(secretKeySha1PropertyKey);
                    } else {
                        localRevisionProperties.setProperty(secretKeySha1PropertyKey, secretKeySha1);
                    }
                    localRevision = globalLocalRevision;
                    localRevisionProperties.setProperty(localRevisionPropertyKey, Long.toString(localRevision));
                }
                this.writeLocalRevisionProperties(pgpKeyId);
            }
            return localRevision;
        }
    }

    @Override
    public boolean testPassphrase(PgpKey pgpKey, char[] passphrase) throws IllegalArgumentException {
        AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey);
        AssertUtil.assertNotNull((String)"passphrase", (Object)passphrase);
        BcPgpKey bcPgpKey = this.getBcPgpKeyOrFail(pgpKey);
        PGPSecretKey secretKey = bcPgpKey.getSecretKey();
        if (secretKey == null) {
            throw new IllegalArgumentException("pgpKey has no secret key!");
        }
        try {
            BcWithLocalGnuPgPgp.extractPrivateKey(secretKey, passphrase);
            return true;
        }
        catch (PGPException e) {
            logger.debug("testPassphrase: " + (Object)((Object)e), (Throwable)e);
            return false;
        }
    }

    private static PGPPrivateKey extractPrivateKey(PGPSecretKey secretKey, char[] passphrase) throws PGPException {
        PGPPrivateKey privateKey = secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passphrase));
        return privateKey;
    }

    @Override
    public PgpKey createPgpKey(CreatePgpKeyParam createPgpKeyParam) {
        AssertUtil.assertNotNull((String)"createPgpKeyParam", (Object)createPgpKeyParam);
        try {
            Pair<PGPPublicKeyRing, PGPSecretKeyRing> pair = this.createPGPSecretKeyRing(createPgpKeyParam);
            PGPPublicKeyRing pgpPublicKeyRing = (PGPPublicKeyRing)pair.a;
            PGPSecretKeyRing pgpSecretKeyRing = (PGPSecretKeyRing)pair.b;
            ImportKeysResult importKeysResult = new ImportKeysResult();
            this.importPublicKeyRing(importKeysResult, pgpPublicKeyRing);
            this.importSecretKeyRing(importKeysResult, pgpSecretKeyRing);
            PGPSecretKey secretKey = pgpSecretKeyRing.getSecretKey();
            PgpKey pgpKey = this.getPgpKey(new PgpKeyId(secretKey.getKeyID()));
            AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey);
            return pgpKey;
        }
        catch (IOException | NoSuchAlgorithmException | PGPException e) {
            throw new RuntimeException(e);
        }
    }

    private Pair<PGPPublicKeyRing, PGPSecretKeyRing> createPGPSecretKeyRing(CreatePgpKeyParam createPgpKeyParam) throws PGPException, NoSuchAlgorithmException {
        AssertUtil.assertNotNull((String)"createPgpKeyParam", (Object)createPgpKeyParam);
        ArrayList<PgpUserId> secondaryUserIds = new ArrayList<PgpUserId>(createPgpKeyParam.getUserIds());
        if (secondaryUserIds.isEmpty()) {
            throw new IllegalArgumentException("createPgpKeyParam.userIds is empty!");
        }
        for (PgpUserId pgpUserId : secondaryUserIds) {
            if (!pgpUserId.isEmpty()) continue;
            throw new IllegalArgumentException("createPgpKeyParam.userIds contains empty element!");
        }
        String primaryUserId = ((PgpUserId)secondaryUserIds.remove(0)).toString();
        logger.info("createPGPSecretKeyRing: Creating PGP key: primaryUserId='{}' algorithm='{}' strength={}", new Object[]{primaryUserId, createPgpKeyParam.getAlgorithm(), createPgpKeyParam.getStrength()});
        Date now = new Date();
        int masterKeyAlgorithm = this.getMasterKeyAlgorithm(createPgpKeyParam);
        int subKey1Algorithm = this.getSubKey1Algorithm(createPgpKeyParam);
        int secretKeyEncryptionAlgorithm = 10;
        PgpSignatureType certificationLevel = PgpSignatureType.POSITIVE_CERTIFICATION;
        int[] preferredHashAlgorithms = new int[]{10, 9, 8, 2};
        int[] preferredSymmetricAlgorithms = new int[]{10, 9, 4};
        char[] passphrase = createPgpKeyParam.getPassphrase() == null ? new char[]{} : createPgpKeyParam.getPassphrase();
        logger.info("createPGPSecretKeyRing: Creating masterKeyPairGenerator...");
        AsymmetricCipherKeyPairGenerator masterKeyPairGenerator = this.createAsymmetricCipherKeyPairGenerator(createPgpKeyParam, 0);
        logger.info("createPGPSecretKeyRing: Creating sub1KeyPairGenerator...");
        AsymmetricCipherKeyPairGenerator sub1KeyPairGenerator = this.createAsymmetricCipherKeyPairGenerator(createPgpKeyParam, 1);
        logger.info("createPGPSecretKeyRing: Creating masterKeyPair...");
        BcPGPKeyPair masterKeyPair = new BcPGPKeyPair(masterKeyAlgorithm, masterKeyPairGenerator.generateKeyPair(), now);
        PGPSignatureSubpacketGenerator masterSubpckGen = new PGPSignatureSubpacketGenerator();
        masterSubpckGen.setKeyFlags(false, 35);
        masterSubpckGen.setPreferredSymmetricAlgorithms(false, preferredSymmetricAlgorithms);
        masterSubpckGen.setPreferredHashAlgorithms(false, preferredHashAlgorithms);
        masterSubpckGen.setPreferredCompressionAlgorithms(false, new int[]{1});
        masterSubpckGen.setKeyExpirationTime(false, createPgpKeyParam.getValiditySeconds());
        logger.info("createPGPSecretKeyRing: Creating sub1KeyPair...");
        BcPGPKeyPair sub1KeyPair = new BcPGPKeyPair(subKey1Algorithm, sub1KeyPairGenerator.generateKeyPair(), now);
        PGPSignatureSubpacketGenerator sub1SubpckGen = new PGPSignatureSubpacketGenerator();
        sub1SubpckGen.setKeyFlags(false, 12);
        sub1SubpckGen.setPreferredSymmetricAlgorithms(false, preferredSymmetricAlgorithms);
        sub1SubpckGen.setPreferredHashAlgorithms(false, preferredHashAlgorithms);
        sub1SubpckGen.setPreferredCompressionAlgorithms(false, new int[]{1});
        sub1SubpckGen.setKeyExpirationTime(false, createPgpKeyParam.getValiditySeconds());
        logger.info("createPGPSecretKeyRing: Creating keyRingGenerator...");
        BcPGPDigestCalculatorProvider digestCalculatorProvider = new BcPGPDigestCalculatorProvider();
        BcPGPContentSignerBuilder signerBuilder = new BcPGPContentSignerBuilder(masterKeyAlgorithm, 10);
        BcPBESecretKeyEncryptorBuilder pbeSecretKeyEncryptorBuilder = new BcPBESecretKeyEncryptorBuilder(10, digestCalculatorProvider.get(10));
        PGPDigestCalculator checksumCalculator = digestCalculatorProvider.get(2);
        PGPSignatureSubpacketVector hashedSubpackets = masterSubpckGen.generate();
        PGPSignatureSubpacketVector unhashedSubpackets = null;
        PGPKeyRingGenerator keyRingGenerator = new PGPKeyRingGenerator(this.signatureTypeFromEnum(certificationLevel), (PGPKeyPair)masterKeyPair, primaryUserId, checksumCalculator, hashedSubpackets, unhashedSubpackets, (PGPContentSignerBuilder)signerBuilder, pbeSecretKeyEncryptorBuilder.build(passphrase));
        keyRingGenerator.addSubKey((PGPKeyPair)sub1KeyPair, sub1SubpckGen.generate(), null);
        logger.info("createPGPSecretKeyRing: generateSecretKeyRing...");
        PGPSecretKeyRing secretKeyRing = keyRingGenerator.generateSecretKeyRing();
        logger.info("createPGPSecretKeyRing: generatePublicKeyRing...");
        PGPPublicKeyRing publicKeyRing = keyRingGenerator.generatePublicKeyRing();
        if (!secondaryUserIds.isEmpty()) {
            for (PgpUserId pgpUserId : secondaryUserIds) {
                publicKeyRing = BcWithLocalGnuPgPgp.addUserId(publicKeyRing, pgpUserId.toString(), secretKeyRing, passphrase, (PGPContentSignerBuilder)signerBuilder, hashedSubpackets, unhashedSubpackets);
            }
            secretKeyRing = PGPSecretKeyRing.replacePublicKeys((PGPSecretKeyRing)secretKeyRing, (PGPPublicKeyRing)publicKeyRing);
        }
        logger.info("createPGPSecretKeyRing: all done!");
        return new Pair<PGPPublicKeyRing, PGPSecretKeyRing>(publicKeyRing, secretKeyRing);
    }

    private static PGPPublicKeyRing addUserId(PGPPublicKeyRing publicKeyRing, String userId, PGPSecretKeyRing secretKeyRing, char[] passphrase, PGPContentSignerBuilder signerBuilder, PGPSignatureSubpacketVector hashedSubpackets, PGPSignatureSubpacketVector unhashedSubpackets) throws PGPException {
        AssertUtil.assertNotNull((String)"publicKeyRing", (Object)publicKeyRing);
        AssertUtil.assertNotNull((String)"userId", (Object)userId);
        PGPPublicKey masterPublicKey = BcWithLocalGnuPgPgp.getMasterKeyOrFail(publicKeyRing);
        PGPSecretKey masterSecretKey = secretKeyRing.getSecretKey(masterPublicKey.getKeyID());
        AssertUtil.assertNotNull((String)"masterSecretKey", (Object)masterSecretKey);
        PGPPrivateKey privateKey = BcWithLocalGnuPgPgp.extractPrivateKey(masterSecretKey, passphrase);
        PGPSignatureGenerator sGen = new PGPSignatureGenerator(signerBuilder);
        sGen.init(19, privateKey);
        sGen.setHashedSubpackets(hashedSubpackets);
        sGen.setUnhashedSubpackets(unhashedSubpackets);
        PGPSignature certification = sGen.generateCertification(userId, masterPublicKey);
        PGPPublicKey newMasterPublicKey = PGPPublicKey.addCertification((PGPPublicKey)masterPublicKey, (String)userId, (PGPSignature)certification);
        PGPPublicKeyRing result = PGPPublicKeyRing.removePublicKey((PGPPublicKeyRing)publicKeyRing, (PGPPublicKey)masterPublicKey);
        result = PGPPublicKeyRing.insertPublicKey((PGPPublicKeyRing)result, (PGPPublicKey)newMasterPublicKey);
        return result;
    }

    private static PGPPublicKey getMasterKeyOrFail(PGPPublicKeyRing publicKeyRing) {
        Iterator it = publicKeyRing.getPublicKeys();
        while (it.hasNext()) {
            PGPPublicKey pk = (PGPPublicKey)it.next();
            if (!pk.isMasterKey()) continue;
            return pk;
        }
        throw new IllegalStateException("No masterKey found!");
    }

    private int getMasterKeyAlgorithm(CreatePgpKeyParam createPgpKeyParam) {
        switch (createPgpKeyParam.getAlgorithm()) {
            case DSA_AND_EL_GAMAL: {
                return 17;
            }
            case RSA: {
                return 3;
            }
        }
        throw new IllegalStateException("Unknown algorithm: " + (Object)((Object)createPgpKeyParam.getAlgorithm()));
    }

    private int getSubKey1Algorithm(CreatePgpKeyParam createPgpKeyParam) {
        switch (createPgpKeyParam.getAlgorithm()) {
            case DSA_AND_EL_GAMAL: {
                return 16;
            }
            case RSA: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown algorithm: " + (Object)((Object)createPgpKeyParam.getAlgorithm()));
    }

    private AsymmetricCipherKeyPairGenerator createAsymmetricCipherKeyPairGenerator(CreatePgpKeyParam createPgpKeyParam, int keyIndex) throws NoSuchAlgorithmException {
        AsymmetricCipherKeyPairGenerator keyPairGenerator;
        CryptoRegistry cryptoRegistry = CryptoRegistry.getInstance();
        switch (createPgpKeyParam.getAlgorithm()) {
            case DSA_AND_EL_GAMAL: {
                if (keyIndex == 0) {
                    keyPairGenerator = cryptoRegistry.createKeyPairGenerator("DSA", false);
                    keyPairGenerator.init((KeyGenerationParameters)this.createDsaKeyGenerationParameters(createPgpKeyParam));
                    break;
                }
                keyPairGenerator = cryptoRegistry.createKeyPairGenerator("ElGamal", false);
                keyPairGenerator.init((KeyGenerationParameters)this.createElGamalKeyGenerationParameters(createPgpKeyParam));
                break;
            }
            case RSA: {
                keyPairGenerator = cryptoRegistry.createKeyPairGenerator("RSA", false);
                keyPairGenerator.init((KeyGenerationParameters)this.createRsaKeyGenerationParameters(createPgpKeyParam));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm: " + (Object)((Object)createPgpKeyParam.getAlgorithm()));
            }
        }
        return keyPairGenerator;
    }

    private DSAKeyGenerationParameters createDsaKeyGenerationParameters(CreatePgpKeyParam createPgpKeyParam) {
        int certainty = 12;
        SecureRandom random = this.getSecureRandom();
        DSAParametersGenerator pGen = new DSAParametersGenerator();
        pGen.init(createPgpKeyParam.getStrength(), 12, random);
        DSAParameters dsaParameters = pGen.generateParameters();
        return new DSAKeyGenerationParameters(random, dsaParameters);
    }

    private ElGamalKeyGenerationParameters createElGamalKeyGenerationParameters(CreatePgpKeyParam createPgpKeyParam) {
        int certainty = 8;
        SecureRandom random = this.getSecureRandom();
        ElGamalParametersGenerator pGen = new ElGamalParametersGenerator();
        pGen.init(createPgpKeyParam.getStrength(), 8, random);
        ElGamalParameters elGamalParameters = pGen.generateParameters();
        return new ElGamalKeyGenerationParameters(random, elGamalParameters);
    }

    private RSAKeyGenerationParameters createRsaKeyGenerationParameters(CreatePgpKeyParam createPgpKeyParam) {
        BigInteger publicExponent = BigInteger.valueOf(65537L);
        int certainty = 12;
        return new RSAKeyGenerationParameters(publicExponent, this.getSecureRandom(), createPgpKeyParam.getStrength(), 12);
    }

    private synchronized SecureRandom getSecureRandom() {
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
        return this.secureRandom;
    }

    protected PgpKeyRegistry getPgpKeyRegistry() {
        if (this.pgpKeyRegistry == null) {
            this.pgpKeyRegistry = PgpKeyRegistry.Helper.createInstance(this.getPubringFile().getIoFile(), this.getSecringFile().getIoFile());
        }
        return this.pgpKeyRegistry;
    }

    protected synchronized TrustDbFactory getTrustDbFactory() {
        if (this.trustDbFactory == null) {
            this.trustDbFactory = new TrustDbFactory(this.getTrustDbFile(), this.getPgpKeyRegistry());
        }
        return this.trustDbFactory;
    }

    protected TrustDb createTrustDb() {
        TrustDbFactory trustDbFactory = this.getTrustDbFactory();
        return trustDbFactory.createTrustDb();
    }

    private static final class Pair<A, B> {
        public final A a;
        public final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }
}

