/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.Signature;
import org.subshare.local.persistence.SignatureImpl;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Unique(name="RepositoryOwner_serverRepositoryId", members={"serverRepositoryId"})
@Queries(value={@Query(name="getRepositoryOwner_serverRepositoryId", value="SELECT UNIQUE WHERE this.serverRepositoryId == :serverRepositoryId")})
public class RepositoryOwner
extends Entity
implements Signable,
AutoTrackLocalRevision,
StoreCallback,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=36)
    private String serverRepositoryId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private UserRepoKeyPublicKey userRepoKeyPublicKey;
    private long localRevision;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public void jdoPreStore() {
        Signature signature = this.getSignature();
        if (RepositoryOwner.dnGetuserRepoKeyPublicKey(this) != null && signature != null && !signature.getSigningUserRepoKeyId().equals((Object)RepositoryOwner.dnGetuserRepoKeyPublicKey(this).getUserRepoKeyId())) {
            throw new IllegalStateException(String.format("RepositoryOwner must be self-signed! signingUserRepoKeyId != userRepoKeyPublicKey.userRepoKeyId :: %s != %s", signature.getSigningUserRepoKeyId(), RepositoryOwner.dnGetuserRepoKeyPublicKey(this).getUserRepoKeyId()));
        }
    }

    public UUID getServerRepositoryId() {
        return RepositoryOwner.dnGetserverRepositoryId(this) == null ? null : UUID.fromString(RepositoryOwner.dnGetserverRepositoryId(this));
    }

    public UserRepoKeyPublicKey getUserRepoKeyPublicKey() {
        return RepositoryOwner.dnGetuserRepoKeyPublicKey(this);
    }

    public void setUserRepoKeyPublicKey(UserRepoKeyPublicKey userRepoKeyPublicKey) {
        String sridStr;
        if (!Util.equal((Object)((Object)RepositoryOwner.dnGetuserRepoKeyPublicKey(this)), (Object)((Object)userRepoKeyPublicKey))) {
            RepositoryOwner.dnSetuserRepoKeyPublicKey(this, userRepoKeyPublicKey);
        }
        UUID srid = userRepoKeyPublicKey == null ? null : userRepoKeyPublicKey.getServerRepositoryId();
        String string = sridStr = srid == null ? null : srid.toString();
        if (!Util.equal((Object)RepositoryOwner.dnGetserverRepositoryId(this), (Object)sridStr)) {
            RepositoryOwner.dnSetserverRepositoryId(this, sridStr);
        }
    }

    public long getLocalRevision() {
        return RepositoryOwner.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)RepositoryOwner.dnGetlocalRevision(this), (long)localRevision)) {
            RepositoryOwner.dnSetlocalRevision(this, localRevision);
        }
    }

    public String getSignedDataType() {
        return "RepositoryOwner";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        byte separatorIndex = 0;
        try {
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[3];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((UUID)this.getServerRepositoryId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource((Uid)RepositoryOwner.dnGetuserRepoKeyPublicKey(this).getUserRepoKeyId());
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return RepositoryOwner.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)RepositoryOwner.dnGetsignature(this), (Object)signature)) {
            RepositoryOwner.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    static {
        dnFieldNames = RepositoryOwner.__dnFieldNamesInit();
        dnFieldTypes = RepositoryOwner.__dnFieldTypesInit();
        dnFieldFlags = RepositoryOwner.__dnFieldFlagsInit();
        dnInheritedFieldCount = RepositoryOwner.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = RepositoryOwner.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)RepositoryOwner.___dn$loadClass("org.subshare.local.persistence.RepositoryOwner"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new RepositoryOwner());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        RepositoryOwner result = new RepositoryOwner();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        RepositoryOwner result = new RepositoryOwner();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 1: {
                this.serverRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.userRepoKeyPublicKey = (UserRepoKeyPublicKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.serverRepositoryId);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.userRepoKeyPublicKey);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(RepositoryOwner obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 1: {
                this.serverRepositoryId = obj.serverRepositoryId;
                break;
            }
            case 2: {
                this.signature = obj.signature;
                break;
            }
            case 3: {
                this.userRepoKeyPublicKey = obj.userRepoKeyPublicKey;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof RepositoryOwner)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.RepositoryOwner");
        }
        RepositoryOwner other = (RepositoryOwner)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"localRevision", "serverRepositoryId", "signature", "userRepoKeyPublicKey"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{Long.TYPE, RepositoryOwner.___dn$loadClass("java.lang.String"), RepositoryOwner.___dn$loadClass("org.subshare.local.persistence.SignatureImpl"), RepositoryOwner.___dn$loadClass("org.subshare.local.persistence.UserRepoKeyPublicKey")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 21, 10, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 4 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return RepositoryOwner.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        RepositoryOwner o = (RepositoryOwner)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static long dnGetlocalRevision(RepositoryOwner objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(RepositoryOwner objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static String dnGetserverRepositoryId(RepositoryOwner objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.serverRepositoryId);
        }
        return objPC.serverRepositoryId;
    }

    private static void dnSetserverRepositoryId(RepositoryOwner objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.serverRepositoryId, val);
        } else {
            objPC.serverRepositoryId = val;
        }
    }

    private static SignatureImpl dnGetsignature(RepositoryOwner objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(RepositoryOwner objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }

    private static UserRepoKeyPublicKey dnGetuserRepoKeyPublicKey(RepositoryOwner objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return (UserRepoKeyPublicKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.userRepoKeyPublicKey));
        }
        return objPC.userRepoKeyPublicKey;
    }

    private static void dnSetuserRepoKeyPublicKey(RepositoryOwner objPC, UserRepoKeyPublicKey val) {
        if (objPC.dnStateManager == null) {
            objPC.userRepoKeyPublicKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.userRepoKeyPublicKey, (Object)val);
        }
    }
}

