/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.dto;

import co.codewizards.cloudstore.core.dto.Uid;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.subshare.core.dto.CryptoKeyPart;
import org.subshare.core.dto.SignatureDto;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.Signature;

@XmlRootElement
public class CryptoLinkDto
implements Signable {
    public static final String SIGNED_DATA_TYPE = "CryptoLink";
    private Uid cryptoLinkId;
    private long localRevision;
    private Uid fromCryptoKeyId;
    private Uid fromUserRepoKeyId;
    private Uid toCryptoKeyId;
    private CryptoKeyPart toCryptoKeyPart;
    private byte[] toCryptoKeyData;
    @XmlElement
    private SignatureDto signatureDto;

    public Uid getCryptoLinkId() {
        return this.cryptoLinkId;
    }

    public void setCryptoLinkId(Uid cryptoLinkId) {
        this.cryptoLinkId = cryptoLinkId;
    }

    public long getLocalRevision() {
        return this.localRevision;
    }

    public void setLocalRevision(long localRevision) {
        this.localRevision = localRevision;
    }

    public Uid getFromCryptoKeyId() {
        return this.fromCryptoKeyId;
    }

    public void setFromCryptoKeyId(Uid fromCryptoKeyId) {
        this.fromCryptoKeyId = fromCryptoKeyId;
    }

    public Uid getFromUserRepoKeyId() {
        return this.fromUserRepoKeyId;
    }

    public void setFromUserRepoKeyId(Uid fromUserRepoKeyId) {
        this.fromUserRepoKeyId = fromUserRepoKeyId;
    }

    public Uid getToCryptoKeyId() {
        return this.toCryptoKeyId;
    }

    public void setToCryptoKeyId(Uid toCryptoKeyId) {
        this.toCryptoKeyId = toCryptoKeyId;
    }

    public CryptoKeyPart getToCryptoKeyPart() {
        return this.toCryptoKeyPart;
    }

    public void setToCryptoKeyPart(CryptoKeyPart toCryptoKeyPart) {
        this.toCryptoKeyPart = toCryptoKeyPart;
    }

    public byte[] getToCryptoKeyData() {
        return this.toCryptoKeyData;
    }

    public void setToCryptoKeyData(byte[] toCryptoKeyData) {
        this.toCryptoKeyData = toCryptoKeyData;
    }

    @Override
    public String getSignedDataType() {
        return SIGNED_DATA_TYPE;
    }

    @Override
    public int getSignedDataVersion() {
        return 0;
    }

    @Override
    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[11];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource(this.cryptoLinkId);
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource(this.fromCryptoKeyId);
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource(this.fromUserRepoKeyId);
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource(this.toCryptoKeyId);
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[7] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[8] = InputStreamSource.Helper.createInputStreamSource(this.toCryptoKeyPart.ordinal());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[9] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[10] = InputStreamSource.Helper.createInputStreamSource(this.toCryptoKeyData);
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    @XmlTransient
    public Signature getSignature() {
        return this.signatureDto;
    }

    @Override
    public void setSignature(Signature signature) {
        this.signatureDto = SignatureDto.copyIfNeeded(signature);
    }

    public String toString() {
        return "CryptoLinkDto[cryptoLinkId=" + this.cryptoLinkId + ", localRevision=" + this.localRevision + ", fromCryptoKeyId=" + this.fromCryptoKeyId + ", fromUserRepoKeyId=" + this.fromUserRepoKeyId + ", toCryptoKeyId=" + this.toCryptoKeyId + ", toCryptoKeyPart=" + (Object)((Object)this.toCryptoKeyPart) + "]";
    }
}

