/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.fbor;

import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.NoCloseInputStream;
import co.codewizards.cloudstore.core.io.NoCloseOutputStream;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class FileBasedObjectRegistry {
    private static final long DEFERRED_WRITE_DELAY_MS = 30000L;
    private Properties manifestProperties;
    private boolean dirty;
    private final Timer deferredWriteTimer = new Timer(this.getClass().getSimpleName() + ".deferredWriteTimer", false);
    private TimerTask deferredWriteTimerTask;
    private int ignoreDeferredWriteCounter = 0;

    protected FileBasedObjectRegistry() {
        Runtime.getRuntime().addShutdownHook(new Thread(this.getClass().getSimpleName() + ".shutdownHook"){

            @Override
            public void run() {
                FileBasedObjectRegistry.this.writeIfNeeded();
            }
        });
    }

    protected abstract File getFile();

    protected abstract String getContentType();

    protected int getContentTypeVersion() {
        return 1;
    }

    protected void read(InputStream in) throws IOException {
        ZipInputStream zin = new ZipInputStream((InputStream)new NoCloseInputStream((InputStream)AssertUtil.assertNotNull((String)"in", (Object)in)));
        this.manifestProperties = this.readManifest(zin);
        if (this.manifestProperties == null) {
            this.manifestProperties = this.initManifestProperties();
            return;
        }
        this.readPayload(zin);
        zin.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void read() {
        this.preRead();
        this.enableIgnoreDeferredWrite();
        try {
            try (LockFile lockFile = this.acquireLockFile();
                 InputStream in = lockFile.createInputStream();){
                this.read(in);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
            this.markClean();
        }
        finally {
            this.disableIgnoreDeferredWrite();
        }
        this.postRead();
    }

    protected void preRead() {
    }

    protected void postRead() {
    }

    protected synchronized void write() {
        try (LockFile lockFile = this.acquireLockFile();
             OutputStream out = lockFile.createOutputStream();){
            this.write(out);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        this.markClean();
    }

    public synchronized void writeIfNeeded() {
        if (this.isDirty()) {
            this.write();
        }
    }

    protected long getDeferredWriteDelayMs() {
        return 30000L;
    }

    protected synchronized void enableIgnoreDeferredWrite() {
        ++this.ignoreDeferredWriteCounter;
    }

    protected synchronized void disableIgnoreDeferredWrite() {
        if (--this.ignoreDeferredWriteCounter < 0) {
            throw new IllegalStateException("ignoreDeferredWriteCounter < 0");
        }
    }

    protected synchronized void deferredWrite() {
        if (this.ignoreDeferredWriteCounter > 0) {
            return;
        }
        if (this.deferredWriteTimerTask != null) {
            this.deferredWriteTimerTask.cancel();
            this.deferredWriteTimerTask = null;
        }
        this.deferredWriteTimerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileBasedObjectRegistry fileBasedObjectRegistry = FileBasedObjectRegistry.this;
                synchronized (fileBasedObjectRegistry) {
                    FileBasedObjectRegistry.this.deferredWriteTimerTask = null;
                }
                FileBasedObjectRegistry.this.write();
            }
        };
        this.deferredWriteTimer.schedule(this.deferredWriteTimerTask, this.getDeferredWriteDelayMs());
    }

    protected Properties readManifest(ZipInputStream zin) throws IOException {
        AssertUtil.assertNotNull((String)"zin", (Object)zin);
        ZipEntry ze = zin.getNextEntry();
        if (ze == null) {
            return null;
        }
        if (!"MANIFEST.properties".equals(ze.getName())) {
            throw new IllegalArgumentException(String.format("Input data is not valid: The very first zip-entry is not '%s' (it is '%s' instead)!", "MANIFEST.properties", ze.getName()));
        }
        Properties properties = new Properties();
        properties.load(zin);
        String contentType = this.getContentType();
        String ct = properties.getProperty("contentType");
        if (!contentType.equals(ct)) {
            throw new IllegalArgumentException(String.format("Input data is not valid: The manifest indicates the content-type '%s', but '%s' is expected!", ct, contentType));
        }
        return properties;
    }

    protected Properties initManifestProperties() {
        Properties manifestProperties = new Properties();
        manifestProperties.setProperty("contentType", this.getContentType());
        manifestProperties.setProperty("contentTypeVersion", Integer.toString(this.getContentTypeVersion()));
        return manifestProperties;
    }

    protected void readPayload(ZipInputStream zin) throws IOException {
        ZipEntry zipEntry;
        AssertUtil.assertNotNull((String)"zin", (Object)zin);
        while (null != (zipEntry = zin.getNextEntry())) {
            this.readPayloadEntry(zin, zipEntry);
        }
    }

    protected abstract void readPayloadEntry(ZipInputStream var1, ZipEntry var2) throws IOException;

    protected LockFile acquireLockFile() {
        return LockFileFactory.getInstance().acquire(this.getFile(), 30000L);
    }

    protected void markClean() {
        this.dirty = false;
    }

    protected void markDirty() {
        this.dirty = true;
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void write(OutputStream out) throws IOException {
        AssertUtil.assertNotNull((String)"out", (Object)out);
        byte[] manifestData = this.createManifestData();
        ZipOutputStream zout = new ZipOutputStream((OutputStream)new NoCloseOutputStream(out));
        zout.putNextEntry(this.createManifestZipEntry(manifestData));
        zout.write(manifestData);
        zout.closeEntry();
        this.writePayload(zout);
        zout.close();
    }

    protected abstract void writePayload(ZipOutputStream var1) throws IOException;

    private ZipEntry createManifestZipEntry(byte[] manifestData) {
        ZipEntry ze = new ZipEntry("MANIFEST.properties");
        ze.setMethod(0);
        ze.setSize(manifestData.length);
        ze.setCompressedSize(manifestData.length);
        CRC32 crc32 = new CRC32();
        crc32.update(manifestData);
        ze.setCrc(crc32.getValue());
        return ze;
    }

    private byte[] createManifestData() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        SortedMap<String, String> sortedManifestProperties = this.createSortedManifestProperties();
        String contentType = (String)sortedManifestProperties.remove("contentType");
        AssertUtil.assertNotNull((String)"contentType", (Object)contentType);
        this.writeManifestEntry(w, "contentType", contentType);
        String version = (String)sortedManifestProperties.remove("contentTypeVersion");
        AssertUtil.assertNotNull((String)"contentTypeVersion", (Object)version);
        try {
            Integer.parseInt(version);
        }
        catch (NumberFormatException x) {
            throw new IllegalStateException("contentTypeVersion is not a valid integer: " + version);
        }
        this.writeManifestEntry(w, "contentTypeVersion", version);
        for (Map.Entry<String, String> me : sortedManifestProperties.entrySet()) {
            this.writeManifestEntry(w, me.getKey(), me.getValue());
        }
        ((Writer)w).close();
        return out.toByteArray();
    }

    public void mergeFrom(byte[] data) {
        AssertUtil.assertNotNull((String)"data", (Object)data);
        if (data.length == 0) {
            return;
        }
        try (ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(data));){
            ZipEntry zipEntry;
            Properties manifestProperties = this.readManifest(zin);
            if (!this.getContentType().equals(manifestProperties.getProperty("contentType"))) {
                throw new IllegalArgumentException(String.format("data has unexpected contentType: '%s' was found, but '%s' was expected!", this.getContentType(), manifestProperties.getProperty("contentType")));
            }
            while (null != (zipEntry = zin.getNextEntry())) {
                this.mergeFrom(zin, zipEntry);
            }
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    protected abstract void mergeFrom(ZipInputStream var1, ZipEntry var2);

    private SortedMap<String, String> createSortedManifestProperties() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> me : this.manifestProperties.entrySet()) {
            result.put(me.getKey().toString(), me.getValue().toString());
        }
        return result;
    }

    private void writeManifestEntry(Writer w, String key, String value) throws IOException {
        AssertUtil.assertNotNull((String)"w", (Object)w);
        AssertUtil.assertNotNull((String)"key", (Object)key);
        AssertUtil.assertNotNull((String)"value", (Object)value);
        w.write(key);
        w.write(61);
        w.write(value);
        w.write(10);
    }
}

