/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.sign;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Signer;
import org.subshare.core.crypto.CryptoConfigUtil;
import org.subshare.core.dto.SignatureDto;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.SignerTransformation;
import org.subshare.core.user.UserRepoKey;
import org.subshare.crypto.CryptoRegistry;

public class SignableSigner {
    private static final int BUFFER_SIZE = 32768;
    static final int MAX_UNSIGNED_2_BYTE_VALUE = 65535;
    private final UserRepoKey userRepoKey;
    private final SignerTransformation signerTransformation;
    private final Signer signer;

    public SignableSigner(UserRepoKey userRepoKey) {
        this.userRepoKey = (UserRepoKey)AssertUtil.assertNotNull((String)"userRepoKey", (Object)userRepoKey);
        this.signerTransformation = CryptoConfigUtil.getSignerTransformation();
        try {
            this.signer = CryptoRegistry.getInstance().createSigner(this.signerTransformation.getTransformation());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.signer.init(true, (CipherParameters)userRepoKey.getKeyPair().getPrivate());
    }

    public void sign(Signable signable) {
        AssertUtil.assertNotNull((String)"signable", (Object)signable);
        Date signatureCreated = new Date();
        SignatureDto signatureDto = new SignatureDto();
        signatureDto.setSignatureCreated(signatureCreated);
        signatureDto.setSigningUserRepoKeyId(this.userRepoKey.getUserRepoKeyId());
        String signedDataType = signable.getSignedDataType();
        if (StringUtil.isEmpty((String)signedDataType)) {
            throw new IllegalArgumentException(String.format("Implementation error in class %s: signable.getSignedDataType() returned null! %s", signable.getClass().getName(), signable));
        }
        int signedDataVersion = signable.getSignedDataVersion();
        if (signedDataVersion > 65535) {
            throw new IllegalStateException("signedDataVersion > 65535");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(1);
            int signerTransformationNumeric = this.signerTransformation.ordinal();
            if (signerTransformationNumeric > 65535) {
                throw new IllegalStateException("signerTransformationNumeric > 65535");
            }
            out.write(signerTransformationNumeric);
            out.write(signerTransformationNumeric >>> 8);
            out.write(signedDataVersion);
            out.write(signedDataVersion >>> 8);
            this.signer.reset();
            byte[] signedDataTypeBytes = signedDataType.getBytes(StandardCharsets.UTF_8);
            this.signer.update(signedDataTypeBytes, 0, signedDataTypeBytes.length);
            byte[] signatureCreatedBytes = IOUtil.longToBytes((long)signatureCreated.getTime());
            this.signer.update(signatureCreatedBytes, 0, signatureCreatedBytes.length);
            byte[] buf = new byte[32768];
            try (InputStream signedDataInputStream = signable.getSignedData(signedDataVersion);){
                int bytesRead;
                while ((bytesRead = signedDataInputStream.read(buf)) >= 0) {
                    if (bytesRead <= 0) continue;
                    this.signer.update(buf, 0, bytesRead);
                }
            }
            byte[] signatureBytes = this.signer.generateSignature();
            int signatureBytesLength = signatureBytes.length;
            out.write(signatureBytesLength);
            out.write(signatureBytesLength >>> 8);
            out.write(signatureBytesLength >>> 16);
            out.write(signatureBytesLength >>> 24);
            out.write(signatureBytes);
            signatureDto.setSignatureData(out.toByteArray());
            signable.setSignature(signatureDto);
        }
        catch (IOException | CryptoException x) {
            throw new RuntimeException(x);
        }
    }
}

