/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.user;

import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.DeletedUid;
import org.subshare.core.dto.UserDto;
import org.subshare.core.dto.UserRegistryDto;
import org.subshare.core.dto.UserRepoKeyDto;
import org.subshare.core.dto.UserRepoKeyPublicKeyDto;
import org.subshare.core.dto.jaxb.UserRegistryDtoIo;
import org.subshare.core.fbor.FileBasedObjectRegistry;
import org.subshare.core.io.NullOutputStream;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpDecoder;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.pgp.PgpUserId;
import org.subshare.core.pgp.sync.PgpSync;
import org.subshare.core.pgp.sync.PgpSyncDaemonImpl;
import org.subshare.core.user.ImportUsersFromPgpKeysResult;
import org.subshare.core.user.User;
import org.subshare.core.user.UserDtoConverter;
import org.subshare.core.user.UserImpl;
import org.subshare.core.user.UserRegistry;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyDtoConverter;
import org.subshare.core.user.UserRepoKeyPublicKeyDtoWithSignatureConverter;
import org.subshare.core.user.UserRepoKeyRing;

public class UserRegistryImpl
extends FileBasedObjectRegistry
implements UserRegistry {
    private static final Logger logger = LoggerFactory.getLogger(UserRegistryImpl.class);
    private static final String PAYLOAD_ENTRY_NAME = UserRegistryDto.class.getSimpleName() + ".xml";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Map<Uid, User> userId2User = new LinkedHashMap<Uid, User>();
    private final List<DeletedUid> deletedUserIds = new ArrayList<DeletedUid>();
    private final List<DeletedUid> deletedUserRepoKeyIds = new ArrayList<DeletedUid>();
    private List<User> cache_users;
    private Map<String, Set<User>> cache_email2Users;
    private Map<Uid, User> cache_userRepoKeyId2User;
    private final File userRegistryFile;
    private Uid version;
    private final PropertyChangeListener userPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            User user = (User)evt.getSource();
            AssertUtil.assertNotNull((String)"user", (Object)user);
            UserRegistryImpl.this.markDirty();
            UserRegistryImpl.this.cleanCache();
            UserRegistryImpl.this.firePropertyChange(UserRegistry.PropertyEnum.users_user, null, user);
        }
    };

    public static UserRegistry getInstance() {
        return Holder.instance;
    }

    protected UserRegistryImpl() {
        this.userRegistryFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"userRegistry.subshare"});
        this.read();
    }

    @Override
    protected String getContentType() {
        return "application/vnd.subshare.user-registry";
    }

    @Override
    protected File getFile() {
        return this.userRegistryFile;
    }

    @Override
    protected void read() {
        super.read();
        this.readPgpUsers();
        this.writeIfNeeded();
    }

    @Override
    protected void preRead() {
        this.version = null;
    }

    @Override
    protected void postRead() {
        if (this.version == null) {
            this.markDirty();
        }
    }

    @Override
    protected void readPayloadEntry(ZipInputStream zin, ZipEntry zipEntry) throws IOException {
        if (!PAYLOAD_ENTRY_NAME.equals(zipEntry.getName())) {
            logger.warn("readPayloadEntry: Ignoring unexpected zip-entry: {}", (Object)zipEntry.getName());
            return;
        }
        UserDtoConverter userDtoConverter = new UserDtoConverter();
        UserRegistryDtoIo userRegistryDtoIo = new UserRegistryDtoIo();
        UserRegistryDto userRegistryDto = (UserRegistryDto)userRegistryDtoIo.deserialize(zin);
        for (User user : this.getUsers()) {
            this.removeUser(user);
        }
        for (UserDto userDto : userRegistryDto.getUserDtos()) {
            User user = userDtoConverter.fromUserDto(userDto);
            this.addUser(user);
        }
        this.deletedUserIds.clear();
        this.deletedUserIds.addAll(userRegistryDto.getDeletedUserIds());
        this.deletedUserRepoKeyIds.clear();
        this.deletedUserRepoKeyIds.addAll(userRegistryDto.getDeletedUserRepoKeyIds());
        this.version = userRegistryDto.getVersion();
    }

    public Uid getVersion() {
        return (Uid)AssertUtil.assertNotNull((String)"version", (Object)this.version);
    }

    protected synchronized void readPgpUsers() {
        Collection<PgpKey> masterKeys = PgpRegistry.getInstance().getPgpOrFail().getMasterKeys();
        this.importUsersFromPgpKeys(masterKeys);
    }

    @Override
    public synchronized ImportUsersFromPgpKeysResult importUsersFromPgpKeys(Collection<PgpKey> pgpKeys) {
        ArrayList<User> newUsers = new ArrayList<User>();
        HashSet<Uid> modifiedUserIds = new HashSet<Uid>();
        HashMap<PgpKeyId, PgpKey> pgpKeyId2PgpKey = new HashMap<PgpKeyId, PgpKey>();
        HashMap email2NewUsers = new HashMap();
        Map<PgpKeyId, List<User>> pgpKeyId2Users = this.createPgpKeyId2Users();
        for (PgpKey pgpKey : pgpKeys) {
            User user;
            PgpKey pgpKey2 = pgpKey.getMasterKey();
            pgpKeyId2PgpKey.put(pgpKey2.getPgpKeyId(), pgpKey2);
            List<User> usersByPgpKeyId = pgpKeyId2Users.get(pgpKey2.getPgpKeyId());
            if (usersByPgpKeyId == null) {
                usersByPgpKeyId = new ArrayList<User>(1);
                pgpKeyId2Users.put(pgpKey2.getPgpKeyId(), usersByPgpKeyId);
            }
            User user2 = user = usersByPgpKeyId.isEmpty() ? null : usersByPgpKeyId.get(0);
            if (user == null) {
                boolean newUser = true;
                user = this.createUser();
                for (String userId : pgpKey2.getUserIds()) {
                    UserRegistryImpl.populateUserFromPgpUserId(user, userId);
                }
                for (String email : user.getEmails()) {
                    Collection<User> usersByEmail = this.getUsersByEmail(email);
                    if (usersByEmail.isEmpty()) continue;
                    newUser = false;
                    user = usersByEmail.iterator().next();
                    for (String userId : pgpKey2.getUserIds()) {
                        if (!UserRegistryImpl.populateUserFromPgpUserId(user, userId) || newUsers.contains(user)) continue;
                        modifiedUserIds.add(user.getUserId());
                    }
                }
                if (newUser) {
                    for (String email : user.getEmails()) {
                        ArrayList<User> l = (ArrayList<User>)email2NewUsers.get(email);
                        if (l == null) {
                            l = new ArrayList<User>();
                            email2NewUsers.put(email, l);
                        }
                        if (l.isEmpty()) {
                            l.add(user);
                            continue;
                        }
                        newUser = false;
                        user = (User)l.get(0);
                        for (String userId : pgpKey2.getUserIds()) {
                            if (!UserRegistryImpl.populateUserFromPgpUserId(user, userId) || newUsers.contains(user)) continue;
                            modifiedUserIds.add(user.getUserId());
                        }
                    }
                }
                if (newUser) {
                    newUsers.add(user);
                }
            }
            if (!user.getPgpKeyIds().contains(pgpKey2.getPgpKeyId())) {
                user.getPgpKeyIds().add(pgpKey2.getPgpKeyId());
            }
            usersByPgpKeyId.add(user);
        }
        HashSet<Uid> newUserIds = new HashSet<Uid>();
        for (User user : newUsers) {
            PgpKeyId pgpKeyId = new TreeSet<PgpKeyId>(user.getPgpKeyIds()).iterator().next();
            PgpKey pgpKey = (PgpKey)pgpKeyId2PgpKey.get(pgpKeyId);
            AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey);
            Uid userId = new Uid(UserRegistryImpl.getLast16(pgpKey.getFingerprint()));
            user.setUserId(userId);
            this.addUser(user);
            newUserIds.add(user.getUserId());
        }
        ImportUsersFromPgpKeysResult importUsersFromPgpKeysResult = new ImportUsersFromPgpKeysResult();
        for (PgpKey pgpKey : pgpKeys) {
            PgpKeyId pgpKeyId = pgpKey.getPgpKeyId();
            List<User> users = pgpKeyId2Users.get(pgpKeyId);
            AssertUtil.assertNotNull((String)"users", users);
            for (User user : users) {
                boolean _new = newUserIds.contains(user.getUserId());
                boolean modified = modifiedUserIds.contains(user.getUserId());
                if (_new && modified) {
                    throw new IllegalStateException("_new && modified :: userId=" + user.getUserId());
                }
                ImportUsersFromPgpKeysResult.ImportedUser importedUser = new ImportUsersFromPgpKeysResult.ImportedUser(user, _new, modified);
                List<ImportUsersFromPgpKeysResult.ImportedUser> list = importUsersFromPgpKeysResult.getPgpKeyId2ImportedUsers().get(pgpKeyId);
                if (list == null) {
                    list = new ArrayList<ImportUsersFromPgpKeysResult.ImportedUser>();
                    importUsersFromPgpKeysResult.getPgpKeyId2ImportedUsers().put(pgpKeyId, list);
                }
                list.add(importedUser);
            }
        }
        return importUsersFromPgpKeysResult;
    }

    private synchronized Map<PgpKeyId, List<User>> createPgpKeyId2Users() {
        HashMap<PgpKeyId, List<User>> result = new HashMap<PgpKeyId, List<User>>();
        for (User user : this.userId2User.values()) {
            for (PgpKeyId pgpKeyId : user.getPgpKeyIds()) {
                ArrayList<User> users = (ArrayList<User>)result.get(pgpKeyId);
                if (users == null) {
                    users = new ArrayList<User>(1);
                    result.put(pgpKeyId, users);
                }
                users.add(user);
            }
        }
        return result;
    }

    private static byte[] getLast16(byte[] fingerprint) {
        byte[] result = new byte[16];
        if (fingerprint.length < result.length) {
            throw new IllegalArgumentException("fingerprint.length < " + result.length);
        }
        System.arraycopy(fingerprint, fingerprint.length - result.length, result, 0, result.length);
        return result;
    }

    private static boolean populateUserFromPgpUserId(User user, String pgpUserIdStr) {
        AssertUtil.assertNotNull((String)"user", (Object)user);
        boolean modified = false;
        PgpUserId pgpUserId = new PgpUserId((String)AssertUtil.assertNotNull((String)"pgpUserIdStr", (Object)pgpUserIdStr));
        if (!StringUtil.isEmpty((String)pgpUserId.getEmail()) && !user.getEmails().contains(pgpUserId.getEmail())) {
            user.getEmails().add(pgpUserId.getEmail());
            modified = true;
        }
        if (StringUtil.isEmpty((String)user.getFirstName()) && StringUtil.isEmpty((String)user.getLastName())) {
            modified = true;
            String fullName = pgpUserId.getName();
            if (!StringUtil.isEmpty((String)fullName)) {
                String[] firstAndLastName = UserRegistryImpl.extractFirstAndLastNameFromFullName(fullName);
                if (StringUtil.isEmpty((String)user.getFirstName()) && !firstAndLastName[0].isEmpty()) {
                    user.setFirstName(firstAndLastName[0]);
                }
                if (StringUtil.isEmpty((String)user.getLastName()) && !firstAndLastName[1].isEmpty()) {
                    user.setLastName(firstAndLastName[1]);
                }
            }
        }
        return modified;
    }

    private static String[] extractFirstAndLastNameFromFullName(String fullName) {
        int lastSpace;
        int lastOpenBracket;
        if ((fullName = ((String)AssertUtil.assertNotNull((String)"fullName", (Object)fullName)).trim()).endsWith(")") && (lastOpenBracket = fullName.lastIndexOf(40)) >= 0) {
            fullName = fullName.substring(0, lastOpenBracket).trim();
        }
        if ((lastSpace = fullName.lastIndexOf(32)) < 0) {
            return new String[]{"", fullName};
        }
        String firstName = fullName.substring(0, lastSpace).trim();
        String lastName = fullName.substring(lastSpace + 1).trim();
        return new String[]{firstName, lastName};
    }

    @Override
    public User createUser() {
        return new UserImpl();
    }

    @Override
    public synchronized Collection<User> getUsers() {
        if (this.cache_users == null) {
            this.cache_users = Collections.unmodifiableList(new ArrayList<User>(this.userId2User.values()));
        }
        return this.cache_users;
    }

    private void cleanCache() {
        this.cache_users = null;
        this.cache_email2Users = null;
        this.cache_userRepoKeyId2User = null;
    }

    @Override
    public synchronized Collection<User> getUsersByEmail(String email) {
        Set<User> users;
        AssertUtil.assertNotNull((String)"email", (Object)email);
        if (this.cache_email2Users == null) {
            HashMap<String, HashSet<User>> cache_email2Users = new HashMap<String, HashSet<User>>();
            for (User user : this.getUsers()) {
                for (String eml : user.getEmails()) {
                    HashSet<User> users2 = (HashSet<User>)cache_email2Users.get(eml = eml.toLowerCase(Locale.UK));
                    if (users2 == null) {
                        users2 = new HashSet<User>();
                        cache_email2Users.put(eml, users2);
                    }
                    users2.add(user);
                }
            }
            for (Map.Entry entry : cache_email2Users.entrySet()) {
                entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
            }
            this.cache_email2Users = Collections.unmodifiableMap(cache_email2Users);
        }
        return (users = this.cache_email2Users.get(email.toLowerCase(Locale.UK))) != null ? users : Collections.unmodifiableList(new LinkedList());
    }

    @Override
    public synchronized void addUser(User user) {
        AssertUtil.assertNotNull((String)"user", (Object)user);
        AssertUtil.assertNotNull((String)"user.userId", (Object)user.getUserId());
        this.userId2User.put(user.getUserId(), user);
        user.addPropertyChangeListener(this.userPropertyChangeListener);
        this.cleanCache();
        this.markDirty();
        this.firePropertyChange(UserRegistry.PropertyEnum.users, null, this.getUsers());
    }

    @Override
    public synchronized void removeUser(User user) {
        this._removeUser(user);
        this.deletedUserIds.add(new DeletedUid(user.getUserId()));
    }

    protected synchronized void _removeUser(User user) {
        AssertUtil.assertNotNull((String)"user", (Object)user);
        this.userId2User.remove(user.getUserId());
        user.removePropertyChangeListener(this.userPropertyChangeListener);
        this.cleanCache();
        this.markDirty();
        this.firePropertyChange(UserRegistry.PropertyEnum.users, null, this.getUsers());
    }

    @Override
    public synchronized User getUserByUserIdOrFail(Uid userId) {
        User user = this.getUserByUserId(userId);
        if (user == null) {
            throw new IllegalArgumentException("No User found for userId=" + userId);
        }
        return user;
    }

    @Override
    public synchronized User getUserByUserId(Uid userId) {
        AssertUtil.assertNotNull((String)"userId", (Object)userId);
        return this.userId2User.get(userId);
    }

    @Override
    public User getUserByUserRepoKeyIdOrFail(Uid userRepoKeyId) {
        User user = this.getUserByUserRepoKeyId(userRepoKeyId);
        if (user == null) {
            throw new IllegalArgumentException("No User found for userRepoKeyId=" + userRepoKeyId);
        }
        return user;
    }

    @Override
    public synchronized User getUserByUserRepoKeyId(Uid userRepoKeyId) {
        AssertUtil.assertNotNull((String)"userRepoKeyId", (Object)userRepoKeyId);
        if (this.cache_userRepoKeyId2User == null) {
            HashMap<Uid, User> m = new HashMap<Uid, User>();
            for (User user : this.getUsers()) {
                UserRepoKeyRing userRepoKeyRing = user.getUserRepoKeyRing();
                if (userRepoKeyRing != null) {
                    for (UserRepoKey userRepoKey : userRepoKeyRing.getUserRepoKeys()) {
                        if (m.put(userRepoKey.getUserRepoKeyId(), user) == null) continue;
                        throw new IllegalStateException("Duplicate userRepoKeyId!!! WTF?! " + userRepoKey.getUserRepoKeyId());
                    }
                    continue;
                }
                for (UserRepoKey.PublicKey publicKey : user.getUserRepoKeyPublicKeys()) {
                    if (m.put(publicKey.getUserRepoKeyId(), user) == null) continue;
                    throw new IllegalStateException("Duplicate userRepoKeyId!!! WTF?! " + publicKey.getUserRepoKeyId());
                }
            }
            this.cache_userRepoKeyId2User = m;
        }
        return this.cache_userRepoKeyId2User.get(userRepoKeyId);
    }

    @Override
    public Collection<User> getUsersByPgpKeyIds(Set<PgpKeyId> pgpKeyIds) {
        ArrayList<User> result = new ArrayList<User>();
        block0: for (User user : this.getUsers()) {
            for (PgpKeyId pgpKeyId : user.getPgpKeyIds()) {
                if (!pgpKeyIds.contains(pgpKeyId)) continue;
                result.add(user);
                continue block0;
            }
        }
        return result;
    }

    @Override
    protected void markDirty() {
        super.markDirty();
        this.version = new Uid();
        this.deferredWrite();
    }

    @Override
    protected void writePayload(ZipOutputStream zout) throws IOException {
        UserRegistryDtoIo userRegistryDtoIo = new UserRegistryDtoIo();
        UserRegistryDto userRegistryDto = this.createUserRegistryDto();
        zout.putNextEntry(new ZipEntry(PAYLOAD_ENTRY_NAME));
        userRegistryDtoIo.serialize(userRegistryDto, zout);
        zout.closeEntry();
    }

    @Override
    protected void mergeFrom(ZipInputStream zin, ZipEntry zipEntry) {
        if (PAYLOAD_ENTRY_NAME.equals(zipEntry.getName())) {
            UserRegistryDtoIo userRegistryDtoIo = new UserRegistryDtoIo();
            UserRegistryDto userRegistryDto = (UserRegistryDto)userRegistryDtoIo.deserialize(zin);
            this.mergeFrom(userRegistryDto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void mergeFrom(UserRegistryDto userRegistryDto) {
        AssertUtil.assertNotNull((String)"userRegistryDto", (Object)userRegistryDto);
        HashSet<PgpKeyId> pgpKeyIds = new HashSet<PgpKeyId>();
        for (UserDto userDto : userRegistryDto.getUserDtos()) {
            if (userDto.getUserRepoKeyRingDto() != null) {
                for (UserRepoKeyDto userRepoKeyDto : userDto.getUserRepoKeyRingDto().getUserRepoKeyDtos()) {
                    pgpKeyIds.addAll(this.getSigningPgpKeyIds(userRepoKeyDto.getSignedPublicKeyData()));
                }
            }
            for (UserRepoKeyPublicKeyDto userRepoKeyPublicKeyDto : userDto.getUserRepoKeyPublicKeyDtos()) {
                pgpKeyIds.addAll(this.getSigningPgpKeyIds(userRepoKeyPublicKeyDto.getSignedPublicKeyData()));
            }
        }
        try {
            PgpSync.setDownSyncPgpKeyIds(pgpKeyIds);
            PgpSyncDaemonImpl.getInstance().sync();
        }
        finally {
            PgpSync.setDownSyncPgpKeyIds(null);
        }
        HashSet<Uid> deletedUserIdSet = new HashSet<Uid>(this.deletedUserIds.size());
        for (DeletedUid deletedUid : this.deletedUserIds) {
            deletedUserIdSet.add(deletedUid.getUid());
        }
        HashSet<Uid> hashSet = new HashSet<Uid>(this.deletedUserRepoKeyIds.size());
        for (DeletedUid deletedUid : this.deletedUserRepoKeyIds) {
            hashSet.add(deletedUid.getUid());
        }
        ArrayList<UserDto> arrayList = new ArrayList<UserDto>(userRegistryDto.getUserDtos().size());
        for (UserDto userDto : userRegistryDto.getUserDtos()) {
            Uid userId = (Uid)AssertUtil.assertNotNull((String)"userDto.userId", (Object)userDto.getUserId());
            if (deletedUserIdSet.contains(userId)) continue;
            User user = this.getUserByUserId(userId);
            if (user == null) {
                arrayList.add(userDto);
                continue;
            }
            this.merge(user, userDto, hashSet);
        }
        HashSet<DeletedUid> hashSet2 = new HashSet<DeletedUid>(userRegistryDto.getDeletedUserIds());
        hashSet2.removeAll(this.deletedUserIds);
        HashMap<DeletedUid, User> newDeletedUsers = new HashMap<DeletedUid, User>(hashSet2.size());
        for (DeletedUid deletedUserId : hashSet2) {
            User user = this.getUserByUserId(deletedUserId.getUid());
            if (user == null) continue;
            newDeletedUsers.put(deletedUserId, user);
        }
        HashSet<DeletedUid> newDeletedUserRepoKeyIds = new HashSet<DeletedUid>(userRegistryDto.getDeletedUserRepoKeyIds());
        newDeletedUserRepoKeyIds.removeAll(this.deletedUserRepoKeyIds);
        HashMap<DeletedUid, User> newDeletedUserRepoKeyId2User = new HashMap<DeletedUid, User>(newDeletedUserRepoKeyIds.size());
        for (DeletedUid deletedUserRepoKeyId : newDeletedUserRepoKeyIds) {
            User user = this.getUserByUserRepoKeyId(deletedUserRepoKeyId.getUid());
            if (user == null) continue;
            newDeletedUserRepoKeyId2User.put(deletedUserRepoKeyId, user);
        }
        UserDtoConverter userDtoConverter = new UserDtoConverter();
        for (UserDto userDto : arrayList) {
            User user = userDtoConverter.fromUserDto(userDto);
            this.addUser(user);
        }
        for (Map.Entry entry : newDeletedUsers.entrySet()) {
            this._removeUser((User)entry.getValue());
            this.deletedUserIds.add((DeletedUid)entry.getKey());
        }
        Iterator<Object> iterator = newDeletedUserRepoKeyId2User.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            throw new UnsupportedOperationException("NYI");
        }
        this.writeIfNeeded();
        if (this.hasMissingPgpKeys()) {
            PgpSyncDaemonImpl.getInstance().sync();
        }
    }

    private Set<PgpKeyId> getSigningPgpKeyIds(byte[] signedData) {
        if (signedData == null) {
            return Collections.emptySet();
        }
        Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
        PgpDecoder decoder = pgp.createDecoder(new ByteArrayInputStream(signedData), new NullOutputStream());
        decoder.setFailOnMissingSignPgpKey(false);
        try {
            decoder.decode();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return decoder.getSignPgpKeyIds();
    }

    private boolean hasMissingPgpKeys() {
        Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
        for (User user : this.getUsers()) {
            for (PgpKeyId pgpKeyId : user.getPgpKeyIds()) {
                if (pgp.getPgpKey(pgpKeyId) != null) continue;
                return true;
            }
        }
        return false;
    }

    private void merge(User toUser, UserDto fromUserDto, Set<Uid> deletedUserRepoKeyIdSet) {
        AssertUtil.assertNotNull((String)"toUser", (Object)toUser);
        AssertUtil.assertNotNull((String)"fromUserDto", (Object)fromUserDto);
        UserRepoKeyDtoConverter userRepoKeyDtoConverter = null;
        UserRepoKeyPublicKeyDtoWithSignatureConverter userRepoKeyPublicKeyDtoWithSignatureConverter = null;
        if (toUser.getChanged().before(fromUserDto.getChanged())) {
            toUser.setFirstName(fromUserDto.getFirstName());
            toUser.setLastName(fromUserDto.getLastName());
            if (!toUser.getEmails().equals(fromUserDto.getEmails())) {
                toUser.getEmails().clear();
                toUser.getEmails().addAll(fromUserDto.getEmails());
            }
            if (!toUser.getPgpKeyIds().equals(fromUserDto.getPgpKeyIds())) {
                toUser.getPgpKeyIds().clear();
                toUser.getPgpKeyIds().addAll(fromUserDto.getPgpKeyIds());
            }
            toUser.setChanged(fromUserDto.getChanged());
            if (!toUser.getChanged().equals(fromUserDto.getChanged())) {
                throw new IllegalStateException("toUser.changed != fromUserDto.changed");
            }
        }
        if (fromUserDto.getUserRepoKeyRingDto() != null) {
            for (UserRepoKeyDto userRepoKeyDto : fromUserDto.getUserRepoKeyRingDto().getUserRepoKeyDtos()) {
                UserRepoKey userRepoKey;
                Uid userRepoKeyId = (Uid)AssertUtil.assertNotNull((String)"userRepoKeyDto.userRepoKeyId", (Object)userRepoKeyDto.getUserRepoKeyId());
                if (deletedUserRepoKeyIdSet.contains(userRepoKeyId) || (userRepoKey = toUser.getUserRepoKeyRingOrCreate().getUserRepoKey(userRepoKeyId)) != null) continue;
                if (userRepoKeyDtoConverter == null) {
                    userRepoKeyDtoConverter = new UserRepoKeyDtoConverter();
                }
                userRepoKey = userRepoKeyDtoConverter.fromUserRepoKeyDto(userRepoKeyDto);
                toUser.getUserRepoKeyRingOrCreate().addUserRepoKey((UserRepoKey)AssertUtil.assertNotNull((String)"userRepoKey", (Object)userRepoKey));
            }
        } else {
            for (UserRepoKeyPublicKeyDto userRepoKeyPublicKeyDto : fromUserDto.getUserRepoKeyPublicKeyDtos()) {
                Uid userRepoKeyId = (Uid)AssertUtil.assertNotNull((String)"userRepoKeyPublicKeyDto.userRepoKeyId", (Object)userRepoKeyPublicKeyDto.getUserRepoKeyId());
                if (deletedUserRepoKeyIdSet.contains(userRepoKeyId) || UserRegistryImpl.contains(toUser.getUserRepoKeyPublicKeys(), userRepoKeyId)) continue;
                if (userRepoKeyPublicKeyDtoWithSignatureConverter == null) {
                    userRepoKeyPublicKeyDtoWithSignatureConverter = new UserRepoKeyPublicKeyDtoWithSignatureConverter();
                }
                UserRepoKey.PublicKeyWithSignature publicKeyWithSignature = userRepoKeyPublicKeyDtoWithSignatureConverter.fromUserRepoKeyPublicKeyDto(userRepoKeyPublicKeyDto);
                toUser.getUserRepoKeyPublicKeys().add((UserRepoKey.PublicKeyWithSignature)AssertUtil.assertNotNull((String)"publicKeyWithSignature", (Object)publicKeyWithSignature));
            }
        }
    }

    private static boolean contains(Collection<UserRepoKey.PublicKeyWithSignature> userRepoKeyPublicKeys, Uid userRepoKeyId) {
        for (UserRepoKey.PublicKeyWithSignature publicKeyWithSignature : userRepoKeyPublicKeys) {
            if (!userRepoKeyId.equals((Object)publicKeyWithSignature.getUserRepoKeyId())) continue;
            return true;
        }
        return false;
    }

    private synchronized UserRegistryDto createUserRegistryDto() {
        UserDtoConverter userDtoConverter = new UserDtoConverter();
        UserRegistryDto userRegistryDto = new UserRegistryDto();
        for (User user : this.userId2User.values()) {
            UserDto userDto = userDtoConverter.toUserDto(user);
            userRegistryDto.getUserDtos().add(userDto);
        }
        userRegistryDto.getDeletedUserIds().addAll(this.deletedUserIds);
        userRegistryDto.setVersion(this.version);
        return userRegistryDto;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(UserRegistry.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(UserRegistry.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    protected void firePropertyChange(UserRegistry.Property property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    private static final class Holder {
        public static final UserRegistryImpl instance = new UserRegistryImpl();

        private Holder() {
        }
    }
}

