/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.user;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyRing;

public class UserRepoKeyRingImpl
implements UserRepoKeyRing {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Map<Uid, UserRepoKey> userRepoKeyId2UserRepoKey = new HashMap<Uid, UserRepoKey>();
    private Collection<UserRepoKey> userRepoKeysCache;
    private Map<UUID, List<UserRepoKey>> repositoryId2InvitationUserRepoKeyList = new HashMap<UUID, List<UserRepoKey>>();
    private Map<UUID, List<UserRepoKey>> repositoryId2PermanentUserRepoKeyList = new HashMap<UUID, List<UserRepoKey>>();

    @Override
    public synchronized Collection<UserRepoKey> getUserRepoKeys() {
        if (this.userRepoKeysCache == null) {
            this.userRepoKeysCache = Collections.unmodifiableCollection(new ArrayList<UserRepoKey>(this.userRepoKeyId2UserRepoKey.values()));
        }
        return this.userRepoKeysCache;
    }

    @Override
    public List<UserRepoKey> getInvitationUserRepoKeys(UUID serverRepositoryId) {
        return this.getUserRepoKeyList(this.repositoryId2InvitationUserRepoKeyList, serverRepositoryId);
    }

    @Override
    public List<UserRepoKey> getPermanentUserRepoKeys(UUID serverRepositoryId) {
        return this.getUserRepoKeyList(this.repositoryId2PermanentUserRepoKeyList, serverRepositoryId);
    }

    protected synchronized List<UserRepoKey> getUserRepoKeyList(Map<UUID, List<UserRepoKey>> repositoryId2UserRepoKeyList, UUID serverRepositoryId) {
        AssertUtil.assertNotNull((String)"repositoryId", (Object)serverRepositoryId);
        List<UserRepoKey> userRepoKeyList = repositoryId2UserRepoKeyList.get(serverRepositoryId);
        if (userRepoKeyList == null) {
            boolean invitation;
            if (this.repositoryId2PermanentUserRepoKeyList == repositoryId2UserRepoKeyList) {
                invitation = false;
            } else if (this.repositoryId2InvitationUserRepoKeyList == repositoryId2UserRepoKeyList) {
                invitation = true;
            } else {
                throw new IllegalArgumentException("repositoryId2UserRepoKeyList unexpected!");
            }
            List<UserRepoKey> l = this.filterByServerRepositoryId(this.userRepoKeyId2UserRepoKey.values(), serverRepositoryId);
            l = this.filterInvitationUserRepoKeys(l, invitation);
            Collections.shuffle(l);
            userRepoKeyList = Collections.unmodifiableList(l);
            repositoryId2UserRepoKeyList.put(serverRepositoryId, userRepoKeyList);
        }
        return userRepoKeyList;
    }

    protected List<UserRepoKey> filterByServerRepositoryId(Collection<UserRepoKey> userRepoKeys, UUID serverRepositoryId) {
        ArrayList<UserRepoKey> result = new ArrayList<UserRepoKey>(userRepoKeys.size());
        for (UserRepoKey userRepoKey : userRepoKeys) {
            if (!serverRepositoryId.equals(userRepoKey.getServerRepositoryId())) continue;
            result.add(userRepoKey);
        }
        return result;
    }

    protected List<UserRepoKey> filterInvitationUserRepoKeys(Collection<UserRepoKey> userRepoKeys, boolean invitation) {
        ArrayList<UserRepoKey> result = new ArrayList<UserRepoKey>(userRepoKeys.size());
        for (UserRepoKey userRepoKey : userRepoKeys) {
            if (invitation != userRepoKey.isInvitation()) continue;
            result.add(userRepoKey);
        }
        result.trimToSize();
        return result;
    }

    @Override
    public synchronized void addUserRepoKey(UserRepoKey userRepoKey) {
        AssertUtil.assertNotNull((String)"userRepoKey", (Object)userRepoKey);
        this.userRepoKeyId2UserRepoKey.put(userRepoKey.getUserRepoKeyId(), userRepoKey);
        this.clearCache(userRepoKey.getServerRepositoryId());
        this.firePropertyChange(UserRepoKeyRing.PropertyEnum.userRepoKeys, null, this.getUserRepoKeys());
    }

    @Override
    public void removeUserRepoKey(UserRepoKey userRepoKey) {
        this.removeUserRepoKey(((UserRepoKey)AssertUtil.assertNotNull((String)"userRepoKey", (Object)userRepoKey)).getUserRepoKeyId());
    }

    @Override
    public synchronized void removeUserRepoKey(Uid userRepoKeyId) {
        UserRepoKey userRepoKey = this.userRepoKeyId2UserRepoKey.remove(AssertUtil.assertNotNull((String)"userRepoKeyId", (Object)userRepoKeyId));
        if (userRepoKey != null) {
            this.clearCache(userRepoKey.getServerRepositoryId());
            this.firePropertyChange(UserRepoKeyRing.PropertyEnum.userRepoKeys, null, this.getUserRepoKeys());
        }
    }

    private void clearCache(UUID serverRepositoryId) {
        AssertUtil.assertNotNull((String)"serverRepositoryId", (Object)serverRepositoryId);
        this.userRepoKeysCache = null;
        this.repositoryId2PermanentUserRepoKeyList.remove(serverRepositoryId);
        this.repositoryId2InvitationUserRepoKeyList.remove(serverRepositoryId);
    }

    @Override
    public synchronized UserRepoKey getUserRepoKey(Uid userRepoKeyId) {
        return this.userRepoKeyId2UserRepoKey.get(AssertUtil.assertNotNull((String)"userRepoKeyId", (Object)userRepoKeyId));
    }

    @Override
    public UserRepoKey getUserRepoKeyOrFail(Uid userRepoKeyId) {
        UserRepoKey userRepoKey = this.getUserRepoKey(userRepoKeyId);
        if (userRepoKey == null) {
            throw new IllegalStateException(String.format("There is no UserRepoKey with userRepoKeyId='%s'!", userRepoKeyId));
        }
        return userRepoKey;
    }

    @Override
    public synchronized List<UserRepoKey> getUserRepoKeys(UUID serverRepositoryId) {
        List<UserRepoKey> l = this.filterByServerRepositoryId(this.userRepoKeyId2UserRepoKey.values(), serverRepositoryId);
        Collections.shuffle(l);
        return Collections.unmodifiableList(l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(UserRepoKeyRing.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(UserRepoKeyRing.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    protected void firePropertyChange(UserRepoKeyRing.Property property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserRepoKeyRingImpl clone() {
        UserRepoKeyRingImpl clone;
        try {
            clone = (UserRepoKeyRingImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.propertyChangeSupport = new PropertyChangeSupport(clone);
        clone.userRepoKeyId2UserRepoKey = new HashMap<Uid, UserRepoKey>();
        UserRepoKeyRingImpl userRepoKeyRingImpl = this;
        synchronized (userRepoKeyRingImpl) {
            clone.userRepoKeyId2UserRepoKey.putAll(this.userRepoKeyId2UserRepoKey);
        }
        clone.repositoryId2InvitationUserRepoKeyList = new HashMap<UUID, List<UserRepoKey>>();
        clone.repositoryId2PermanentUserRepoKeyList = new HashMap<UUID, List<UserRepoKey>>();
        return clone;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.getUserRepoKeys() + ']';
    }
}

