/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Uniques(value={@Unique(name="CryptoConfigPropSet_cryptoRepoFile", members={"cryptoRepoFile"})})
@Queries(value={@Query(name="getCryptoConfigPropSet_cryptoRepoFile", value="SELECT UNIQUE WHERE this.cryptoRepoFile == :cryptoRepoFile"), @Query(name="getCryptoConfigPropSetsChangedAfter_localRevision_exclLastSyncFromRepositoryId", value="SELECT WHERE this.localRevision > :localRevision && (this.lastSyncFromRepositoryId == null || this.lastSyncFromRepositoryId != :lastSyncFromRepositoryId)")})
public class CryptoConfigPropSet
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    private CryptoRepoFile cryptoRepoFile;
    private long localRevision;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private CryptoKey cryptoKey;
    @Column(jdbcType="BLOB")
    private byte[] configPropSetDtoData;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private String lastSyncFromRepositoryId;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    protected CryptoConfigPropSet() {
    }

    public CryptoConfigPropSet(CryptoRepoFile cryptoRepoFile) {
        this.cryptoRepoFile = (CryptoRepoFile)((Object)AssertUtil.assertNotNull((String)"cryptoRepoFile", (Object)((Object)cryptoRepoFile)));
    }

    public Uid getCryptoRepoFileId() {
        return CryptoConfigPropSet.dnGetcryptoRepoFile(this).getCryptoRepoFileId();
    }

    public CryptoRepoFile getCryptoRepoFile() {
        return CryptoConfigPropSet.dnGetcryptoRepoFile(this);
    }

    public long getLocalRevision() {
        return CryptoConfigPropSet.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)CryptoConfigPropSet.dnGetlocalRevision(this), (long)localRevision)) {
            CryptoConfigPropSet.dnSetlocalRevision(this, localRevision);
        }
    }

    public UUID getLastSyncFromRepositoryId() {
        return CryptoConfigPropSet.dnGetlastSyncFromRepositoryId(this) == null ? null : UUID.fromString(CryptoConfigPropSet.dnGetlastSyncFromRepositoryId(this));
    }

    public void setLastSyncFromRepositoryId(UUID repositoryId) {
        if (!Util.equal((Object)this.getLastSyncFromRepositoryId(), (Object)repositoryId)) {
            CryptoConfigPropSet.dnSetlastSyncFromRepositoryId(this, repositoryId == null ? null : repositoryId.toString());
        }
    }

    public byte[] getConfigPropSetDtoData() {
        return CryptoConfigPropSet.dnGetconfigPropSetDtoData(this);
    }

    public void setConfigPropSetDtoData(byte[] configPropSetDtoData) {
        if (!Util.equal((byte[])CryptoConfigPropSet.dnGetconfigPropSetDtoData(this), (byte[])configPropSetDtoData)) {
            CryptoConfigPropSet.dnSetconfigPropSetDtoData(this, configPropSetDtoData);
        }
    }

    public CryptoKey getCryptoKey() {
        return CryptoConfigPropSet.dnGetcryptoKey(this);
    }

    public void setCryptoKey(CryptoKey cryptoKey) {
        if (!Util.equal((Object)((Object)CryptoConfigPropSet.dnGetcryptoKey(this)), (Object)((Object)cryptoKey))) {
            CryptoKeyRole cryptoKeyRole;
            if (cryptoKey != null && CryptoKeyRole.dataKey != (cryptoKeyRole = (CryptoKeyRole)AssertUtil.assertNotNull((String)"cryptoKey.cryptoKeyRole", (Object)cryptoKey.getCryptoKeyRole()))) {
                throw new IllegalArgumentException("cryptoKey.cryptoKeyRole != dataKey");
            }
            CryptoConfigPropSet.dnSetcryptoKey(this, cryptoKey);
        }
    }

    public Signature getSignature() {
        return CryptoConfigPropSet.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)CryptoConfigPropSet.dnGetsignature(this), (Object)signature)) {
            CryptoConfigPropSet.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public String getSignedDataType() {
        return "CryptoConfigPropSet";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[5];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource((Uid)((CryptoKey)((Object)AssertUtil.assertNotNull((String)"cryptoKey", (Object)((Object)CryptoConfigPropSet.dnGetcryptoKey(this))))).getCryptoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource((byte[])CryptoConfigPropSet.dnGetconfigPropSetDtoData(this));
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        return (Uid)AssertUtil.assertNotNull((String)"cryptoRepoFileId", (Object)this.getCryptoRepoFileId());
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.write;
    }

    public String toString() {
        return String.format("%s{cryptoRepoFileId=%s, cryptoKeyId=%s}", super.toString(), this.getCryptoRepoFileId(), CryptoConfigPropSet.dnGetcryptoKey(this) == null ? null : CryptoConfigPropSet.dnGetcryptoKey(this).getCryptoKeyId());
    }

    static {
        dnFieldNames = CryptoConfigPropSet.__dnFieldNamesInit();
        dnFieldTypes = CryptoConfigPropSet.__dnFieldTypesInit();
        dnFieldFlags = CryptoConfigPropSet.__dnFieldFlagsInit();
        dnInheritedFieldCount = CryptoConfigPropSet.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = CryptoConfigPropSet.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)CryptoConfigPropSet.___dn$loadClass("org.subshare.local.persistence.CryptoConfigPropSet"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new CryptoConfigPropSet());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        CryptoConfigPropSet result = new CryptoConfigPropSet();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        CryptoConfigPropSet result = new CryptoConfigPropSet();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.configPropSetDtoData = (byte[])this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.cryptoKey = (CryptoKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 2: {
                this.cryptoRepoFile = (CryptoRepoFile)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 3: {
                this.lastSyncFromRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 4: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 5: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.configPropSetDtoData);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoKey);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoRepoFile);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.lastSyncFromRepositoryId);
                break;
            }
            case 4: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(CryptoConfigPropSet obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.configPropSetDtoData = obj.configPropSetDtoData;
                break;
            }
            case 1: {
                this.cryptoKey = obj.cryptoKey;
                break;
            }
            case 2: {
                this.cryptoRepoFile = obj.cryptoRepoFile;
                break;
            }
            case 3: {
                this.lastSyncFromRepositoryId = obj.lastSyncFromRepositoryId;
                break;
            }
            case 4: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 5: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof CryptoConfigPropSet)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.CryptoConfigPropSet");
        }
        CryptoConfigPropSet other = (CryptoConfigPropSet)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"configPropSetDtoData", "cryptoKey", "cryptoRepoFile", "lastSyncFromRepositoryId", "localRevision", "signature"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{CryptoConfigPropSet.___dn$loadClass("[B"), CryptoConfigPropSet.___dn$loadClass("org.subshare.local.persistence.CryptoKey"), CryptoConfigPropSet.___dn$loadClass("org.subshare.local.persistence.CryptoRepoFile"), CryptoConfigPropSet.___dn$loadClass("java.lang.String"), Long.TYPE, CryptoConfigPropSet.___dn$loadClass("org.subshare.local.persistence.SignatureImpl")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{26, 10, 10, 21, 21, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 6 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return CryptoConfigPropSet.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        CryptoConfigPropSet o = (CryptoConfigPropSet)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static byte[] dnGetconfigPropSetDtoData(CryptoConfigPropSet objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (byte[])objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.configPropSetDtoData);
        }
        return objPC.configPropSetDtoData;
    }

    private static void dnSetconfigPropSetDtoData(CryptoConfigPropSet objPC, byte[] val) {
        if (objPC.dnStateManager == null) {
            objPC.configPropSetDtoData = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.configPropSetDtoData, (Object)val);
        }
    }

    private static CryptoKey dnGetcryptoKey(CryptoConfigPropSet objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (CryptoKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.cryptoKey));
        }
        return objPC.cryptoKey;
    }

    private static void dnSetcryptoKey(CryptoConfigPropSet objPC, CryptoKey val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.cryptoKey, (Object)val);
        }
    }

    private static CryptoRepoFile dnGetcryptoRepoFile(CryptoConfigPropSet objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (CryptoRepoFile)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFile));
        }
        return objPC.cryptoRepoFile;
    }

    private static void dnSetcryptoRepoFile(CryptoConfigPropSet objPC, CryptoRepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoRepoFile = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFile, (Object)val);
        }
    }

    private static String dnGetlastSyncFromRepositoryId(CryptoConfigPropSet objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId);
        }
        return objPC.lastSyncFromRepositoryId;
    }

    private static void dnSetlastSyncFromRepositoryId(CryptoConfigPropSet objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId, val);
        } else {
            objPC.lastSyncFromRepositoryId = val;
        }
    }

    private static long dnGetlocalRevision(CryptoConfigPropSet objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(CryptoConfigPropSet objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static SignatureImpl dnGetsignature(CryptoConfigPropSet objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(CryptoConfigPropSet objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

