/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.otp;

import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.otp.OneTimePadEncryptor;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class OneTimePadRegistry {
    public static final String PASSWORD_FILE_SUFFIX = "Password";
    public static final String RANDOM_KEY_FILE_SUFFIX = "RandomKey";
    private final String fileNamePrefix;
    private final OneTimePadEncryptor encryptor = new OneTimePadEncryptor();

    public OneTimePadRegistry(String fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
    }

    public void encryptAndStorePassword(char[] password) {
        OneTimePadEncryptor.Result result = this.encryptor.encrypt(this.toBytes(password));
        try {
            this.writeToFile(result.getEncryptedMessage(), PASSWORD_FILE_SUFFIX);
            this.writeToFile(result.getRandomKey(), RANDOM_KEY_FILE_SUFFIX);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public char[] readFromFileAndDecrypt() {
        try {
            byte[] encryptedPassword = this.readFromFile(PASSWORD_FILE_SUFFIX);
            byte[] randomKey = this.readFromFile(RANDOM_KEY_FILE_SUFFIX);
            byte[] decryptedPassword = this.encryptor.decrypt(encryptedPassword, randomKey);
            return this.toChars(decryptedPassword);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] readFromFile(String fileNameSuffix) throws IOException {
        String fileName = this.fileNamePrefix + fileNameSuffix;
        File file = OioFileFactory.createFile(ConfigDir.getInstance().getFile(), fileName);
        return IOUtil.getBytesFromFile(file);
    }

    private void writeToFile(byte[] bytes, String fileNameSuffix) throws IOException {
        File file = OioFileFactory.createFile(ConfigDir.getInstance().getFile(), this.fileNamePrefix + fileNameSuffix);
        try (OutputStream os = file.createOutputStream();){
            os.write(bytes);
        }
    }

    private byte[] toBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        this.clearSensitiveData(charBuffer.array(), byteBuffer.array());
        return bytes;
    }

    private char[] toChars(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(byteBuffer);
        char[] chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
        this.clearSensitiveData(charBuffer.array(), byteBuffer.array());
        return chars;
    }

    private void clearSensitiveData(char[] chars, byte[] bytes) {
        Arrays.fill(chars, '\u0000');
        Arrays.fill(bytes, (byte)0);
    }
}

