/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.provider;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.io.NoCloseOutputStream;
import co.codewizards.cloudstore.core.ls.NoObjectRef;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.ReflectionUtil;
import co.codewizards.cloudstore.ls.core.invoke.ForceNonTransientClassSet;
import co.codewizards.cloudstore.ls.core.invoke.ForceNonTransientContainer;
import co.codewizards.cloudstore.ls.core.invoke.ObjectGraphContainer;
import co.codewizards.cloudstore.ls.core.invoke.ObjectManager;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRef;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRefConverter;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRefConverterFactory;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/java-native+oref"})
public class JavaNativeWithObjectRefMessageBodyWriter
implements MessageBodyWriter<Object> {
    private final ObjectRefConverterFactory objectRefConverterFactory;
    @Context
    private SecurityContext securityContext;
    private static NoObjectRef NO_OBJECT_REF_FALLBACK = new NoObjectRef(){

        public Class<? extends Annotation> annotationType() {
            return NoObjectRef.class;
        }

        public boolean value() {
            return false;
        }

        public boolean inheritToObjectGraphChildren() {
            return true;
        }
    };

    public JavaNativeWithObjectRefMessageBodyWriter(ObjectRefConverterFactory objectRefConverterFactory) {
        this.objectRefConverterFactory = (ObjectRefConverterFactory)AssertUtil.assertNotNull((String)"objectRefConverterFactory", (Object)objectRefConverterFactory);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ObjectRefConverter objectRefConverter = this.objectRefConverterFactory.createObjectRefConverter(this.securityContext);
        ObjectGraphContainer objectGraphContainer = new ObjectGraphContainer(t);
        NoObjectRefAnalyser noObjectRefAnalyser = new NoObjectRefAnalyser(objectGraphContainer);
        try (ReplacingObjectOutputStream oout = new ReplacingObjectOutputStream((OutputStream)new NoCloseOutputStream(entityStream), objectRefConverter, noObjectRefAnalyser, objectGraphContainer);){
            oout.writeObject(objectGraphContainer);
            oout.flush();
        }
    }

    private static class NoObjectRefAnalyser {
        private static final Logger logger = LoggerFactory.getLogger(NoObjectRefAnalyser.class);
        private final IdentityHashMap<Object, NoObjectRef> object2NoObjectRef = new IdentityHashMap();

        public NoObjectRefAnalyser(Object root) {
            this.analyse(root);
        }

        public void analyse(Object root) {
            this.analyse(new LinkedList<Object>(), null, root, new IdentityHashMap<Object, Void>());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void analyse(LinkedList<Object> parentStack, Object parent, Object object, IdentityHashMap<Object, Void> processedObjects) {
            if (object == null) {
                return;
            }
            if (parentStack.size() >= 4) {
                return;
            }
            if (parent != null) {
                parentStack.addLast(parent);
            }
            try {
                if (processedObjects.containsKey(object)) {
                    return;
                }
                logger.debug("analyse: object={}", object);
                processedObjects.put(object, null);
                NoObjectRef noObjectRefVal = this.object2NoObjectRef.get(object);
                if (noObjectRefVal == null) {
                    NoObjectRef noObjectRef = object.getClass().getAnnotation(NoObjectRef.class);
                    if (noObjectRef == null) {
                        NoObjectRef parentNoObjectRef = parent == null ? NO_OBJECT_REF_FALLBACK : this.object2NoObjectRef.get(parent);
                        this.object2NoObjectRef.put(object, parentNoObjectRef);
                    } else {
                        this.object2NoObjectRef.put(object, noObjectRef);
                    }
                }
                if (this.isTypeConsideredLeaf(object)) {
                    return;
                }
                if (object.getClass().isArray()) {
                    if (Object.class.isAssignableFrom(object.getClass().getComponentType())) {
                        int length = Array.getLength(object);
                        for (int i = 0; i < length; ++i) {
                            Object object2 = Array.get(object, i);
                            this.analyse(parentStack, object, object2, processedObjects);
                        }
                    }
                } else if (object instanceof Collection) {
                    Collection c = (Collection)object;
                    for (Object e : c) {
                        this.analyse(parentStack, object, e, processedObjects);
                    }
                } else if (object instanceof Map) {
                    Map m = (Map)object;
                    for (Map.Entry entry : m.entrySet()) {
                        this.analyse(parentStack, object, entry.getKey(), processedObjects);
                        this.analyse(parentStack, object, entry.getValue(), processedObjects);
                    }
                } else {
                    List allDeclaredFields = ReflectionUtil.getAllDeclaredFields(object.getClass());
                    ArrayList<Object> children = new ArrayList<Object>(allDeclaredFields.size());
                    for (Field field : allDeclaredFields) {
                        if ((8 & field.getModifiers()) != 0 || (0x80 & field.getModifiers()) != 0) continue;
                        Object child = this.getFieldValue(object, field);
                        children.add(child);
                        logger.debug("analyse: field={} child=", (Object)field, child);
                        NoObjectRef noObjectRef = field.getAnnotation(NoObjectRef.class);
                        if (noObjectRef == null) {
                            NoObjectRef noObjectRef2 = noObjectRef = child == null ? null : child.getClass().getAnnotation(NoObjectRef.class);
                        }
                        if (noObjectRef == null) {
                            NoObjectRef parentNoObjectRef = this.object2NoObjectRef.get(object);
                            if (!parentNoObjectRef.inheritToObjectGraphChildren()) continue;
                            this.object2NoObjectRef.put(child, parentNoObjectRef);
                            continue;
                        }
                        this.object2NoObjectRef.put(child, noObjectRef);
                    }
                    for (Object e : children) {
                        this.analyse(parentStack, object, e, processedObjects);
                    }
                }
            }
            finally {
                if (parent != null) {
                    parentStack.removeLast();
                }
            }
        }

        private Object getFieldValue(Object object, Field field) {
            field.setAccessible(true);
            try {
                return field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isNoObjectRef(Object object) {
            NoObjectRef result = this.object2NoObjectRef.get(object);
            if (result == null) {
                NoObjectRef noObjectRef = object.getClass().getAnnotation(NoObjectRef.class);
                if (noObjectRef != null) {
                    return noObjectRef.value();
                }
                return false;
            }
            return result.value();
        }

        private boolean isTypeConsideredLeaf(Object object) {
            Class<?> clazz = object.getClass();
            if (ObjectManager.isObjectRefMappingEnabled(object)) {
                return true;
            }
            return !clazz.getName().startsWith("co.codewizards.") && !clazz.getName().startsWith("org.");
        }
    }

    private static class ReplacingObjectOutputStream
    extends ObjectOutputStream {
        private final NoObjectRefAnalyser noObjectRefAnalyser;
        private final ObjectRefConverter objectRefConverter;
        private final ObjectGraphContainer objectGraphContainer;

        public ReplacingObjectOutputStream(OutputStream out, ObjectRefConverter objectRefConverter, NoObjectRefAnalyser noObjectRefAnalyser, ObjectGraphContainer objectGraphContainer) throws IOException {
            super(out);
            this.objectRefConverter = (ObjectRefConverter)AssertUtil.assertNotNull((String)"objectRefConverter", (Object)objectRefConverter);
            this.noObjectRefAnalyser = (NoObjectRefAnalyser)AssertUtil.assertNotNull((String)"noObjectRefAnalyser", (Object)noObjectRefAnalyser);
            this.objectGraphContainer = (ObjectGraphContainer)AssertUtil.assertNotNull((String)"objectGraphContainer", (Object)objectGraphContainer);
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object object) throws IOException {
            List<Field> transientFields;
            if (object == null || object instanceof ObjectRef || object instanceof Uid) {
                return object;
            }
            if (this.noObjectRefAnalyser.isNoObjectRef(object)) {
                return object;
            }
            Object result = this.objectRefConverter.convertToObjectRefIfNeeded(object);
            if (result != object) {
                this.noObjectRefAnalyser.analyse(result);
            }
            if (ForceNonTransientClassSet.getInstance().isForceNonTransientClass(result.getClass()) && !(transientFields = this.getTransientFields(result.getClass())).isEmpty()) {
                ForceNonTransientContainer forceNonTransientContainer = this.createForceNonTransientContainer(result, transientFields);
                this.objectGraphContainer.putForceNonTransientContainer(forceNonTransientContainer);
            }
            return result;
        }

        private ForceNonTransientContainer createForceNonTransientContainer(Object object, List<Field> transientFields) {
            HashMap<String, Object> transientFieldName2Value = new HashMap<String, Object>();
            for (Field field : transientFields) {
                Object fieldValue;
                field.setAccessible(true);
                try {
                    fieldValue = field.get(object);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                String fieldName = field.getDeclaringClass().getName() + '.' + field.getName();
                transientFieldName2Value.put(fieldName, fieldValue);
            }
            return new ForceNonTransientContainer(object, transientFieldName2Value);
        }

        private List<Field> getTransientFields(Class<?> clazz) {
            List allDeclaredFields = ReflectionUtil.getAllDeclaredFields(clazz);
            ArrayList<Field> transientFields = new ArrayList<Field>();
            for (Field field : allDeclaredFields) {
                if ((0x80 & field.getModifiers()) == 0) continue;
                transientFields.add(field);
            }
            return transientFields;
        }
    }
}

