/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.core.invoke.ClassManager;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRef;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxyManager;
import co.codewizards.cloudstore.ls.core.invoke.refjanitor.ReferenceJanitorRegistry;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectManager {
    protected static final long EVICT_UNUSED_OBJECT_MANAGER_TIMEOUT_MS = 120000L;
    protected static final long EVICT_UNUSED_OBJECT_MANAGER_PERIOD_MS = 60000L;
    protected static final long EVICT_ZERO_REFERENCE_OBJECT_REFS_TIMEOUT_MS = 30000L;
    protected static final long EVICT_ZERO_REFERENCE_OBJECT_REFS_PERIOD_MS = 5000L;
    private static final Logger logger = LoggerFactory.getLogger(ObjectManager.class);
    private final Uid clientId;
    private long nextObjectId;
    private volatile Date lastUseDate;
    private volatile boolean neverEvict;
    private boolean closed;
    private final Map<ObjectRef, Object> objectRef2Object = new HashMap<ObjectRef, Object>();
    private final Map<Object, ObjectRef> object2ObjectRef = new IdentityHashMap<Object, ObjectRef>();
    private final Map<String, Object> contextObjectMap = new HashMap<String, Object>();
    private final Map<ObjectRef, Long> zeroReferenceObjectRef2Timestamp = new HashMap<ObjectRef, Long>();
    private final Map<ObjectRef, Set<Uid>> objectRef2RefIds = new HashMap<ObjectRef, Set<Uid>>();
    private final RemoteObjectProxyManager remoteObjectProxyManager = new RemoteObjectProxyManager();
    private final ClassManager classManager;
    private final ReferenceJanitorRegistry referenceJanitorRegistry;
    private static final Map<Uid, ObjectManager> clientId2ObjectManager = new HashMap<Uid, ObjectManager>();
    private static long evictOldObjectManagersLastInvocation = 0L;
    private static long evictZeroReferenceObjectRefsLastInvocation = 0L;
    private static final Timer timer = new Timer(true);
    private static final TimerTask timerTask = new TimerTask(){

        @Override
        public void run() {
            try {
                ObjectManager.evictOldObjectManagers();
            }
            catch (Exception x) {
                logger.error("run: " + x, (Throwable)x);
            }
            try {
                ObjectManager.allObjectManagers_evictZeroReferenceObjectRefs();
            }
            catch (Exception x) {
                logger.error("run: " + x, (Throwable)x);
            }
        }
    };

    public static synchronized ObjectManager getInstance(Uid clientId) {
        AssertUtil.assertNotNull((String)"clientId", (Object)clientId);
        ObjectManager objectManager = clientId2ObjectManager.get(clientId);
        if (objectManager == null) {
            objectManager = new ObjectManager(clientId);
            clientId2ObjectManager.put(clientId, objectManager);
        }
        objectManager.updateLastUseDate();
        return objectManager;
    }

    @Deprecated
    public static synchronized void clearObjectManagers() {
        clientId2ObjectManager.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void evictOldObjectManagers() {
        int objectManagerCountTotal = 0;
        int objectManagerCountNeverEvict = 0;
        LinkedList<ObjectManager> objectManagersToClose = new LinkedList<ObjectManager>();
        Class<ObjectManager> clazz = ObjectManager.class;
        synchronized (ObjectManager.class) {
            long now = System.currentTimeMillis();
            if (evictOldObjectManagersLastInvocation > now - 60000L) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            evictOldObjectManagersLastInvocation = now;
            for (ObjectManager objectManager : clientId2ObjectManager.values()) {
                ++objectManagerCountTotal;
                if (objectManager.isNeverEvict()) {
                    ++objectManagerCountNeverEvict;
                    continue;
                }
                if (objectManager.getLastUseDate().getTime() >= now - 120000L) continue;
                objectManagersToClose.add(objectManager);
                logger.debug("evictOldObjectManagers: evicting ObjectManager with clientId={}", (Object)objectManager.getClientId());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (ObjectManager objectManager : objectManagersToClose) {
                objectManager.close();
            }
            logger.debug("evictOldObjectManagers: objectManagerCountTotal={} objectManagerCountNeverEvict={} objectManagerCountEvicted={}", new Object[]{objectManagerCountTotal, objectManagerCountNeverEvict, objectManagersToClose.size()});
            return;
        }
    }

    private static synchronized List<ObjectManager> getObjectManagers() {
        ArrayList<ObjectManager> objectManagers = new ArrayList<ObjectManager>(clientId2ObjectManager.values());
        return objectManagers;
    }

    private static void allObjectManagers_evictZeroReferenceObjectRefs() {
        long now = System.currentTimeMillis();
        if (evictZeroReferenceObjectRefsLastInvocation > now - 5000L) {
            return;
        }
        evictZeroReferenceObjectRefsLastInvocation = now;
        List<ObjectManager> objectManagers = ObjectManager.getObjectManagers();
        for (ObjectManager objectManager : objectManagers) {
            objectManager.evictZeroReferenceObjectRefs();
        }
    }

    private synchronized void evictZeroReferenceObjectRefs() {
        long now = System.currentTimeMillis();
        LinkedList<ObjectRef> objectRefsToRemove = new LinkedList<ObjectRef>();
        for (Map.Entry<ObjectRef, Long> me : this.zeroReferenceObjectRef2Timestamp.entrySet()) {
            ObjectRef objectRef = me.getKey();
            long timestamp = me.getValue();
            if (timestamp >= now - 30000L) continue;
            objectRefsToRemove.add(objectRef);
        }
        for (ObjectRef objectRef : objectRefsToRemove) {
            this.remove(objectRef);
        }
    }

    protected ObjectManager(Uid clientId) {
        this.clientId = (Uid)AssertUtil.assertNotNull((String)"clientId", (Object)clientId);
        this.classManager = new ClassManager(clientId);
        this.referenceJanitorRegistry = new ReferenceJanitorRegistry(this);
        logger.debug("[{}].<init>: Created ObjectManager.", (Object)clientId);
    }

    protected Date getLastUseDate() {
        return this.lastUseDate;
    }

    private void updateLastUseDate() {
        this.lastUseDate = new Date();
    }

    public boolean isNeverEvict() {
        return this.neverEvict;
    }

    public void setNeverEvict(boolean neverEvict) {
        this.neverEvict = neverEvict;
    }

    public Uid getClientId() {
        return this.clientId;
    }

    public synchronized Object getContextObject(String key) {
        return this.contextObjectMap.get(key);
    }

    public synchronized void putContextObject(String key, Object object) {
        this.contextObjectMap.put(key, object);
    }

    protected synchronized ObjectRef createObjectRef(Class<?> clazz) {
        this.assertNotClosed();
        int classId = this.classManager.getClassIdOrCreate(clazz);
        ObjectRef objectRef = new ObjectRef(this.clientId, classId, this.nextObjectId++);
        if (!this.classManager.isClassIdKnownByRemoteSide(classId)) {
            objectRef.setClassInfo(this.classManager.getClassInfo(classId));
        }
        return objectRef;
    }

    public synchronized Object getObjectRefOrObject(Object object) {
        if (ObjectManager.isObjectRefMappingEnabled(object)) {
            return this.getObjectRefOrCreate(object);
        }
        return object;
    }

    public synchronized ObjectRef getObjectRefOrCreate(Object object) {
        ObjectRef objectRef = this.getObjectRef(object);
        if (objectRef == null) {
            objectRef = this.createObjectRef(object.getClass());
            if (logger.isDebugEnabled()) {
                logger.debug("[{}].getObjectRefOrCreate: Created {} for {} ({}).", new Object[]{this.clientId, objectRef, Util.toIdentityString((Object)object), object});
            }
            this.objectRef2Object.put(objectRef, object);
            this.object2ObjectRef.put(object, objectRef);
            this.zeroReferenceObjectRef2Timestamp.put(objectRef, System.currentTimeMillis());
        } else if (this.zeroReferenceObjectRef2Timestamp.containsKey(objectRef)) {
            this.zeroReferenceObjectRef2Timestamp.put(objectRef, System.currentTimeMillis());
        }
        return objectRef;
    }

    public synchronized ObjectRef getObjectRefOrFail(Object object) {
        ObjectRef objectRef = this.getObjectRef(object);
        if (objectRef == null) {
            throw new IllegalArgumentException(String.format("ObjectManager[%s] does not have ObjectRef for this object: %s (%s)", this.clientId, Util.toIdentityString((Object)object), object));
        }
        return objectRef;
    }

    public synchronized ObjectRef getObjectRef(Object object) {
        AssertUtil.assertNotNull((String)"object", (Object)object);
        ObjectManager.assertNotInstanceOfObjectRef(object);
        ObjectRef objectRef = this.object2ObjectRef.get(object);
        this.updateLastUseDate();
        return objectRef;
    }

    public synchronized Object getObjectOrFail(ObjectRef objectRef) {
        Object object = this.getObject(objectRef);
        if (object == null) {
            throw new IllegalArgumentException(String.format("ObjectManager[%s] does not have object for this ObjectRef: %s", this.clientId, objectRef));
        }
        return object;
    }

    public synchronized Object getObject(ObjectRef objectRef) {
        AssertUtil.assertNotNull((String)"objectRef", (Object)objectRef);
        Object object = this.objectRef2Object.get(objectRef);
        this.updateLastUseDate();
        return object;
    }

    private synchronized void remove(ObjectRef objectRef) {
        AssertUtil.assertNotNull((String)"objectRef", (Object)objectRef);
        if (!this.objectRef2Object.containsKey(objectRef)) {
            throw new IllegalStateException("!objectRef2Object.containsKey(objectRef): " + objectRef);
        }
        this.zeroReferenceObjectRef2Timestamp.remove(objectRef);
        Object object = this.objectRef2Object.remove(objectRef);
        this.object2ObjectRef.remove(object);
        this.updateLastUseDate();
        logger.debug("remove: {}", (Object)objectRef);
    }

    public synchronized void incRefCount(Object object, Uid refId) {
        int refCountAfter;
        int refCountBefore;
        AssertUtil.assertNotNull((String)"object", (Object)object);
        AssertUtil.assertNotNull((String)"refId", (Object)refId);
        ObjectRef objectRef = this.getObjectRefOrFail(object);
        if (this.zeroReferenceObjectRef2Timestamp.remove(objectRef) != null) {
            if (this.objectRef2RefIds.put(objectRef, new HashSet<Uid>(Collections.singleton(refId))) != null) {
                throw new IllegalStateException("Collision! WTF?!");
            }
            refCountBefore = 0;
            refCountAfter = 1;
        } else {
            Set<Uid> refIds = this.objectRef2RefIds.get(objectRef);
            refCountBefore = refIds.size();
            AssertUtil.assertNotNull((String)("objectRef2RefIds.get(" + objectRef + ")"), refIds);
            refIds.add(refId);
            refCountAfter = refIds.size();
        }
        this.classManager.setClassIdKnownByRemoteSide(objectRef.getClassId());
        logger.trace("[{}].incRefCount: {} refCountAfter={} refCountBefore={} refId={}", new Object[]{this.clientId, objectRef, refCountAfter, refCountBefore, refId});
    }

    public synchronized void decRefCount(Object object, Uid refId) {
        AssertUtil.assertNotNull((String)"object", (Object)object);
        AssertUtil.assertNotNull((String)"refId", (Object)refId);
        int refCountBefore = 0;
        int refCountAfter = 0;
        ObjectRef objectRef = this.getObjectRefOrFail(object);
        Set<Uid> refIds = this.objectRef2RefIds.get(objectRef);
        if (refIds != null) {
            refCountBefore = refIds.size();
            refIds.remove(refId);
            refCountAfter = refIds.size();
            if (refIds.isEmpty()) {
                this.objectRef2RefIds.remove(objectRef);
                this.zeroReferenceObjectRef2Timestamp.put(objectRef, System.currentTimeMillis());
            }
        }
        logger.trace("[{}].decRefCount: {} refCountAfter={} refCountBefore={} refId={}", new Object[]{this.clientId, objectRef, refCountAfter, refCountBefore, refId});
    }

    private static void assertNotInstanceOfObjectRef(Object object) {
        if (object instanceof ObjectRef) {
            throw new IllegalArgumentException("object is an instance of ObjectRef! " + object);
        }
    }

    public RemoteObjectProxyManager getRemoteObjectProxyManager() {
        return this.remoteObjectProxyManager;
    }

    public ClassManager getClassManager() {
        return this.classManager;
    }

    public static boolean isObjectRefMappingEnabled(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ObjectRef) {
            return false;
        }
        Class<?> clazz = ObjectManager.getClassOrArrayComponentType(object);
        if (Proxy.isProxyClass(clazz)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        return !(object instanceof Serializable);
    }

    private static Class<?> getClassOrArrayComponentType(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        return clazz;
    }

    public ReferenceJanitorRegistry getReferenceCleanerRegistry() {
        return this.referenceJanitorRegistry;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    protected synchronized void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException(String.format("ObjectManager[%s] is closed!", this.clientId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        object = ObjectManager.class;
        synchronized (ObjectManager.class) {
            clientId2ObjectManager.remove(this.clientId);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.referenceJanitorRegistry.cleanUp();
            return;
        }
    }

    static {
        long period = BigInteger.valueOf(60000L).gcd(BigInteger.valueOf(5000L)).longValue();
        timer.schedule(timerTask, period, period);
    }
}

