/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.local;

import co.codewizards.cloudstore.core.collection.LazyUnmodifiableList;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.dto.DateTime;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRepoRegistryImpl
implements LocalRepoRegistry {
    private static final Logger logger = LoggerFactory.getLogger(LocalRepoRegistry.class);
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static final String PROP_KEY_PREFIX_REPOSITORY_ID = "repositoryId:";
    private static final String PROP_KEY_PREFIX_REPOSITORY_ALIAS = "repositoryAlias:";
    private static final String PROP_EVICT_DEAD_ENTRIES_LAST_TIMESTAMP = "evictDeadEntriesLastTimestamp";
    @Deprecated
    private static final String PROP_EVICT_DEAD_ENTRIES_PERIOD = "evictDeadEntriesPeriod";
    private static final long LOCK_TIMEOUT_MS = 10000L;
    private File registryFile;
    private long repoRegistryFileLastModified;
    private Properties repoRegistryProperties;
    private boolean repoRegistryPropertiesDirty;

    public static LocalRepoRegistry getInstance() {
        return LocalRepoRegistryHolder.INSTANCE;
    }

    private LocalRepoRegistryImpl() {
    }

    private File getRegistryFile() {
        if (this.registryFile == null) {
            File old = OioFileFactory.createFile(ConfigDir.getInstance().getFile(), "repositoryList.properties");
            this.registryFile = OioFileFactory.createFile(ConfigDir.getInstance().getFile(), "repoRegistry.properties");
            if (old.exists() && !this.registryFile.exists()) {
                old.renameTo(this.registryFile);
            }
        }
        return this.registryFile;
    }

    @Override
    public synchronized Collection<UUID> getRepositoryIds() {
        this.loadRepoRegistryIfNeeded();
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (Map.Entry<Object, Object> me : this.repoRegistryProperties.entrySet()) {
            String key = String.valueOf(me.getKey());
            if (!key.startsWith(PROP_KEY_PREFIX_REPOSITORY_ID)) continue;
            UUID repositoryId = UUID.fromString(key.substring(PROP_KEY_PREFIX_REPOSITORY_ID.length()));
            result.add(repositoryId);
        }
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    @Override
    public synchronized UUID getRepositoryId(String repositoryName) {
        UUID repositoryId;
        AssertUtil.assertNotNull("repositoryName", repositoryName);
        this.loadRepoRegistryIfNeeded();
        String repositoryIdString = this.repoRegistryProperties.getProperty(this.getPropertyKeyForAlias(repositoryName));
        if (repositoryIdString != null) {
            UUID repositoryId2 = UUID.fromString(repositoryIdString);
            return repositoryId2;
        }
        try {
            repositoryId = UUID.fromString(repositoryName);
        }
        catch (IllegalArgumentException x) {
            return null;
        }
        String localRootString = this.repoRegistryProperties.getProperty(this.getPropertyKeyForID(repositoryId));
        if (localRootString == null) {
            return null;
        }
        return repositoryId;
    }

    @Override
    public UUID getRepositoryIdOrFail(String repositoryName) {
        UUID repositoryId = this.getRepositoryId(repositoryName);
        if (repositoryId == null) {
            throw new IllegalArgumentException("Unknown repositoryName (neither a known ID nor a known alias): " + repositoryName);
        }
        return repositoryId;
    }

    @Override
    public URL getLocalRootURLForRepositoryNameOrFail(String repositoryName) {
        try {
            return this.getLocalRootForRepositoryNameOrFail(repositoryName).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized URL getLocalRootURLForRepositoryName(String repositoryName) {
        File localRoot = this.getLocalRootForRepositoryName(repositoryName);
        if (localRoot == null) {
            return null;
        }
        try {
            return localRoot.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public File getLocalRootForRepositoryNameOrFail(String repositoryName) {
        File localRoot = this.getLocalRootForRepositoryName(repositoryName);
        if (localRoot == null) {
            throw new IllegalArgumentException("Unknown repositoryName (neither a known repositoryAlias, nor a known repositoryId): " + repositoryName);
        }
        return localRoot;
    }

    @Override
    public synchronized File getLocalRootForRepositoryName(String repositoryName) {
        AssertUtil.assertNotNull("repositoryName", repositoryName);
        UUID repositoryId = this.getRepositoryId(repositoryName);
        if (repositoryId == null) {
            return null;
        }
        return this.getLocalRoot(repositoryId);
    }

    @Override
    public synchronized File getLocalRoot(UUID repositoryId) {
        AssertUtil.assertNotNull("repositoryId", repositoryId);
        this.loadRepoRegistryIfNeeded();
        String localRootString = this.repoRegistryProperties.getProperty(this.getPropertyKeyForID(repositoryId));
        if (localRootString == null) {
            return null;
        }
        File localRoot = OioFileFactory.createFile(localRootString);
        return localRoot;
    }

    @Override
    public File getLocalRootOrFail(UUID repositoryId) {
        File localRoot = this.getLocalRoot(repositoryId);
        if (localRoot == null) {
            throw new IllegalArgumentException("Unknown repositoryId: " + repositoryId);
        }
        return localRoot;
    }

    @Override
    public synchronized void putRepositoryAlias(String repositoryAlias, UUID repositoryId) {
        AssertUtil.assertNotNull("repositoryAlias", repositoryAlias);
        AssertUtil.assertNotNull("repositoryId", repositoryId);
        if (repositoryAlias.isEmpty()) {
            throw new IllegalArgumentException("repositoryAlias must not be empty!");
        }
        if ("ALL".equals(repositoryAlias)) {
            throw new IllegalArgumentException("repositoryAlias cannot be named 'ALL'! This is a reserved key word.");
        }
        if (repositoryAlias.startsWith("_")) {
            throw new IllegalArgumentException("repositoryAlias must not start with '_': " + repositoryAlias);
        }
        if (repositoryAlias.indexOf(47) >= 0) {
            throw new IllegalArgumentException("repositoryAlias must not contain a '/': " + repositoryAlias);
        }
        boolean modified = false;
        try (LockFile lockFile = this.acquireLockFile();){
            this.loadRepoRegistryIfNeeded();
            this.getLocalRootOrFail(repositoryId);
            String propertyKey = this.getPropertyKeyForAlias(repositoryAlias);
            String oldRepositoryIdString = this.repoRegistryProperties.getProperty(propertyKey);
            String repositoryIdString = repositoryId.toString();
            if (!repositoryIdString.equals(oldRepositoryIdString)) {
                modified = true;
                this.setProperty(propertyKey, repositoryIdString);
            }
            this.storeRepoRegistryIfDirty();
        }
        if (modified) {
            this.fireRepositoryAliasesChanged();
        }
    }

    @Override
    public synchronized Collection<String> getRepositoryAliases() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Collection<UUID> repositoryIds = this.getRepositoryIds();
        for (UUID repositoryId : repositoryIds) {
            Collection<String> repositoryAliases = this.getRepositoryAliasesOrFail(repositoryId.toString());
            result.addAll(repositoryAliases);
        }
        return result;
    }

    @Override
    public synchronized void removeRepositoryAlias(String repositoryAlias) {
        AssertUtil.assertNotNull("repositoryAlias", repositoryAlias);
        boolean modified = false;
        try (LockFile lockFile = this.acquireLockFile();){
            this.loadRepoRegistryIfNeeded();
            String propertyKey = this.getPropertyKeyForAlias(repositoryAlias);
            String repositoryIdString = this.repoRegistryProperties.getProperty(propertyKey);
            if (repositoryIdString != null) {
                modified = true;
                this.removeProperty(propertyKey);
            }
            this.storeRepoRegistryIfDirty();
        }
        if (modified) {
            this.fireRepositoryAliasesChanged();
        }
    }

    @Override
    public synchronized void putRepository(UUID repositoryId, File localRoot) {
        AssertUtil.assertNotNull("repositoryId", repositoryId);
        AssertUtil.assertNotNull("localRoot", localRoot);
        if (!localRoot.isAbsolute()) {
            throw new IllegalArgumentException("localRoot is not absolute.");
        }
        boolean modified = false;
        try (LockFile lockFile = this.acquireLockFile();){
            this.loadRepoRegistryIfNeeded();
            String propertyKey = this.getPropertyKeyForID(repositoryId);
            String oldLocalRootPath = this.repoRegistryProperties.getProperty(propertyKey);
            String localRootPath = localRoot.getPath();
            if (!localRootPath.equals(oldLocalRootPath)) {
                modified = true;
                this.setProperty(propertyKey, localRootPath);
            }
            this.storeRepoRegistryIfDirty();
        }
        if (modified) {
            this.fireRepositoryIdsChanged();
        }
    }

    protected Date getPropertyAsDate(String key) {
        String value = this.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return new DateTime(value).toDate();
    }

    private void setProperty(String key, Date value) {
        this.setProperty(key, new DateTime(AssertUtil.assertNotNull("value", value)).toString());
    }

    private String getProperty(String key) {
        return this.repoRegistryProperties.getProperty(AssertUtil.assertNotNull("key", key));
    }

    private void setProperty(String key, String value) {
        Object oldValue = this.repoRegistryProperties.setProperty(AssertUtil.assertNotNull("key", key), AssertUtil.assertNotNull("value", value));
        if (!Util.equal(oldValue, value)) {
            this.repoRegistryPropertiesDirty = true;
        }
    }

    private void removeProperty(String key) {
        if (this.repoRegistryProperties.remove(AssertUtil.assertNotNull("key", key)) != null) {
            this.repoRegistryPropertiesDirty = true;
        }
    }

    @Override
    public synchronized Collection<String> getRepositoryAliasesOrFail(String repositoryName) throws IllegalArgumentException {
        return this.getRepositoryAliases(repositoryName, true);
    }

    @Override
    public synchronized Collection<String> getRepositoryAliases(String repositoryName) {
        return this.getRepositoryAliases(repositoryName, false);
    }

    private Collection<String> getRepositoryAliases(String repositoryName, boolean fail) throws IllegalArgumentException {
        try (LockFile lockFile = this.acquireLockFile();){
            UUID repositoryId;
            UUID uUID = repositoryId = fail ? this.getRepositoryIdOrFail(repositoryName) : this.getRepositoryId(repositoryName);
            if (repositoryId == null) {
                Collection<String> collection = null;
                return collection;
            }
            ArrayList<String> result = new ArrayList<String>();
            for (Map.Entry<Object, Object> me : this.repoRegistryProperties.entrySet()) {
                String value;
                UUID mappedRepositoryId;
                String key = String.valueOf(me.getKey());
                if (!key.startsWith(PROP_KEY_PREFIX_REPOSITORY_ALIAS) || !(mappedRepositoryId = UUID.fromString(value = String.valueOf(me.getValue()))).equals(repositoryId)) continue;
                result.add(key.substring(PROP_KEY_PREFIX_REPOSITORY_ALIAS.length()));
            }
            Collections.sort(result);
            List list = Collections.unmodifiableList(result);
            return list;
        }
    }

    private String getPropertyKeyForAlias(String repositoryAlias) {
        return PROP_KEY_PREFIX_REPOSITORY_ALIAS + AssertUtil.assertNotNull("repositoryAlias", repositoryAlias);
    }

    private String getPropertyKeyForID(UUID repositoryId) {
        return PROP_KEY_PREFIX_REPOSITORY_ID + AssertUtil.assertNotNull("repositoryId", repositoryId).toString();
    }

    private void loadRepoRegistryIfNeeded() {
        boolean modified = false;
        try (LockFile lockFile = this.acquireLockFile();){
            if (this.repoRegistryProperties == null || this.repoRegistryFileLastModified != this.getRegistryFile().lastModified()) {
                this.loadRepoRegistry();
                modified = true;
            }
            if (this.evictDeadEntriesPeriodically()) {
                modified = true;
            }
        }
        if (modified) {
            this.fireRepositoryIdsChanged();
            this.fireRepositoryAliasesChanged();
        }
    }

    private void fireRepositoryIdsChanged() {
        this.firePropertyChange(LocalRepoRegistry.PropertyEnum.repositoryIds, null, new LazyUnmodifiableList<UUID>(){

            @Override
            protected Collection<UUID> loadElements() {
                return LocalRepoRegistryImpl.this.getRepositoryIds();
            }
        });
    }

    private void fireRepositoryAliasesChanged() {
        this.firePropertyChange(LocalRepoRegistry.PropertyEnum.repositoryAliases, null, new LazyUnmodifiableList<String>(){

            @Override
            protected Collection<String> loadElements() {
                return LocalRepoRegistryImpl.this.getRepositoryAliases();
            }
        });
    }

    private LockFile acquireLockFile() {
        return LockFileFactory.getInstance().acquire(this.getRegistryFile(), 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRepoRegistry() {
        try {
            File registryFile = this.getRegistryFile();
            if (registryFile.exists() && registryFile.length() > 0L) {
                Properties properties = new Properties();
                try (LockFile lockFile = this.acquireLockFile();
                     InputStream in = lockFile.createInputStream();){
                    properties.load(in);
                }
                this.repoRegistryProperties = properties;
            } else {
                this.repoRegistryProperties = new Properties();
            }
            this.repoRegistryFileLastModified = registryFile.lastModified();
            this.repoRegistryPropertiesDirty = false;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void storeRepoRegistryIfDirty() {
        if (this.repoRegistryPropertiesDirty) {
            this.storeRepoRegistry();
            this.repoRegistryPropertiesDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeRepoRegistry() {
        if (this.repoRegistryProperties == null) {
            throw new IllegalStateException("repoRegistryProperties not loaded, yet!");
        }
        try {
            File registryFile = this.getRegistryFile();
            try (LockFile lockFile = this.acquireLockFile();
                 OutputStream out = lockFile.createOutputStream();){
                this.repoRegistryProperties.store(out, null);
            }
            this.repoRegistryFileLastModified = registryFile.lastModified();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean evictDeadEntriesPeriodically() {
        long millisAfterLast;
        Long period = ConfigImpl.getInstance().getPropertyAsLong("repoRegistry.evictDeadEntriesPeriod", 86400000L);
        this.removeProperty(PROP_EVICT_DEAD_ENTRIES_PERIOD);
        Date last = this.getPropertyAsDate(PROP_EVICT_DEAD_ENTRIES_LAST_TIMESTAMP);
        if (last != null && (millisAfterLast = System.currentTimeMillis() - last.getTime()) >= 0L && millisAfterLast <= period) {
            return false;
        }
        boolean modified = this.evictDeadEntries();
        this.setProperty(PROP_EVICT_DEAD_ENTRIES_LAST_TIMESTAMP, new Date());
        return modified;
    }

    private boolean evictDeadEntries() {
        boolean modified = false;
        for (Map.Entry<Object, Object> me : new ArrayList<Map.Entry<Object, Object>>(this.repoRegistryProperties.entrySet())) {
            Properties repositoryProperties;
            UUID repositoryIdFromRegistry;
            String key = String.valueOf(me.getKey());
            String value = String.valueOf(me.getValue());
            if (key.startsWith(PROP_KEY_PREFIX_REPOSITORY_ALIAS)) {
                repositoryIdFromRegistry = UUID.fromString(value);
            } else {
                if (!key.startsWith(PROP_KEY_PREFIX_REPOSITORY_ID)) continue;
                repositoryIdFromRegistry = UUID.fromString(key.substring(PROP_KEY_PREFIX_REPOSITORY_ID.length()));
            }
            String localRootString = this.repoRegistryProperties.getProperty(this.getPropertyKeyForID(repositoryIdFromRegistry));
            if (localRootString == null) {
                modified = true;
                this.evictDeadEntry(key);
                continue;
            }
            File localRoot = OioFileFactory.createFile(localRootString);
            if (!localRoot.isDirectory()) {
                modified = true;
                this.evictDeadEntry(key);
                continue;
            }
            File repoMetaDir = OioFileFactory.createFile(localRoot, LocalRepoManager.META_DIR_NAME);
            if (!repoMetaDir.isDirectory()) {
                modified = true;
                this.evictDeadEntry(key);
                continue;
            }
            File repositoryPropertiesFile = OioFileFactory.createFile(repoMetaDir, LocalRepoManager.REPOSITORY_PROPERTIES_FILE_NAME);
            if (!repositoryPropertiesFile.exists()) {
                logger.warn("evictDeadEntries: File does not exist (repo corrupt?!): {}", (Object)repositoryPropertiesFile);
                continue;
            }
            try {
                repositoryProperties = PropertiesUtil.load(repositoryPropertiesFile);
            }
            catch (IOException e) {
                logger.warn("evictDeadEntries: Could not read file (repo corrupt?!): {}", (Object)repositoryPropertiesFile);
                logger.warn("evictDeadEntries: " + e, (Throwable)e);
                continue;
            }
            String repositoryIdFromRepo = repositoryProperties.getProperty("repository.id");
            if (repositoryIdFromRepo == null) {
                logger.warn("evictDeadEntries: repositoryProperties '{}' do not contain key='{}'!", (Object)repositoryPropertiesFile, (Object)"repository.id");
                continue;
            }
            if (repositoryIdFromRegistry.toString().equals(repositoryIdFromRepo)) continue;
            modified = true;
            this.evictDeadEntry(key);
        }
        return modified;
    }

    private void evictDeadEntry(String key) {
        this.repoRegistryPropertiesDirty = true;
        Object value = this.repoRegistryProperties.remove(key);
        logger.info("evictDeadEntry: key='{}' value='{}'", (Object)key, value);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(LocalRepoRegistry.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(LocalRepoRegistry.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    protected void firePropertyChange(LocalRepoRegistry.Property property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }

    private static class LocalRepoRegistryHolder {
        public static final LocalRepoRegistry INSTANCE = new LocalRepoRegistryImpl();

        private LocalRepoRegistryHolder() {
        }
    }
}

