/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.crypto;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.KeyParameter;
import org.subshare.core.crypto.CipherTransformation;
import org.subshare.core.crypto.EncrypterOutputStream;
import org.subshare.core.crypto.IvFactory;
import org.subshare.core.crypto.KeyParameterFactory;
import org.subshare.core.dto.CryptoKeyType;

public class AsymCombiEncrypterOutputStream
extends FilterOutputStream {
    public static final int MAGIC_BYTE = 195;
    private final CipherTransformation asymmetricCipherTransformation;
    private final AsymmetricKeyParameter publicKey;
    private final KeyParameter symmetricKey;
    private final EncrypterOutputStream symOut;

    public AsymCombiEncrypterOutputStream(OutputStream out, CipherTransformation asymmetricCipherTransformation, AsymmetricKeyParameter publicKey, CipherTransformation symmetricCipherTransformation, KeyParameterFactory keyParameterFactory) throws IOException {
        this(out, asymmetricCipherTransformation, publicKey, symmetricCipherTransformation, keyParameterFactory, null);
    }

    public AsymCombiEncrypterOutputStream(OutputStream out, CipherTransformation asymmetricCipherTransformation, AsymmetricKeyParameter publicKey, CipherTransformation symmetricCipherTransformation, KeyParameterFactory keyParameterFactory, IvFactory ivFactory) throws IOException {
        super((OutputStream)AssertUtil.assertNotNull((String)"out", (Object)out));
        this.asymmetricCipherTransformation = (CipherTransformation)((Object)AssertUtil.assertNotNull((String)"asymmetricCipherTransformation", (Object)((Object)asymmetricCipherTransformation)));
        if (CryptoKeyType.asymmetric != asymmetricCipherTransformation.getType()) {
            throw new IllegalArgumentException("asymmetric != asymmetricCipherTransformation.type");
        }
        this.publicKey = (AsymmetricKeyParameter)AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
        AssertUtil.assertNotNull((String)"symmetricCipherTransformation", (Object)((Object)symmetricCipherTransformation));
        if (CryptoKeyType.symmetric != symmetricCipherTransformation.getType()) {
            throw new IllegalArgumentException("symmetric != symmetricCipherTransformation.type");
        }
        ((KeyParameterFactory)AssertUtil.assertNotNull((String)"keyParameterFactory", (Object)keyParameterFactory)).setCipherTransformation(symmetricCipherTransformation);
        this.symmetricKey = keyParameterFactory.createKeyParameter();
        keyParameterFactory.setCipherTransformation(null);
        this.writeHeader();
        this.symOut = new EncrypterOutputStream(out, symmetricCipherTransformation, (CipherParameters)this.symmetricKey, ivFactory);
    }

    private void writeHeader() throws IOException {
        this.out.write(195);
        this.out.write(1);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        asymOut.setCloseUnderlyingStream(false);
        try (EncrypterOutputStream asymOut = new EncrypterOutputStream(bout, this.asymmetricCipherTransformation, (CipherParameters)this.publicKey, null);){
            asymOut.write(this.symmetricKey.getKey());
        }
        byte[] encryptedSymmetricKey = bout.toByteArray();
        if (encryptedSymmetricKey.length > 65535) {
            throw new IllegalStateException("encryptedSymmetricKey.length > 65535");
        }
        this.out.write(encryptedSymmetricKey.length);
        this.out.write(encryptedSymmetricKey.length >>> 8);
        this.out.write(encryptedSymmetricKey);
    }

    @Override
    public void write(int b) throws IOException {
        this.symOut.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.symOut.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.symOut.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.symOut.flush();
    }

    @Override
    public void close() throws IOException {
        this.symOut.close();
    }
}

