/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.transport.local;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.pgp.transport.AbstractPgpTransport;

public class LocalPgpTransport
extends AbstractPgpTransport {
    private final Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();

    @Override
    public long getLocalRevision() {
        return this.pgp.getLocalRevision();
    }

    @Override
    public Set<PgpKeyId> getMasterKeyIds() {
        Collection<PgpKey> masterKeys = this.pgp.getMasterKeys();
        HashSet<PgpKeyId> pgpKeyIds = new HashSet<PgpKeyId>(masterKeys.size());
        for (PgpKey pgpKey : masterKeys) {
            pgpKeyIds.add(pgpKey.getPgpKeyId());
        }
        return pgpKeyIds;
    }

    @Override
    public void exportPublicKeys(Set<PgpKeyId> pgpKeyIds, long changedAfterLocalRevision, OutputStream out) {
        HashSet<PgpKey> masterKeys = new HashSet<PgpKey>(pgpKeyIds.size());
        for (PgpKeyId pgpKeyId : pgpKeyIds) {
            long localRevision;
            PgpKey masterKey = this.pgp.getPgpKey(pgpKeyId);
            if (masterKey == null || (localRevision = this.pgp.getLocalRevision(masterKey)) <= changedAfterLocalRevision) continue;
            masterKeys.add(masterKey);
        }
        this.pgp.exportPublicKeys(masterKeys, out);
    }

    @Override
    public void importKeys(InputStream in) {
        this.pgp.importKeys(in);
    }
}

