/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactory;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactoryRegistry;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import co.codewizards.cloudstore.rest.server.auth.Auth;
import co.codewizards.cloudstore.rest.server.auth.NotAuthorizedException;
import co.codewizards.cloudstore.rest.server.auth.TransientRepoPasswordManager;
import co.codewizards.cloudstore.rest.server.ldap.LdapClientProvider;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceWithRepoToRepoAuth {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServiceWithRepoToRepoAuth.class);
    @Context
    protected HttpServletRequest request;
    @PathParam(value="repositoryName")
    protected String repositoryName;
    private Auth auth;

    protected Auth getAuth() throws WebApplicationException {
        block20: {
            CharArrayReader car;
            CharArrayWriter caw;
            char[] password;
            StringBuilder userNameSB;
            byte[] basicAuthDecodedBA;
            block19: {
                if (this.auth != null) break block20;
                String authorizationHeader = this.request.getHeader("Authorization");
                if (authorizationHeader == null || authorizationHeader.isEmpty()) {
                    logger.debug("getAuth: There is no 'Authorization' header. Replying with a Status.UNAUTHORIZED response asking for 'Basic' authentication.");
                    throw this.newUnauthorizedException();
                }
                logger.debug("getAuth: 'Authorization' header: {}", (Object)authorizationHeader);
                if (!authorizationHeader.startsWith("Basic")) {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type("application/xml").entity((Object)new Error("Only 'Basic' authentication is supported!")).build());
                }
                String basicAuthEncoded = authorizationHeader.substring("Basic".length()).trim();
                basicAuthDecodedBA = this.getBasicAuthEncodedBA(basicAuthEncoded);
                userNameSB = new StringBuilder();
                password = null;
                ByteArrayInputStream in = new ByteArrayInputStream(basicAuthDecodedBA);
                caw = new CharArrayWriter(basicAuthDecodedBA.length + 1);
                car = null;
                try {
                    int passwordSize;
                    int charsRead;
                    InputStreamReader r = new InputStreamReader((InputStream)in, "UTF-8");
                    int charsReadTotal = 0;
                    do {
                        char[] c = new char[10];
                        charsRead = r.read(c);
                        caw.write(c);
                        if (charsRead <= 0) continue;
                        charsReadTotal += charsRead;
                    } while (charsRead >= 0);
                    charsRead = 0;
                    car = new CharArrayReader(caw.toCharArray());
                    int charsReadTotalCheck = 0;
                    while (charsRead >= 0 && charsRead < charsReadTotal) {
                        char[] cbuf = new char[1];
                        charsRead = car.read(cbuf);
                        if (charsRead > 0) {
                            charsReadTotalCheck += charsRead;
                        }
                        if (cbuf[0] == ':') break;
                        userNameSB.append(cbuf[0]);
                    }
                    if (charsRead < 0 || charsRead >= charsReadTotal || (passwordSize = car.read(password = new char[charsReadTotal - charsReadTotalCheck])) + charsReadTotalCheck == charsReadTotal) break block19;
                    throw new IllegalStateException("passwordSize and charsRead must match charsReadTotal! passwordSize=" + passwordSize + ", charsRead=" + charsRead + ", charsReadTotal=" + charsReadTotal);
                }
                catch (Exception e) {
                    try {
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/xml").entity((Object)new Error((Throwable)e)).build());
                    }
                    catch (Throwable throwable) {
                        Arrays.fill(basicAuthDecodedBA, (byte)0);
                        char[] zeroArray = new char[]{'\u0000'};
                        if (caw != null) {
                            int oldCawSize = caw.size();
                            caw.reset();
                            try {
                                if (car != null) {
                                    car.reset();
                                }
                                for (int i = 0; i < oldCawSize; ++i) {
                                    caw.write(zeroArray);
                                }
                                car = new CharArrayReader(caw.toCharArray());
                                car.close();
                                caw.reset();
                                caw = null;
                            }
                            catch (IOException e2) {
                                throw new RuntimeException(e2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            Arrays.fill(basicAuthDecodedBA, (byte)0);
            char[] zeroArray = new char[]{'\u0000'};
            if (caw != null) {
                int oldCawSize = caw.size();
                caw.reset();
                try {
                    if (car != null) {
                        car.reset();
                    }
                    for (int i = 0; i < oldCawSize; ++i) {
                        caw.write(zeroArray);
                    }
                    car = new CharArrayReader(caw.toCharArray());
                    car.close();
                    caw.reset();
                    caw = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            Auth auth = new Auth();
            auth.setUserName(userNameSB.toString());
            auth.setPassword(password);
            this.auth = auth;
        }
        return this.auth;
    }

    private byte[] getBasicAuthEncodedBA(String basicAuthEncoded) {
        byte[] basicAuthDecodedBA;
        try {
            basicAuthDecodedBA = Base64.decode((byte[])basicAuthEncoded.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
        return basicAuthDecodedBA;
    }

    protected String authenticateAndReturnUserName() throws WebApplicationException {
        UUID serverRepositoryId = LocalRepoRegistryImpl.getInstance().getRepositoryId(this.repositoryName);
        if (serverRepositoryId == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/xml").entity((Object)new Error(String.format("HTTP 404: repositoryName='%s' is neither an alias nor an ID of a known repository!", this.repositoryName))).build());
        }
        Auth auth = this.getAuth();
        UUID clientRepositoryId = this.getClientRepositoryIdFromUserName(auth.getUserName());
        if (clientRepositoryId != null) {
            if (TransientRepoPasswordManager.getInstance().isPasswordValid(serverRepositoryId, clientRepositoryId, auth.getPassword())) {
                return auth.getUserName();
            }
            throw this.newUnauthorizedException();
        }
        return LdapClientProvider.getInstance().getClient().authenticate(auth);
    }

    protected UUID getClientRepositoryIdFromUserName(String userName) {
        if (((String)AssertUtil.assertNotNull((String)"userName", (Object)userName)).startsWith("_repositoryId/")) {
            String repositoryIdString = userName.substring("_repositoryId/".length());
            UUID clientRepositoryId = UUID.fromString(repositoryIdString);
            return clientRepositoryId;
        }
        return null;
    }

    protected UUID getClientRepositoryIdFromUserNameOrFail(String userName) {
        UUID clientRepositoryId = this.getClientRepositoryIdFromUserName(userName);
        if (clientRepositoryId == null) {
            throw new IllegalArgumentException(String.format("userName='%s' is not a repository!", userName));
        }
        return clientRepositoryId;
    }

    private WebApplicationException newUnauthorizedException() {
        return new NotAuthorizedException();
    }

    protected RepoTransport authenticateAndCreateLocalRepoTransport() {
        String userName = this.authenticateAndReturnUserName();
        UUID clientRepositoryId = this.getClientRepositoryIdFromUserNameOrFail(userName);
        URL localRootURL = this.getLocalRootURL(clientRepositoryId);
        RepoTransportFactory repoTransportFactory = RepoTransportFactoryRegistry.getInstance().getRepoTransportFactoryOrFail(localRootURL);
        RepoTransport repoTransport = repoTransportFactory.createRepoTransport(localRootURL, clientRepositoryId);
        return repoTransport;
    }

    protected RepoTransport authenticateWithLdap() {
        URL localRootURL;
        this.authenticateAndReturnUserName();
        File localRoot = LocalRepoRegistryImpl.getInstance().getLocalRootForRepositoryNameOrFail(this.repositoryName);
        try {
            localRootURL = localRoot.toURI().toURL();
            localRootURL = this.appendEmptyPathPrefix(localRootURL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        RepoTransportFactory repoTransportFactory = RepoTransportFactoryRegistry.getInstance().getRepoTransportFactoryOrFail(localRootURL);
        return repoTransportFactory.createRepoTransport(localRootURL, null);
    }

    protected URL authenticateAndGetLocalRootURL() {
        String userName = this.authenticateAndReturnUserName();
        UUID clientRepositoryId = this.getClientRepositoryIdFromUserNameOrFail(userName);
        return this.getLocalRootURL(clientRepositoryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getLocalRootURL(UUID clientRepositoryId) {
        AssertUtil.assertNotNull((String)"repositoryName", (Object)this.repositoryName);
        File localRoot = LocalRepoRegistryImpl.getInstance().getLocalRootForRepositoryNameOrFail(this.repositoryName);
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);){
            URL localRootURL;
            String localPathPrefix = localRepoManager.getLocalPathPrefixOrFail(clientRepositoryId);
            try {
                localRootURL = localRoot.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            URL uRL = localRootURL = UrlUtil.appendNonEncodedPath((URL)localRootURL, (String)localPathPrefix);
            return uRL;
        }
    }

    private URL appendEmptyPathPrefix(URL localRoot) {
        return UrlUtil.appendNonEncodedPath((URL)localRoot, (String)"");
    }
}

