/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.server.service.AbstractServiceWithRepoToRepoAuth;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="_move/{repositoryName}")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class MoveService
extends AbstractServiceWithRepoToRepoAuth {
    private static final Logger logger = LoggerFactory.getLogger(MoveService.class);

    public MoveService() {
        logger.debug("<init>: created new instance");
    }

    @POST
    public void move(@QueryParam(value="to") String toPath) {
        this.move("", toPath);
    }

    @POST
    @Path(value="{path:.*}")
    public void move(@PathParam(value="path") String path, @QueryParam(value="to") String toPath) {
        AssertUtil.assertNotNull((String)"path", (Object)path);
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            path = repoTransport.unprefixPath(path);
            repoTransport.move(path, toPath);
        }
    }
}

