/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.dto;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import org.subshare.core.dto.HistoCryptoRepoFileDto;
import org.subshare.core.sign.Signature;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoKeyDao;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.HistoCryptoRepoFileDao;
import org.subshare.local.persistence.HistoFrame;
import org.subshare.local.persistence.HistoFrameDao;

public class HistoCryptoRepoFileDtoConverter {
    private final LocalRepoTransaction transaction;

    public static HistoCryptoRepoFileDtoConverter create(LocalRepoTransaction transaction) {
        return (HistoCryptoRepoFileDtoConverter)ObjectFactoryUtil.createObject(HistoCryptoRepoFileDtoConverter.class, (Object[])new Object[]{transaction});
    }

    protected HistoCryptoRepoFileDtoConverter(LocalRepoTransaction transaction) {
        this.transaction = (LocalRepoTransaction)AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
    }

    public HistoCryptoRepoFileDto toHistoCryptoRepoFileDto(HistoCryptoRepoFile histoCryptoRepoFile) {
        AssertUtil.assertNotNull((String)"cryptoRepoFileOnServer", (Object)((Object)histoCryptoRepoFile));
        HistoCryptoRepoFileDto result = new HistoCryptoRepoFileDto();
        result.setHistoCryptoRepoFileId(histoCryptoRepoFile.getHistoCryptoRepoFileId());
        result.setHistoFrameId(histoCryptoRepoFile.getHistoFrame().getHistoFrameId());
        result.setCryptoRepoFileId(histoCryptoRepoFile.getCryptoRepoFile().getCryptoRepoFileId());
        HistoCryptoRepoFile previousHistoCryptoRepoFile = histoCryptoRepoFile.getPreviousHistoCryptoRepoFile();
        result.setPreviousHistoCryptoRepoFileId(previousHistoCryptoRepoFile == null ? null : previousHistoCryptoRepoFile.getHistoCryptoRepoFileId());
        CryptoKey cryptoKey = (CryptoKey)((Object)AssertUtil.assertNotNull((String)"cryptoRepoFileOnServer.cryptoKey", (Object)((Object)histoCryptoRepoFile.getCryptoKey())));
        result.setCryptoKeyId(cryptoKey.getCryptoKeyId());
        byte[] repoFileDtoData = (byte[])AssertUtil.assertNotNull((String)"cryptoRepoFileOnServer.repoFileDtoData", (Object)histoCryptoRepoFile.getRepoFileDtoData());
        result.setRepoFileDtoData(repoFileDtoData);
        result.setDeleted(histoCryptoRepoFile.getDeleted());
        result.setDeletedByIgnoreRule(histoCryptoRepoFile.isDeletedByIgnoreRule());
        result.setSignature((Signature)AssertUtil.assertNotNull((String)"cryptoRepoFileOnServer.signature", (Object)histoCryptoRepoFile.getSignature()));
        return result;
    }

    public HistoCryptoRepoFile putHistoCryptoRepoFile(HistoCryptoRepoFileDto histoCryptoRepoFileDto) {
        AssertUtil.assertNotNull((String)"cryptoRepoFileOnServerDto", (Object)histoCryptoRepoFileDto);
        HistoFrameDao histoFrameDao = (HistoFrameDao)((Object)this.transaction.getDao(HistoFrameDao.class));
        HistoCryptoRepoFileDao histoCryptoRepoFileDao = (HistoCryptoRepoFileDao)((Object)this.transaction.getDao(HistoCryptoRepoFileDao.class));
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)this.transaction.getDao(CryptoRepoFileDao.class));
        CryptoKeyDao cryptoKeyDao = (CryptoKeyDao)((Object)this.transaction.getDao(CryptoKeyDao.class));
        HistoCryptoRepoFile histoCryptoRepoFile = histoCryptoRepoFileDao.getHistoCryptoRepoFile(histoCryptoRepoFileDto.getHistoCryptoRepoFileId());
        if (histoCryptoRepoFile == null) {
            histoCryptoRepoFile = new HistoCryptoRepoFile(histoCryptoRepoFileDto.getHistoCryptoRepoFileId());
        }
        CryptoRepoFile cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFileOrFail(histoCryptoRepoFileDto.getCryptoRepoFileId());
        histoCryptoRepoFile.setCryptoRepoFile(cryptoRepoFile);
        if (histoCryptoRepoFileDto.getPreviousHistoCryptoRepoFileId() == null) {
            histoCryptoRepoFile.setPreviousHistoCryptoRepoFile(null);
        } else {
            HistoCryptoRepoFile previous = histoCryptoRepoFileDao.getHistoCryptoRepoFileOrFail(histoCryptoRepoFileDto.getPreviousHistoCryptoRepoFileId());
            histoCryptoRepoFile.setPreviousHistoCryptoRepoFile(previous);
        }
        Uid histoFrameId = (Uid)AssertUtil.assertNotNull((String)"histoCryptoRepoFileDto.histoFrameId", (Object)histoCryptoRepoFileDto.getHistoFrameId());
        HistoFrame histoFrame = histoFrameDao.getHistoFrameOrFail(histoFrameId);
        histoCryptoRepoFile.setHistoFrame(histoFrame);
        CryptoKey cryptoKey = cryptoKeyDao.getCryptoKeyOrFail(histoCryptoRepoFileDto.getCryptoKeyId());
        histoCryptoRepoFile.setCryptoKey(cryptoKey);
        histoCryptoRepoFile.setRepoFileDtoData(histoCryptoRepoFileDto.getRepoFileDtoData());
        histoCryptoRepoFile.setDeleted(histoCryptoRepoFileDto.getDeleted());
        histoCryptoRepoFile.setDeletedByIgnoreRule(histoCryptoRepoFileDto.isDeletedByIgnoreRule());
        histoCryptoRepoFile.setSignature(histoCryptoRepoFileDto.getSignature());
        histoCryptoRepoFile = (HistoCryptoRepoFile)histoCryptoRepoFileDao.makePersistent(histoCryptoRepoFile);
        this.transaction.flush();
        return histoCryptoRepoFile;
    }
}

