/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.crypto;

import co.codewizards.cloudstore.core.util.AssertUtil;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.KeyParameter;
import org.subshare.core.crypto.CipherTransformation;
import org.subshare.core.dto.CryptoKeyType;

class EncrypterDecrypterStreamUtil {
    static final int MAX_UNSIGNED_2_BYTE_VALUE = 65535;

    EncrypterDecrypterStreamUtil() {
    }

    static CipherParameters assertValidKey(CipherTransformation cipherTransformation, CipherParameters key) {
        AssertUtil.assertNotNull((String)"cipherTransformation", (Object)((Object)cipherTransformation));
        AssertUtil.assertNotNull((String)"key", (Object)key);
        if (key instanceof KeyParameter) {
            if (CryptoKeyType.symmetric != cipherTransformation.getType()) {
                throw new IllegalArgumentException("key is a shared secret (used for symmetric encryption), but cipherTransformation is of type: " + (Object)((Object)cipherTransformation.getType()));
            }
            if (key instanceof AsymmetricKeyParameter) {
                if (CryptoKeyType.asymmetric != cipherTransformation.getType()) {
                    throw new IllegalArgumentException("key is an asymmetric key, but cipherTransformation is of type: " + (Object)((Object)cipherTransformation.getType()));
                }
                throw new IllegalArgumentException("key must be an instanceo of KeyParameter or AsymmetricKeyParameter, but it is an instance of: " + key.getClass().getName());
            }
        }
        return key;
    }
}

