/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.rest.server.service;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.CopyModificationDao;
import co.codewizards.cloudstore.local.persistence.DeleteModificationDao;
import co.codewizards.cloudstore.local.persistence.DirectoryDao;
import co.codewizards.cloudstore.local.persistence.NormalFileDao;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryRequest;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryRequestDao;
import co.codewizards.cloudstore.ls.core.dto.RemoteRepositoryDto;
import co.codewizards.cloudstore.ls.core.dto.RemoteRepositoryRequestDto;
import co.codewizards.cloudstore.ls.core.dto.RepoInfoRequestDto;
import co.codewizards.cloudstore.ls.core.dto.RepoInfoResponseDto;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="RepoInfo")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class RepoInfoService {
    private static final Logger logger = LoggerFactory.getLogger(RepoInfoService.class);
    private LocalRepoTransaction transaction;
    private RepoInfoResponseDto repoInfoResponseDto;

    public RepoInfoService() {
        logger.debug("<init>: Instance created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public RepoInfoResponseDto run(RepoInfoRequestDto repoInfoRequestDto) {
        AssertUtil.assertNotNull((String)"repoInfoRequestDto", (Object)repoInfoRequestDto);
        this.repoInfoResponseDto = new RepoInfoResponseDto();
        File localRoot = OioFileFactory.createFile((String)((String)AssertUtil.assertNotNull((String)"", (Object)repoInfoRequestDto.getLocalRoot())));
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);
             LocalRepoTransaction transaction = localRepoManager.beginReadTransaction();){
            this.transaction = transaction;
            this.collectMainProperties();
            this.collectRemoteRepositories();
            this.collectRemoteRepositoryRequests();
            this.collectRepositoryStats();
            transaction.commit();
        }
        return this.repoInfoResponseDto;
    }

    private void collectMainProperties() {
        LocalRepoManager localRepoManager = this.transaction.getLocalRepoManager();
        this.repoInfoResponseDto.setRepositoryId(localRepoManager.getRepositoryId());
        this.repoInfoResponseDto.setLocalRoot(localRepoManager.getLocalRoot().getPath());
        this.repoInfoResponseDto.setPublicKey(localRepoManager.getPublicKey());
        Collection repositoryAliases = LocalRepoRegistryImpl.getInstance().getRepositoryAliasesOrFail(localRepoManager.getRepositoryId().toString());
        this.repoInfoResponseDto.getRepositoryAliases().addAll(repositoryAliases);
    }

    private void collectRemoteRepositories() {
        Collection remoteRepositories = ((RemoteRepositoryDao)this.transaction.getDao(RemoteRepositoryDao.class)).getObjects();
        for (RemoteRepository remoteRepository : remoteRepositories) {
            RemoteRepositoryDto remoteRepositoryDto = new RemoteRepositoryDto();
            remoteRepositoryDto.setRepositoryId(remoteRepository.getRepositoryId());
            remoteRepositoryDto.setPublicKey(remoteRepository.getPublicKey());
            if (remoteRepository.getRemoteRoot() != null) {
                remoteRepositoryDto.setRemoteRoot(remoteRepository.getRemoteRoot().toExternalForm());
            }
            this.repoInfoResponseDto.getRemoteRepositoryDtos().add(remoteRepositoryDto);
        }
    }

    private void collectRemoteRepositoryRequests() {
        Collection remoteRepositoryRequests = ((RemoteRepositoryRequestDao)this.transaction.getDao(RemoteRepositoryRequestDao.class)).getObjects();
        for (RemoteRepositoryRequest remoteRepositoryRequest : remoteRepositoryRequests) {
            RemoteRepositoryRequestDto remoteRepositoryRequestDto = new RemoteRepositoryRequestDto();
            remoteRepositoryRequestDto.setRepositoryId(remoteRepositoryRequest.getRepositoryId());
            remoteRepositoryRequestDto.setPublicKey(remoteRepositoryRequest.getPublicKey());
            remoteRepositoryRequestDto.setCreated(remoteRepositoryRequest.getCreated());
            remoteRepositoryRequestDto.setChanged(remoteRepositoryRequest.getChanged());
            this.repoInfoResponseDto.getRemoteRepositoryRequestDtos().add(remoteRepositoryRequestDto);
        }
    }

    private void collectRepositoryStats() {
        NormalFileDao normalFileDao = (NormalFileDao)this.transaction.getDao(NormalFileDao.class);
        DirectoryDao directoryDao = (DirectoryDao)this.transaction.getDao(DirectoryDao.class);
        CopyModificationDao copyModificationDao = (CopyModificationDao)this.transaction.getDao(CopyModificationDao.class);
        DeleteModificationDao deleteModificationDao = (DeleteModificationDao)this.transaction.getDao(DeleteModificationDao.class);
        this.repoInfoResponseDto.setNormalFileCount(normalFileDao.getObjectsCount());
        this.repoInfoResponseDto.setDirectoryCount(directoryDao.getObjectsCount());
        this.repoInfoResponseDto.setCopyModificationCount(copyModificationDao.getObjectsCount());
        this.repoInfoResponseDto.setDeleteModificationCount(deleteModificationDao.getObjectsCount());
    }
}

