/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.filetree;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.FileFilter;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.InvalidationListener;
import javafx.scene.control.TreeItem;
import org.subshare.gui.filetree.FileFileTreeItem;
import org.subshare.gui.filetree.FileTreeItem;
import org.subshare.gui.filetree.FileTreePane;
import org.subshare.gui.filetree.NormalFileFileTreeItem;

public class DirectoryFileTreeItem
extends FileFileTreeItem {
    private final InvalidationListener updateInvalidationListener = observable -> this.refresh();
    private int allChildrenCount = -1;
    private int filteredChildrenCount = -1;

    public DirectoryFileTreeItem(File file) {
        super(file);
        this.parentProperty().addListener((observable, oldValue, newValue) -> {
            FileTreePane newFileTreePane;
            FileTreePane oldFileTreePane = oldValue == null ? null : ((FileTreeItem)((Object)((Object)oldValue.getValue()))).getFileTreePane();
            FileTreePane fileTreePane = newFileTreePane = newValue == null ? null : ((FileTreeItem)((Object)((Object)newValue.getValue()))).getFileTreePane();
            if (oldFileTreePane != newFileTreePane) {
                if (oldFileTreePane != null) {
                    this.unhookUpdateInvalidationListener(oldFileTreePane);
                }
                if (newFileTreePane != null) {
                    this.hookUpdateInvalidationListener(newFileTreePane);
                }
            }
        });
    }

    protected void unhookUpdateInvalidationListener(FileTreePane fileTreePane) {
        fileTreePane.showHiddenFilesProperty().removeListener(this.updateInvalidationListener);
        fileTreePane.fileFilterProperty().removeListener(this.updateInvalidationListener);
    }

    protected void hookUpdateInvalidationListener(FileTreePane fileTreePane) {
        fileTreePane.showHiddenFilesProperty().addListener(this.updateInvalidationListener);
        fileTreePane.fileFilterProperty().addListener(this.updateInvalidationListener);
    }

    @Override
    protected void refresh() {
        super.refresh();
        this.refreshSize();
        this.refreshChildren();
    }

    private void refreshSize() {
        this.allChildrenCount = -1;
        this.filteredChildrenCount = -1;
        this.sizeProperty().set((Object)this._getSize());
    }

    private String _getSize() {
        int allChildrenCount = this.getAllChildrenCount();
        int filteredChildrenCount = this.getFilteredChildrenCount();
        if (filteredChildrenCount != allChildrenCount) {
            return String.format("%d (%d) items", filteredChildrenCount, allChildrenCount);
        }
        if (allChildrenCount == 1) {
            return String.format("%d item", allChildrenCount);
        }
        return String.format("%d items", allChildrenCount);
    }

    public int getAllChildrenCount() {
        if (this.allChildrenCount == -1) {
            String[] allChildren = this.getFile().list();
            this.allChildrenCount = allChildren == null ? 0 : allChildren.length;
        }
        return this.allChildrenCount;
    }

    public int getFilteredChildrenCount() {
        if (this.filteredChildrenCount == -1) {
            File[] filteredChildren;
            FileFilter combinedFileFilter = this.getCombinedFileFilter();
            this.filteredChildrenCount = combinedFileFilter == null ? this.getAllChildrenCount() : ((filteredChildren = this.getFile().listFiles(combinedFileFilter)) == null ? 0 : filteredChildren.length);
        }
        return this.filteredChildrenCount;
    }

    @Override
    public boolean isLeaf() {
        if (this.getParent() == null) {
            return false;
        }
        return this.getFilteredChildrenCount() == 0;
    }

    protected void refreshChildren() {
        if (!this.isChildrenLoaded()) {
            return;
        }
        File[] children = this.listChildFiles();
        if (children == null || children.length == 0) {
            this.getChildren().clear();
            return;
        }
        this.getFileTreePane().getTreeTableView().getSortOrder().clear();
        this.getChildren().sort((o1, o2) -> DirectoryFileTreeItem.getFileName(o1).compareTo(DirectoryFileTreeItem.getFileName(o2)));
        ListIterator treeItemIterator = this.getChildren().listIterator();
        FileFileTreeItem fileFileTreeItem = (FileFileTreeItem)(treeItemIterator.hasNext() ? (FileTreeItem)((Object)((TreeItem)treeItemIterator.next()).getValue()) : null);
        block0: for (File child : children) {
            while (true) {
                if (this.isTreeItemAfterFile(fileFileTreeItem, child)) {
                    if (fileFileTreeItem != null && treeItemIterator.hasPrevious()) {
                        treeItemIterator.previous();
                    }
                    treeItemIterator.add(this.createFileFileTreeItem(child));
                    if (fileFileTreeItem == null) continue block0;
                    FileFileTreeItem dbg = (FileFileTreeItem)((Object)treeItemIterator.previous());
                    if (dbg.getFile() != child) {
                        throw new IllegalStateException(String.format("dbg.getFile() != child :: %s != %s", dbg.getFile(), child));
                    }
                    treeItemIterator.next();
                    FileFileTreeItem dbg2 = (FileFileTreeItem)((Object)treeItemIterator.next());
                    if (fileFileTreeItem == dbg2) continue block0;
                    throw new IllegalStateException(String.format("fileFileTreeItem != dbg2 :: %s != %s", new Object[]{fileFileTreeItem, dbg2}));
                }
                if (!this.isTreeItemBeforeFile(fileFileTreeItem, child)) break;
                if (fileFileTreeItem != null) {
                    treeItemIterator.remove();
                }
                fileFileTreeItem = (FileFileTreeItem)(treeItemIterator.hasNext() ? (FileTreeItem)((Object)((TreeItem)treeItemIterator.next()).getValue()) : null);
            }
            Class<? extends FileFileTreeItem> fileFileTreeItemClass = this.getFileFileTreeItemClass(child);
            if (!child.equals(fileFileTreeItem.getFile()) || fileFileTreeItemClass != ((Object)((Object)fileFileTreeItem)).getClass()) {
                treeItemIterator.set(this.createFileFileTreeItem(child));
            }
            fileFileTreeItem = (FileFileTreeItem)(treeItemIterator.hasNext() ? (FileTreeItem)((Object)((TreeItem)treeItemIterator.next()).getValue()) : null);
        }
        if (fileFileTreeItem != null) {
            treeItemIterator.remove();
        }
        while (treeItemIterator.hasNext()) {
            treeItemIterator.next();
            treeItemIterator.remove();
        }
    }

    private static final String getFileName(TreeItem<FileTreeItem<?>> treeItem) {
        if (treeItem instanceof FileFileTreeItem) {
            return ((FileFileTreeItem)treeItem).getFile().getName();
        }
        return treeItem.toString();
    }

    private boolean isTreeItemAfterFile(FileFileTreeItem treeItem, File file) {
        AssertUtil.assertNotNull((String)"file", (Object)file);
        if (treeItem == null) {
            return true;
        }
        return treeItem.getFile().getName().compareTo(file.getName()) > 0;
    }

    private boolean isTreeItemBeforeFile(FileFileTreeItem treeItem, File file) {
        AssertUtil.assertNotNull((String)"treeItem", (Object)((Object)treeItem));
        AssertUtil.assertNotNull((String)"file", (Object)file);
        return treeItem.getFile().getName().compareTo(file.getName()) < 0;
    }

    @Override
    protected List<FileTreeItem<?>> loadChildren() {
        File[] children = this.listChildFiles();
        if (children == null) {
            return null;
        }
        ArrayList result = new ArrayList(children.length);
        for (File child : children) {
            result.add(this.createFileFileTreeItem(child));
        }
        return result;
    }

    private Class<? extends FileFileTreeItem> getFileFileTreeItemClass(File file) {
        if (file.isDirectory()) {
            return DirectoryFileTreeItem.class;
        }
        return NormalFileFileTreeItem.class;
    }

    private FileFileTreeItem createFileFileTreeItem(File file) {
        Class<? extends FileFileTreeItem> clazz = this.getFileFileTreeItemClass(file);
        return (FileFileTreeItem)((Object)ReflectionUtil.invokeConstructor(clazz, (Object[])new Object[]{file}));
    }

    private File[] listChildFiles() {
        File[] children;
        FileFilter fileFilter = this.getCombinedFileFilter();
        File[] fileArray = children = fileFilter == null ? this.getFile().listFiles((FileFilter)new HideCloudStoreMetaDirFileFilter()) : this.getFile().listFiles(fileFilter);
        if (children != null) {
            Arrays.sort(children, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        }
        return children;
    }

    private FileFilter getCombinedFileFilter() {
        FileFilter fileFilter;
        LinkedList<FileFilter> fileFilters = new LinkedList<FileFilter>();
        fileFilters.add(new HideCloudStoreMetaDirFileFilter());
        boolean showHiddenFiles = this.getFileTreePane().showHiddenFilesProperty().get();
        if (!showHiddenFiles) {
            fileFilters.add(new HideHiddenFilesFileFilter());
        }
        if ((fileFilter = (FileFilter)this.getFileTreePane().fileFilterProperty().get()) != null) {
            fileFilters.add(fileFilter);
        }
        if (fileFilters.isEmpty()) {
            return null;
        }
        if (fileFilters.size() == 1) {
            return (FileFilter)fileFilters.get(0);
        }
        return new AndFileFilter(fileFilters);
    }

    private static final class HideCloudStoreMetaDirFileFilter
    implements FileFilter {
        private HideCloudStoreMetaDirFileFilter() {
        }

        public boolean accept(File file) {
            return !LocalRepoManager.META_DIR_NAME.equals(file.getName());
        }
    }

    private static final class HideHiddenFilesFileFilter
    implements FileFilter {
        private HideHiddenFilesFileFilter() {
        }

        public boolean accept(File file) {
            return !this.isHidden(file);
        }

        protected boolean isHidden(File file) {
            return file.getName().startsWith(".");
        }
    }

    private static final class AndFileFilter
    implements FileFilter {
        private final List<FileFilter> fileFilters;

        public AndFileFilter(List<FileFilter> fileFilters) {
            this.fileFilters = (List)AssertUtil.assertNotNull((String)"fileFilters", fileFilters);
        }

        public boolean accept(File file) {
            for (FileFilter fileFilter : this.fileFilters) {
                if (fileFilter.accept(file)) continue;
                return false;
            }
            return true;
        }
    }
}

