/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.maintree;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.FileFilter;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.local.CollisionPrivateFilter;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.gui.IconSize;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.filetree.FileIconRegistry;
import org.subshare.gui.filetree.repoaware.RepoAwareFileTreePane;
import org.subshare.gui.localrepo.directory.LocalRepoDirectoryPane;
import org.subshare.gui.ls.LocalRepoManagerFactoryLs;
import org.subshare.gui.maintree.LocalRepoMainTreeItem;
import org.subshare.gui.maintree.MainTreeItem;

public class LocalRepoDirectoryMainTreeItem
extends MainTreeItem<File> {
    private boolean childrenLoaded;
    private final ObjectProperty<Image> collisionIcon = new SimpleObjectProperty((Object)this, "collisionIcon");
    private static final FileFilter directoryOnlyFileFilter = file -> file.isDirectory() && !LocalRepoManager.META_DIR_NAME.equals(file.getName());
    private static final Comparator<File> fileComparator = (o1, o2) -> o1.getName().compareTo(o2.getName());

    public LocalRepoDirectoryMainTreeItem(File file) {
        super(AssertUtil.assertNotNull((String)"file", (Object)file), (Node)new ImageView(FileIconRegistry.getInstance().getIcon(file, IconSize._16x16)));
        this.collisionIcon.addListener(observable -> this.updateGraphic());
        Platform.runLater(() -> this.updateCollisionIcon());
    }

    public LocalRepo getLocalRepo() {
        TreeItem parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("parent == null");
        }
        if (parent instanceof LocalRepoDirectoryMainTreeItem) {
            return ((LocalRepoDirectoryMainTreeItem)parent).getLocalRepo();
        }
        if (parent instanceof LocalRepoMainTreeItem) {
            return ((LocalRepoMainTreeItem)parent).getLocalRepo();
        }
        throw new IllegalStateException("parent is an instance of an unexpected type: " + parent.getClass().getName());
    }

    public File getFile() {
        return (File)this.getValueObject();
    }

    @Override
    protected String getValueString() {
        String fileName = this.getFile().getName();
        if (StringUtil.isEmpty((String)fileName)) {
            return this.getFile().getAbsolutePath();
        }
        return fileName;
    }

    public ObservableList<TreeItem<String>> getChildren() {
        ObservableList children = super.getChildren();
        if (!this.childrenLoaded) {
            this.childrenLoaded = true;
            List<MainTreeItem<File>> c = this.loadChildren();
            if (c != null) {
                children.addAll(c);
            }
        }
        return children;
    }

    private List<MainTreeItem<File>> loadChildren() {
        File file = this.getFile();
        File[] childFiles = file.listFiles(directoryOnlyFileFilter);
        if (childFiles == null) {
            return null;
        }
        Arrays.sort(childFiles, fileComparator);
        ArrayList<MainTreeItem<File>> result = new ArrayList<MainTreeItem<File>>(childFiles.length);
        for (File childFile : childFiles) {
            result.add(new LocalRepoDirectoryMainTreeItem(childFile));
        }
        return result;
    }

    public boolean isLeaf() {
        File[] childFiles = this.getFile().listFiles(directoryOnlyFileFilter);
        return childFiles == null || childFiles.length == 0;
    }

    @Override
    protected Parent createMainDetailContent() {
        return new LocalRepoDirectoryPane(this.getLocalRepo(), this.getFile());
    }

    private void updateCollisionIcon() {
        new Service<Image>(){

            protected Task<Image> createTask() {
                return new SsTask<Image>(){

                    protected Image call() throws Exception {
                        return LocalRepoDirectoryMainTreeItem.this._getCollisionIcon();
                    }

                    protected void succeeded() {
                        Image result;
                        try {
                            result = (Image)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        LocalRepoDirectoryMainTreeItem.this.collisionIcon.set((Object)result);
                    }
                };
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Image _getCollisionIcon() {
        Class<LocalRepoDirectoryMainTreeItem> clazz = LocalRepoDirectoryMainTreeItem.class;
        synchronized (LocalRepoDirectoryMainTreeItem.class) {
            LocalRepo localRepo = (LocalRepo)AssertUtil.assertNotNull((String)"localRepo", (Object)this.getLocalRepo());
            File file = (File)AssertUtil.assertNotNull((String)"file", (Object)this.getFile());
            String localPath = localRepo.getLocalPath(file);
            try (LocalRepoManager localRepoManager = this.createLocalRepoManager();){
                SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                CollisionPrivateFilter filter = new CollisionPrivateFilter();
                filter.setLocalPath(localPath);
                filter.setResolved(Boolean.valueOf(false));
                filter.setIncludeChildrenRecursively(true);
                Collection cpDtos = localRepoMetaData.getCollisionPrivateDtos(filter);
                if (cpDtos.isEmpty()) return null;
                filter.setIncludeChildrenRecursively(false);
                cpDtos = localRepoMetaData.getCollisionPrivateDtos(filter);
                if (cpDtos.isEmpty()) {
                    Image image = RepoAwareFileTreePane.getCollisionUnresolvedInChildIcon();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return image;
                }
                Image image = RepoAwareFileTreePane.getCollisionUnresolvedIcon();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return image;
            }
        }
    }

    private void updateGraphic() {
        ImageView fileIconImageView = new ImageView(FileIconRegistry.getInstance().getIcon(this.getFile(), IconSize._16x16));
        Image collisionIcon = (Image)this.collisionIcon.get();
        if (collisionIcon == null) {
            this.setGraphic((Node)fileIconImageView);
        } else {
            HBox box = new HBox();
            box.getChildren().add((Object)fileIconImageView);
            box.getChildren().add((Object)new ImageView(collisionIcon));
            this.setGraphic((Node)box);
        }
    }

    private LocalRepoManager createLocalRepoManager() {
        LocalRepo localRepo = (LocalRepo)AssertUtil.assertNotNull((String)"localRepo", (Object)this.getLocalRepo());
        return LocalRepoManagerFactoryLs.getLocalRepoManagerFactory().createLocalRepoManagerForExistingRepository(localRepo.getLocalRoot());
    }
}

