/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.maintree;

import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.ServerRepoRegistry;
import org.subshare.core.server.Server;
import org.subshare.gui.ls.ServerRepoRegistryLs;
import org.subshare.gui.maintree.MainTreeItem;
import org.subshare.gui.maintree.ServerListMainTreeItem;
import org.subshare.gui.maintree.ServerRepoMainTreeItem;
import org.subshare.gui.server.ServerPane;

public class ServerMainTreeItem
extends MainTreeItem<Server> {
    private static final Image icon = new Image(ServerListMainTreeItem.class.getResource("server_16x16.png").toExternalForm());
    private ServerRepoRegistry serverRepoRegistry;
    private boolean childrenLoaded;
    private PropertyChangeListener serverReposPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ArrayList serverRepos = new ArrayList((List)evt.getNewValue());
            Server server = ServerMainTreeItem.this.getServer();
            Iterator it = serverRepos.iterator();
            while (it.hasNext()) {
                if (server.getServerId().equals((Object)((ServerRepo)it.next()).getServerId())) continue;
                it.remove();
            }
            Platform.runLater(() -> ServerMainTreeItem.this.addOrRemoveTreeItems(serverRepos));
        }
    };

    public ServerMainTreeItem(Server server) {
        super(AssertUtil.assertNotNull((String)"server", (Object)server));
        this.setGraphic((Node)new ImageView(icon));
    }

    private void addOrRemoveTreeItems(List<ServerRepo> serverRepos) {
        ServerRepoMainTreeItem treeItem;
        HashSet<ServerRepo> modelRepos = new HashSet<ServerRepo>(serverRepos);
        HashMap<ServerRepo, ServerRepoMainTreeItem> viewRepo2ServerRepoMainTreeItem = new HashMap<ServerRepo, ServerRepoMainTreeItem>();
        for (TreeItem ti : this.getChildren()) {
            treeItem = (ServerRepoMainTreeItem)ti;
            viewRepo2ServerRepoMainTreeItem.put(treeItem.getServerRepo(), treeItem);
        }
        for (ServerRepo serverRepo : serverRepos) {
            if (viewRepo2ServerRepoMainTreeItem.containsKey(serverRepo)) continue;
            treeItem = new ServerRepoMainTreeItem(serverRepo);
            viewRepo2ServerRepoMainTreeItem.put(serverRepo, treeItem);
            this.getChildren().add((Object)treeItem);
        }
        if (modelRepos.size() < viewRepo2ServerRepoMainTreeItem.size()) {
            for (ServerRepo serverRepo : modelRepos) {
                viewRepo2ServerRepoMainTreeItem.remove(serverRepo);
            }
            for (ServerRepoMainTreeItem treeItem2 : viewRepo2ServerRepoMainTreeItem.values()) {
                this.getChildren().remove((Object)treeItem2);
            }
        }
    }

    public ObservableList<TreeItem<String>> getChildren() {
        ObservableList children = super.getChildren();
        if (!this.childrenLoaded) {
            this.childrenLoaded = true;
            List serverRepos = this.getServerRepoRegistry().getServerReposOfServer(this.getServer().getServerId());
            this.addOrRemoveTreeItems(serverRepos);
        }
        return children;
    }

    public boolean isLeaf() {
        return false;
    }

    protected ServerRepoRegistry getServerRepoRegistry() {
        if (this.serverRepoRegistry == null) {
            this.serverRepoRegistry = ServerRepoRegistryLs.getServerRepoRegistry();
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.serverRepoRegistry, (PropertyBase)ServerRepoRegistry.PropertyEnum.serverRepos, (PropertyChangeListener)this.serverReposPropertyChangeListener);
        }
        return this.serverRepoRegistry;
    }

    public Server getServer() {
        return (Server)this.getValueObject();
    }

    @Override
    protected String getValueString() {
        return ((Server)this.getValueObject()).getName();
    }

    public String toString() {
        return ((Server)this.getValueObject()).getName();
    }

    @Override
    protected Parent createMainDetailContent() {
        return new ServerPane((Server)this.getValueObject());
    }
}

