/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.maintree;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.listener.LocalRepoCommitEventListener;
import org.subshare.core.repo.listener.LocalRepoCommitEventManager;
import org.subshare.core.repo.listener.WeakLocalRepoCommitEventListener;
import org.subshare.core.repo.metaonly.ServerRepoFile;
import org.subshare.core.server.Server;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.ls.LocalRepoCommitEventManagerLs;
import org.subshare.gui.ls.MetaOnlyRepoManagerLs;
import org.subshare.gui.maintree.MainTreeItem;
import org.subshare.gui.maintree.ServerMainTreeItem;
import org.subshare.gui.maintree.ServerRepoDirectoryMainTreeItem;
import org.subshare.gui.maintree.UserListMainTreeItem;
import org.subshare.gui.serverrepo.ServerRepoPane;
import org.subshare.gui.util.PlatformUtil;

public class ServerRepoMainTreeItem
extends MainTreeItem<ServerRepo> {
    private static final Image icon = new Image(UserListMainTreeItem.class.getResource("server-repo_16x16.png").toExternalForm());
    private boolean childrenLoaded;
    private LocalRepoCommitEventListener localRepoCommitEventListener;
    private WeakLocalRepoCommitEventListener weakLocalRepoCommitEventListener;

    public ServerRepoMainTreeItem(ServerRepo serverRepo) {
        super(AssertUtil.assertNotNull((String)"serverRepo", (Object)serverRepo));
        this.setGraphic((Node)new ImageView(icon));
    }

    public Server getServer() {
        for (TreeItem parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof ServerMainTreeItem)) continue;
            return ((ServerMainTreeItem)parent).getServer();
        }
        throw new IllegalStateException("Failed to resolve server!");
    }

    public ServerRepo getServerRepo() {
        return (ServerRepo)this.getValueObject();
    }

    public ObservableList<TreeItem<String>> getChildren() {
        PlatformUtil.assertFxApplicationThread();
        final ObservableList children = super.getChildren();
        if (!this.childrenLoaded) {
            this.childrenLoaded = true;
            new Service<ServerRepoFile>(){

                protected Task<ServerRepoFile> createTask() {
                    return new SsTask<ServerRepoFile>(){

                        protected ServerRepoFile call() throws Exception {
                            return MetaOnlyRepoManagerLs.getMetaOnlyRepoManager().getRootServerRepoFile(ServerRepoMainTreeItem.this.getServerRepo());
                        }

                        protected void succeeded() {
                            ServerRepoFile rootServerRepoFile;
                            try {
                                rootServerRepoFile = (ServerRepoFile)this.get();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                            if (rootServerRepoFile == null) {
                                ServerRepoMainTreeItem.this.hookLocalRepoCommitEventListener();
                            } else {
                                ServerRepoMainTreeItem.this.unhookLocalRepoCommitEventListenerIfNeeded();
                                children.add((Object)new ServerRepoDirectoryMainTreeItem(rootServerRepoFile));
                            }
                        }
                    };
                }
            }.start();
        }
        return children;
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    protected String getValueString() {
        ServerRepo serverRepo = this.getServerRepo();
        String name = serverRepo.getName();
        return StringUtil.isEmpty((String)name) ? serverRepo.getRepositoryId().toString() : name;
    }

    @Override
    protected Parent createMainDetailContent() {
        return new ServerRepoPane(this.getServer(), this.getServerRepo());
    }

    private void hookLocalRepoCommitEventListener() {
        PlatformUtil.assertFxApplicationThread();
        if (this.weakLocalRepoCommitEventListener != null) {
            return;
        }
        this.localRepoCommitEventListener = event -> Platform.runLater(() -> {
            this.childrenLoaded = false;
            this.getChildren();
        });
        LocalRepoCommitEventManager localRepoCommitEventManager = LocalRepoCommitEventManagerLs.getLocalRepoCommitEventManager();
        this.weakLocalRepoCommitEventListener = new WeakLocalRepoCommitEventListener(localRepoCommitEventManager, this.localRepoCommitEventListener);
        this.weakLocalRepoCommitEventListener.addLocalRepoCommitEventListener();
    }

    private void unhookLocalRepoCommitEventListenerIfNeeded() {
        PlatformUtil.assertFxApplicationThread();
        if (this.weakLocalRepoCommitEventListener == null) {
            return;
        }
        this.weakLocalRepoCommitEventListener.removeLocalRepoCommitEventListener();
        this.localRepoCommitEventListener = null;
        this.weakLocalRepoCommitEventListener = null;
    }
}

