/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyAlgorithm;
import org.subshare.core.pgp.PgpKeyFlag;
import org.subshare.core.pgp.PgpKeyValidity;
import org.subshare.core.pgp.PgpOwnerTrust;
import org.subshare.gui.pgp.keytree.PgpKeyAlgorithmName;
import org.subshare.gui.pgp.keytree.PgpKeyFlagsToUsageConverter;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.SubKeysPgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.UserIdsPgpKeyTreeItem;

public class PgpKeyPgpKeyTreeItem
extends PgpKeyTreeItem<PgpKey> {
    public PgpKeyPgpKeyTreeItem(PgpKey pgpKey) {
        super(AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey));
    }

    public PgpKey getPgpKey() {
        return (PgpKey)this.getValueObject();
    }

    public ObservableList<TreeItem<PgpKeyTreeItem<?>>> getChildren() {
        ObservableList children = super.getChildren();
        if (children.isEmpty()) {
            PgpKey pgpKey = (PgpKey)this.getValueObject();
            children.add((Object)new UserIdsPgpKeyTreeItem(pgpKey));
            children.add((Object)new SubKeysPgpKeyTreeItem(pgpKey));
        }
        return children;
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getName() {
        List userIds = this.getPgpKey().getUserIds();
        return userIds.isEmpty() ? this.getKeyId() : (String)userIds.get(0);
    }

    @Override
    public String getKeyId() {
        return this.getPgpKey().getPgpKeyId().toHumanString();
    }

    @Override
    public String getKeyValidity() {
        PgpKey pgpKey = this.getPgpKey();
        PgpKeyValidity kv = this.getPgp().getKeyValidity(pgpKey);
        return kv.toShortString();
    }

    @Override
    public String getOwnerTrust() {
        PgpKey pgpKey = this.getPgpKey();
        PgpOwnerTrust ot = this.getPgp().getOwnerTrust(pgpKey);
        return ot.toShortString();
    }

    @Override
    public String getCreated() {
        PgpKey pgpKey = this.getPgpKey();
        Date created = pgpKey.getCreated();
        if (created == null) {
            return null;
        }
        return DateFormat.getDateInstance(3).format(created);
    }

    @Override
    public String getValidTo() {
        PgpKey pgpKey = this.getPgpKey();
        Date validTo = pgpKey.getValidTo();
        if (validTo == null) {
            return null;
        }
        return DateFormat.getDateInstance(3).format(validTo);
    }

    @Override
    public String getAlgorithm() {
        LinkedHashSet<PgpKeyAlgorithm> allPgpKeyAlgorithms = new LinkedHashSet<PgpKeyAlgorithm>();
        PgpKey pgpKey = this.getPgpKey();
        allPgpKeyAlgorithms.add(pgpKey.getAlgorithm());
        for (PgpKey subKey : pgpKey.getSubKeys()) {
            allPgpKeyAlgorithms.add(subKey.getAlgorithm());
        }
        StringBuilder sb = new StringBuilder();
        for (PgpKeyAlgorithm algorithm : allPgpKeyAlgorithms) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(PgpKeyAlgorithmName.getPgpKeyAlgorithmName(algorithm));
        }
        return sb.toString();
    }

    @Override
    public String getStrength() {
        LinkedHashSet<Integer> allPgpKeyStrengths = new LinkedHashSet<Integer>();
        PgpKey pgpKey = this.getPgpKey();
        allPgpKeyStrengths.add(pgpKey.getStrength());
        for (PgpKey subKey : pgpKey.getSubKeys()) {
            allPgpKeyStrengths.add(subKey.getStrength());
        }
        StringBuilder sb = new StringBuilder();
        for (Integer strength : allPgpKeyStrengths) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(strength);
        }
        return sb.toString();
    }

    @Override
    public String getUsage() {
        LinkedHashSet<PgpKeyFlag> allPgpKeyFlags = new LinkedHashSet<PgpKeyFlag>();
        PgpKey pgpKey = this.getPgpKey();
        allPgpKeyFlags.addAll(pgpKey.getPgpKeyFlags());
        for (PgpKey subKey : pgpKey.getSubKeys()) {
            allPgpKeyFlags.addAll(subKey.getPgpKeyFlags());
        }
        return new PgpKeyFlagsToUsageConverter().toUsage(allPgpKeyFlags);
    }
}

