/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.privatekeypassphrase;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import org.subshare.core.pgp.PgpKey;
import org.subshare.gui.util.FxmlUtil;

public abstract class PgpPrivateKeyPassphrasePromptPane
extends GridPane {
    private final PgpKey pgpKey;
    @FXML
    private HBox errorMessageBox;
    @FXML
    private Label errorMessageLabel;
    @FXML
    private Label headerLabel;
    @FXML
    private ComboBox<String> userIdsComboBox;
    @FXML
    private TextField keyIdTextField;
    @FXML
    private PasswordField passwordField;
    @FXML
    private Button okButton;
    @FXML
    private Button cancelButton;

    public PgpPrivateKeyPassphrasePromptPane(PgpKey pgpKey, String errorMessage) {
        FxmlUtil.loadDynamicComponentFxml(PgpPrivateKeyPassphrasePromptPane.class, this);
        this.pgpKey = (PgpKey)AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey);
        this.userIdsComboBox.setItems(FXCollections.observableArrayList((Collection)this.pgpKey.getUserIds()));
        this.userIdsComboBox.getSelectionModel().select(0);
        this.keyIdTextField.setText(this.pgpKey.getPgpKeyId().toHumanString());
        this.getChildren().remove((Object)this.errorMessageBox);
        if (errorMessage != null) {
            this.add((Node)this.errorMessageBox, 0, 0);
            GridPane.setColumnSpan((Node)this.errorMessageBox, (Integer)2);
            this.errorMessageLabel.setText(errorMessage);
        }
    }

    public void requestFocus() {
        super.requestFocus();
        this.passwordField.requestFocus();
    }

    public char[] getPassphrase() {
        return this.passwordField.getText().toCharArray();
    }

    @FXML
    protected abstract void okButtonClicked(ActionEvent var1);

    @FXML
    protected abstract void cancelButtonClicked(ActionEvent var1);
}

