/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.severity;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.image.Image;
import org.subshare.gui.IconSize;

public class SeverityImageRegistry {
    private final Map<Severity, Map<IconSize, Image>> severity2IconSize2Image = new HashMap<Severity, Map<IconSize, Image>>();

    private SeverityImageRegistry() {
    }

    public static SeverityImageRegistry getInstance() {
        return Holder.instance;
    }

    public synchronized Image getImage(Severity severity, IconSize iconSize) {
        Image image;
        AssertUtil.assertNotNull((String)"severity", (Object)severity);
        AssertUtil.assertNotNull((String)"iconSize", (Object)((Object)iconSize));
        Map<IconSize, Image> iconSize2Image = this.severity2IconSize2Image.get(severity);
        if (iconSize2Image == null) {
            iconSize2Image = new HashMap<IconSize, Image>();
            this.severity2IconSize2Image.put(severity, iconSize2Image);
        }
        if ((image = iconSize2Image.get((Object)iconSize)) == null) {
            try {
                String fileName = String.format("%s%s.png", severity.name(), iconSize.name());
                try (InputStream in = SeverityImageRegistry.class.getResourceAsStream(fileName);){
                    if (in == null) {
                        throw new IllegalArgumentException("There is no resource named: " + fileName);
                    }
                    image = new Image(in);
                    iconSize2Image.put(iconSize, image);
                }
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
        return image;
    }

    private static final class Holder {
        public static final SeverityImageRegistry instance = new SeverityImageRegistry();

        private Holder() {
        }
    }
}

