/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.userlist;

import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.client.util.FileLs;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import org.subshare.core.pgp.ImportKeysResult;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.user.ImportUsersFromPgpKeysResult;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRegistry;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.ls.UserRegistryLs;
import org.subshare.gui.pgp.imp.fromserver.ImportPgpKeyFromServerWizard;
import org.subshare.gui.user.EditUserManager;
import org.subshare.gui.userlist.UserListItem;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.wizard.WizardDialog;
import org.subshare.gui.wizard.WizardState;

public class UserListPane
extends GridPane {
    private final EditUserManager editUserManager;
    @FXML
    private Button addButton;
    @FXML
    private Button editButton;
    @FXML
    private Button deleteButton;
    @FXML
    private TextField filterTextField;
    @FXML
    private TableView<UserListItem> tableView;
    private final List<UserListItem> userListItems = new ArrayList<UserListItem>();
    private final Timer applyFilterLaterTimer = new Timer(true);
    private TimerTask applyFilterLaterTimerTask;
    private UserRegistry userRegistry;
    private final ListChangeListener<UserListItem> selectionListener = new ListChangeListener<UserListItem>(){

        public void onChanged(ListChangeListener.Change<? extends UserListItem> c) {
            UserListPane.this.updateDisable();
        }
    };
    private final EventHandler<MouseEvent> mouseEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() >= 2) {
                UserListPane.this.editSelectedUsers();
            }
        }
    };
    private final PropertyChangeListener usersPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            final LinkedHashSet users = new LinkedHashSet((List)evt.getNewValue());
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UserListPane.this.addOrRemoveItemTablesViewCallback(users);
                }
            });
        }
    };

    @Deprecated
    public UserListPane() {
        this.editUserManager = null;
        FxmlUtil.loadDynamicComponentFxml(UserListPane.class, this);
    }

    public UserListPane(EditUserManager editUserManager) {
        this.editUserManager = (EditUserManager)AssertUtil.assertNotNull((String)"", (Object)editUserManager);
        FxmlUtil.loadDynamicComponentFxml(UserListPane.class, this);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.getSelectionModel().getSelectedItems().addListener(this.selectionListener);
        this.tableView.setOnMouseClicked(this.mouseEventHandler);
        this.populateTableViewAsync();
        this.updateDisable();
        this.filterTextField.textProperty().addListener(observable -> this.applyFilterLater());
    }

    private void updateDisable() {
        boolean selectionEmpty = this.tableView.getSelectionModel().getSelectedItems().isEmpty();
        this.editButton.disableProperty().set(selectionEmpty);
        this.deleteButton.disableProperty().set(selectionEmpty);
    }

    private void populateTableViewAsync() {
        new Service<Collection<User>>(){

            protected Task<Collection<User>> createTask() {
                return new SsTask<Collection<User>>(){

                    protected Collection<User> call() throws Exception {
                        return UserListPane.this.getUserRegistry().getUsers();
                    }

                    protected void succeeded() {
                        Collection users;
                        try {
                            users = (Collection)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        UserListPane.this.addTableItemsViewCallback(users);
                    }
                };
            }
        }.start();
    }

    private List<UserListItem> addTableItemsViewCallback(Collection<User> users) {
        ArrayList<UserListItem> result = new ArrayList<UserListItem>(users.size());
        for (User user : users) {
            UserListItem userListItem = new UserListItem(user);
            result.add(userListItem);
            this.userListItems.add(userListItem);
            this.tableView.getItems().add((Object)userListItem);
        }
        this.tableView.requestLayout();
        return result;
    }

    private void addOrRemoveItemTablesViewCallback(Set<User> users) {
        AssertUtil.assertNotNull((String)"users", users);
        HashMap<User, UserListItem> viewUser2UserListItem = new HashMap<User, UserListItem>();
        for (UserListItem uli : this.tableView.getItems()) {
            viewUser2UserListItem.put(uli.getUser(), uli);
        }
        for (User user : users) {
            if (viewUser2UserListItem.containsKey(user)) continue;
            UserListItem uli = new UserListItem(user);
            viewUser2UserListItem.put(user, uli);
            this.tableView.getItems().add((Object)uli);
        }
        if (users.size() < viewUser2UserListItem.size()) {
            for (User user : users) {
                viewUser2UserListItem.remove(user);
            }
            for (UserListItem uli : viewUser2UserListItem.values()) {
                this.tableView.getItems().remove((Object)uli);
            }
        }
    }

    @FXML
    private void addButtonClicked(ActionEvent event) {
        UserRegistry userRegistry = this.getUserRegistry();
        User user = userRegistry.createUser();
        user.setFirstName(String.format("New user %s", Long.toString(System.currentTimeMillis(), 36)));
        userRegistry.addUser(user);
        List<UserListItem> userListItems = this.addTableItemsViewCallback(Collections.singleton(user));
        this.tableView.getSelectionModel().clearSelection();
        this.tableView.getSelectionModel().select((Object)userListItems.get(0));
        this.editSelectedUsers();
    }

    @FXML
    private void editButtonClicked(ActionEvent event) {
        this.editSelectedUsers();
    }

    private void editSelectedUsers() {
        ArrayList<User> users = new ArrayList<User>(this.tableView.getSelectionModel().getSelectedItems().size());
        for (UserListItem userListItem : this.tableView.getSelectionModel().getSelectedItems()) {
            users.add(userListItem.getUser());
        }
        this.editUserManager.edit(users);
    }

    @FXML
    private void deleteButtonClicked(ActionEvent event) {
        System.out.println("deleteButtonClicked: " + event);
        System.gc();
    }

    private void applyFilterLater() {
        if (this.applyFilterLaterTimerTask != null) {
            this.applyFilterLaterTimerTask.cancel();
            this.applyFilterLaterTimerTask = null;
        }
        this.applyFilterLaterTimerTask = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UserListPane.this.applyFilterLaterTimerTask = null;
                        UserListPane.this.applyFilter();
                    }
                });
            }
        };
        this.applyFilterLaterTimer.schedule(this.applyFilterLaterTimerTask, 300L);
    }

    private void applyFilter() {
        String filterText = this.filterTextField.getText().toLowerCase();
        Iterator<UserListItem> sourceIterator = this.userListItems.iterator();
        ListIterator tableItemIterator = this.tableView.getItems().listIterator();
        HashSet<User> includedUsers = new HashSet<User>();
        while (sourceIterator.hasNext()) {
            UserListItem tableUserListItem;
            UserListItem sourceUserListItem = sourceIterator.next();
            boolean matchesFilter = sourceUserListItem.matchesFilter(filterText);
            if (matchesFilter) {
                includedUsers.add(sourceUserListItem.getUser());
            }
            UserListItem userListItem = tableUserListItem = tableItemIterator.hasNext() ? (UserListItem)tableItemIterator.next() : null;
            if (tableUserListItem == null) {
                if (!matchesFilter) continue;
                tableItemIterator.add(sourceUserListItem);
                continue;
            }
            if (tableUserListItem == sourceUserListItem) {
                if (matchesFilter) continue;
                tableItemIterator.remove();
                continue;
            }
            if (matchesFilter) {
                tableItemIterator.previous();
                tableItemIterator.add(sourceUserListItem);
                continue;
            }
            tableItemIterator.previous();
        }
        while (tableItemIterator.hasNext()) {
            tableItemIterator.next();
            tableItemIterator.remove();
        }
    }

    @FXML
    private void importPgpKeyFromFileButtonClicked(ActionEvent event) {
        co.codewizards.cloudstore.core.oio.File file = this.showOpenFileDialog("Choose file containing PGP key(s) to import");
        if (file == null) {
            return;
        }
        try (IInputStream in = FileLs.createInputStream((co.codewizards.cloudstore.core.oio.File)file);){
            ImportKeysResult importKeysResult = this.getPgp().importKeys(in);
            this.importUsersFromPgpKeys(importKeysResult);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    @FXML
    private void importPgpKeyFromServerButtonClicked(ActionEvent event) {
        ImportPgpKeyFromServerWizard wizard = new ImportPgpKeyFromServerWizard();
        WizardDialog dialog = new WizardDialog(this.getScene().getWindow(), wizard);
        dialog.showAndWait();
        if (wizard.getState() == WizardState.FINISHED) {
            this.editImportedUsers(wizard.getImportPgpKeyFromServerData().getImportUsersResult());
        }
    }

    private void importUsersFromPgpKeys(ImportKeysResult importKeysResult) {
        AssertUtil.assertNotNull((String)"importKeysResult", (Object)importKeysResult);
        Pgp pgp = this.getPgp();
        HashMap<PgpKeyId, PgpKey> pgpKeyId2PgpKey = new HashMap<PgpKeyId, PgpKey>();
        for (ImportKeysResult.ImportedMasterKey importedMasterKey : importKeysResult.getPgpKeyId2ImportedMasterKey().values()) {
            PgpKeyId pgpKeyId = importedMasterKey.getPgpKeyId();
            PgpKey pgpKey = pgp.getPgpKey(pgpKeyId);
            AssertUtil.assertNotNull((String)("pgp.getPgpKey(" + pgpKeyId + ")"), (Object)pgpKey);
            pgpKeyId2PgpKey.put(pgpKeyId, pgpKey);
        }
        ImportUsersFromPgpKeysResult importUsersFromPgpKeysResult = this.getUserRegistry().importUsersFromPgpKeys(pgpKeyId2PgpKey.values());
        this.editImportedUsers(importUsersFromPgpKeysResult);
    }

    private void editImportedUsers(ImportUsersFromPgpKeysResult importUsersFromPgpKeysResult) {
        AssertUtil.assertNotNull((String)"importUsersFromPgpKeysResult", (Object)importUsersFromPgpKeysResult);
        ArrayList<User> users = new ArrayList<User>();
        for (List importedUsers : importUsersFromPgpKeysResult.getPgpKeyId2ImportedUsers().values()) {
            for (ImportUsersFromPgpKeysResult.ImportedUser importedUser : importedUsers) {
                users.add(importedUser.getUser());
            }
        }
        this.editUserManager.edit(users);
    }

    private co.codewizards.cloudstore.core.oio.File showOpenFileDialog(String title) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(title);
        File file = fileChooser.showOpenDialog(this.getScene().getWindow());
        return file == null ? null : OioFileFactory.createFile((File)file).getAbsoluteFile();
    }

    protected synchronized UserRegistry getUserRegistry() {
        if (this.userRegistry == null) {
            this.userRegistry = UserRegistryLs.getUserRegistry();
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.userRegistry, (PropertyBase)UserRegistry.PropertyEnum.users, (PropertyChangeListener)this.usersPropertyChangeListener);
        }
        return this.userRegistry;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected Pgp getPgp() {
        return PgpLs.getPgpOrFail();
    }
}

