/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.wizard;

import co.codewizards.cloudstore.core.progress.NullProgressMonitor;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Window;
import org.subshare.gui.error.ErrorHandler;
import org.subshare.gui.util.PlatformUtil;
import org.subshare.gui.wizard.DefaultFinishingPage;
import org.subshare.gui.wizard.FinishingPage;
import org.subshare.gui.wizard.WizardPage;
import org.subshare.gui.wizard.WizardState;

public abstract class Wizard
extends StackPane {
    private final IdentityHashMap<WizardPage, Void> knownPages = new IdentityHashMap();
    protected final ObjectProperty<WizardPage> firstPage = new SimpleObjectProperty<WizardPage>((Object)this, "firstPage"){

        public void set(WizardPage newValue) {
            WizardPage oldValue = (WizardPage)((Object)this.get());
            super.set((Object)newValue);
            if (Wizard.this.getCurrentPage() == oldValue) {
                Wizard.this.setCurrentPage(null);
            }
            if (newValue != null) {
                newValue.setWizard(Wizard.this);
                newValue.updateButtonsDisable();
                if (Wizard.this.getCurrentPage() == null) {
                    Wizard.this.navTo(newValue, false);
                }
            }
        }
    };
    protected final Deque<WizardPage> history = new LinkedList<WizardPage>();
    private final ObjectProperty<WizardPage> currentPage = new SimpleObjectProperty((Object)this, "currentPage");
    private final BooleanProperty canFinish = new SimpleBooleanProperty((Object)this, "canFinish");
    private Parent finishingPage = new DefaultFinishingPage();
    private final ObjectProperty<WizardState> stateProperty = new SimpleObjectProperty((Object)this, "state", (Object)WizardState.NEW);
    private Throwable error;
    private final InvalidationListener updateCanFinishInvalidationListener = observable -> this.updateCanFinish();

    protected Wizard() {
        this(null);
    }

    protected Wizard(WizardPage firstPage) {
        this.setFirstPage(firstPage);
        this.setStyle("-fx-padding: 10; -fx-background-color: cornsilk;");
        this.stateProperty.addListener((observable, oldState, newState) -> {
            if (newState == WizardState.FINISHING) {
                this.showFinishingPage();
            } else {
                this.hideFinishingPage();
            }
        });
        this.getChildren().add(0, (Object)this.finishingPage);
        this.setPrefWidth(500.0);
        this.setPrefHeight(300.0);
    }

    public void registerWizardPage(WizardPage wizardPage) {
        AssertUtil.assertNotNull((String)"wizardPage", (Object)((Object)wizardPage));
        if (wizardPage.getWizard() != null) {
            wizardPage.setWizard(this);
        }
        if (this.knownPages.containsKey((Object)wizardPage)) {
            return;
        }
        wizardPage.completeProperty().addListener(this.updateCanFinishInvalidationListener);
        this.knownPages.put(wizardPage, null);
        wizardPage.setVisible(false);
        this.getChildren().add(0, (Object)wizardPage);
    }

    public ObjectProperty<WizardPage> firstPageProperty() {
        return this.firstPage;
    }

    public WizardPage getFirstPage() {
        return (WizardPage)((Object)this.firstPage.get());
    }

    public void setFirstPage(WizardPage wizardPage) {
        this.firstPage.set((Object)wizardPage);
    }

    public void init() {
        PlatformUtil.assertFxApplicationThread();
        if (WizardState.NEW != this.stateProperty.get()) {
            throw new IllegalStateException("This wizard is not in state NEW! Current state: " + this.stateProperty.get());
        }
        this.stateProperty.set((Object)WizardState.IN_USER_INTERACTION);
    }

    protected void navToNextPage() {
        WizardPage nextPage;
        WizardPage currentPage = this.getCurrentPage();
        if (this.hasNextPage() && currentPage != null && (nextPage = currentPage.getNextPage()) != null) {
            this.navTo(nextPage, true);
        }
    }

    protected void navToPreviousPage() {
        if (this.hasPreviousPage()) {
            WizardPage previousPage = this.history.removeLast();
            this.navTo(previousPage, false);
        }
    }

    protected boolean hasNextPage() {
        WizardPage currentPage = this.getCurrentPage();
        if (currentPage == null) {
            return false;
        }
        return currentPage.getNextPage() != null;
    }

    protected WizardPage getCurrentPage() {
        return (WizardPage)((Object)this.currentPage.get());
    }

    private void setCurrentPage(WizardPage currentPage) {
        this.currentPage.set((Object)currentPage);
    }

    protected ReadOnlyObjectProperty<WizardPage> currentPageProperty() {
        return this.currentPage;
    }

    protected boolean hasPreviousPage() {
        return !this.history.isEmpty();
    }

    protected void navTo(final WizardPage wizardPage, boolean addToHistory) {
        AssertUtil.assertNotNull((String)"wizardPage", (Object)((Object)wizardPage));
        PlatformUtil.assertFxApplicationThread();
        WizardPage currentPage = this.getCurrentPage();
        if (currentPage != null) {
            currentPage.onHidden();
        }
        if (currentPage != null && addToHistory) {
            this.history.addLast(currentPage);
        }
        this.setCurrentPage(wizardPage);
        for (Node child : this.getChildren()) {
            child.setVisible(false);
        }
        wizardPage.setVisible(true);
        this.getChildren().remove((Object)wizardPage);
        this.getChildren().add((Object)wizardPage);
        wizardPage.updateButtonsDisable();
        this.updateCanFinish();
        if (this.getParent() != null) {
            this.getParent().requestFocus();
        }
        this.requestFocus();
        wizardPage.requestFocus();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Window window;
                Scene scene = Wizard.this.getScene();
                Window window2 = window = scene == null ? null : scene.getWindow();
                if (window != null) {
                    window.sizeToScene();
                }
                if (Wizard.this.getParent() != null) {
                    Wizard.this.getParent().requestFocus();
                }
                Wizard.this.requestFocus();
                wizardPage.requestFocus();
                wizardPage.onShown();
            }
        });
    }

    public void finish() {
        PlatformUtil.assertFxApplicationThread();
        Thread finishThread = new Thread(((Object)((Object)this)).getClass().getName() + '@' + Integer.toHexString(System.identityHashCode((Object)this)) + ".finishThread"){

            @Override
            public void run() {
                try {
                    Wizard.this.finish((ProgressMonitor)new NullProgressMonitor());
                    Platform.runLater(() -> {
                        Wizard.this.preFinished();
                        Wizard.this.stateProperty.set((Object)WizardState.FINISHED);
                        Wizard.this.finished();
                    });
                }
                catch (Throwable x) {
                    Platform.runLater(() -> {
                        Wizard.this.error = x;
                        Wizard.this.preFailed(x);
                        Wizard.this.stateProperty.set((Object)WizardState.FAILED);
                        Wizard.this.failed(x);
                    });
                }
            }
        };
        this.error = null;
        this.stateProperty.set((Object)WizardState.FINISHING);
        this.finishing();
        finishThread.start();
    }

    protected void finishing() {
    }

    protected abstract void finish(ProgressMonitor var1) throws Exception;

    protected void preFinished() {
    }

    protected void preFailed(Throwable error) {
        ErrorHandler.handleError(error);
    }

    protected void finished() {
    }

    protected void failed(Throwable error) {
    }

    public void cancel() {
        PlatformUtil.assertFxApplicationThread();
        this.stateProperty.set((Object)WizardState.CANCELLED);
    }

    public Throwable getError() {
        return this.error;
    }

    public ReadOnlyObjectProperty<WizardState> stateProperty() {
        return this.stateProperty;
    }

    public WizardState getState() {
        return (WizardState)((Object)this.stateProperty.get());
    }

    public abstract String getTitle();

    public ReadOnlyBooleanProperty canFinishProperty() {
        return this.canFinish;
    }

    protected void updateCanFinish() {
        boolean canFinish = true;
        for (WizardPage wizardPage : this.history) {
            if (wizardPage.completeProperty().getValue().booleanValue()) continue;
            canFinish = false;
        }
        for (WizardPage wizardPage = this.getCurrentPage(); wizardPage != null; wizardPage = wizardPage.getNextPage()) {
            if (wizardPage.completeProperty().getValue().booleanValue()) continue;
            canFinish = false;
        }
        this.canFinish.set(canFinish);
    }

    public Parent getFinishingPage() {
        return this.finishingPage;
    }

    public void setFinishingPage(Parent finishingPage) {
        AssertUtil.assertNotNull((String)"finishingPage", (Object)finishingPage);
        PlatformUtil.assertFxApplicationThread();
        if (!(finishingPage instanceof FinishingPage)) {
            throw new IllegalArgumentException("finishingPage is not an instance of FinishingPage!");
        }
        if (this.stateProperty.get() == WizardState.FINISHING) {
            this.hideFinishingPage();
        }
        this.getChildren().remove((Object)this.finishingPage);
        this.finishingPage = finishingPage;
        this.getChildren().add(0, (Object)finishingPage);
        if (this.stateProperty.get() == WizardState.FINISHING) {
            this.showFinishingPage();
        }
    }

    private void showFinishingPage() {
        this.getChildren().remove((Object)this.finishingPage);
        for (Node child : this.getChildren()) {
            child.setVisible(false);
        }
        this.finishingPage.setVisible(true);
        this.getChildren().add((Object)this.finishingPage);
        this.finishingPage.requestFocus();
    }

    private void hideFinishingPage() {
        this.finishingPage.setVisible(false);
        this.getChildren().remove((Object)this.finishingPage);
        this.getChildren().add(0, (Object)this.finishingPage);
        WizardPage currentPage = this.getCurrentPage();
        if (currentPage != null) {
            currentPage.setVisible(true);
        }
    }
}

