/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.local.PersistencePropertiesEnum;
import co.codewizards.cloudstore.local.PersistencePropertiesProvider;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(JdbcConnectionFactory.class);
    private final File localRoot;
    private String connectionURL;
    private String connectionDriverName;
    private String connectionUserName;
    private String connectionPassword;

    public JdbcConnectionFactory(File localRoot) {
        this.localRoot = (File)AssertUtil.assertNotNull((String)"localRoot", (Object)localRoot);
        if (!localRoot.isDirectory()) {
            throw new IllegalArgumentException("The given localRoot is not an existing directory: " + localRoot.getAbsolutePath());
        }
        this.initProperties();
        this.initDriverClass();
    }

    private UUID readRepositoryIdFromRepositoryPropertiesFile() {
        File repositoryPropertiesFile = OioFileFactory.createFile((File)this.getMetaDir(), (String[])new String[]{LocalRepoManager.REPOSITORY_PROPERTIES_FILE_NAME});
        try {
            Properties repositoryProperties = new Properties();
            try (InputStream in = StreamUtil.castStream((IInputStream)repositoryPropertiesFile.createInputStream());){
                repositoryProperties.load(in);
            }
            String repositoryIdStr = repositoryProperties.getProperty("repository.id");
            if (StringUtil.isEmpty((String)repositoryIdStr)) {
                throw new IllegalStateException("repositoryProperties.getProperty(PROP_REPOSITORY_ID) is empty!");
            }
            UUID repositoryId = UUID.fromString(repositoryIdStr);
            return repositoryId;
        }
        catch (Exception x) {
            throw new RuntimeException("Reading readRepositoryId from '" + repositoryPropertiesFile.getAbsolutePath() + "' failed: " + x, x);
        }
    }

    private void initProperties() {
        UUID repositoryId = this.readRepositoryIdFromRepositoryPropertiesFile();
        Map<String, String> persistenceProperties = new PersistencePropertiesProvider(repositoryId, this.localRoot).getPersistenceProperties();
        this.connectionDriverName = persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_DRIVER_NAME.key);
        this.connectionURL = persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_URL.key);
        this.connectionUserName = persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_USER_NAME.key);
        this.connectionPassword = persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_PASSWORD.key);
    }

    protected File getMetaDir() {
        return OioFileFactory.createFile((File)this.localRoot, (String[])new String[]{LocalRepoManager.META_DIR_NAME});
    }

    private void initDriverClass() {
        if (StringUtil.isEmpty((String)this.connectionDriverName)) {
            return;
        }
        try {
            Class.forName(this.connectionDriverName);
        }
        catch (Throwable e) {
            logger.warn("initDriverClass" + e, e);
        }
    }

    public Connection createConnection() throws SQLException {
        if (StringUtil.isEmpty((String)this.connectionUserName) && StringUtil.isEmpty((String)this.connectionPassword)) {
            return DriverManager.getConnection(this.connectionURL);
        }
        return DriverManager.getConnection(this.connectionURL, this.connectionUserName, this.connectionPassword);
    }
}

