/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.transport;

import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.dto.ChangeSetDto;
import co.codewizards.cloudstore.core.dto.ConfigPropSetDto;
import co.codewizards.cloudstore.core.dto.DirectoryDto;
import co.codewizards.cloudstore.core.dto.FileChunkDto;
import co.codewizards.cloudstore.core.dto.NormalFileDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.dto.RepositoryDto;
import co.codewizards.cloudstore.core.dto.SymlinkDto;
import co.codewizards.cloudstore.core.dto.TempChunkFileDto;
import co.codewizards.cloudstore.core.dto.VersionInfoDto;
import co.codewizards.cloudstore.core.dto.jaxb.TempChunkFileDtoIo;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.progress.LoggerProgressMonitor;
import co.codewizards.cloudstore.core.progress.NullProgressMonitor;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.repo.local.LocalRepoHelper;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.transport.AbstractRepoTransport;
import co.codewizards.cloudstore.core.repo.transport.CollisionException;
import co.codewizards.cloudstore.core.repo.transport.DeleteModificationCollisionException;
import co.codewizards.cloudstore.core.repo.transport.FileWriteStrategy;
import co.codewizards.cloudstore.core.repo.transport.LocalRepoTransport;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.repo.transport.TransferDoneMarkerType;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import co.codewizards.cloudstore.core.version.VersionInfoProvider;
import co.codewizards.cloudstore.local.FilenameFilterSkipMetaDir;
import co.codewizards.cloudstore.local.LocalRepoSync;
import co.codewizards.cloudstore.local.LocalRepoTransactionImpl;
import co.codewizards.cloudstore.local.dto.RepoFileDtoConverter;
import co.codewizards.cloudstore.local.dto.RepositoryDtoConverter;
import co.codewizards.cloudstore.local.persistence.DeleteModification;
import co.codewizards.cloudstore.local.persistence.DeleteModificationDao;
import co.codewizards.cloudstore.local.persistence.Directory;
import co.codewizards.cloudstore.local.persistence.FileInProgressMarker;
import co.codewizards.cloudstore.local.persistence.FileInProgressMarkerDao;
import co.codewizards.cloudstore.local.persistence.LastSyncToRemoteRepo;
import co.codewizards.cloudstore.local.persistence.LastSyncToRemoteRepoDao;
import co.codewizards.cloudstore.local.persistence.LocalRepository;
import co.codewizards.cloudstore.local.persistence.LocalRepositoryDao;
import co.codewizards.cloudstore.local.persistence.Modification;
import co.codewizards.cloudstore.local.persistence.ModificationDao;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryRequest;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryRequestDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import co.codewizards.cloudstore.local.persistence.Symlink;
import co.codewizards.cloudstore.local.persistence.TransferDoneMarker;
import co.codewizards.cloudstore.local.persistence.TransferDoneMarkerDao;
import co.codewizards.cloudstore.local.transport.ChangeSetDtoBuilder;
import co.codewizards.cloudstore.local.transport.ParentFileLastModifiedManager;
import co.codewizards.cloudstore.local.transport.TempChunkFileManager;
import co.codewizards.cloudstore.local.transport.TempChunkFileWithDtoFile;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jdo.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRepoTransport
extends AbstractRepoTransport
implements LocalRepoTransport {
    private static final Logger logger = LoggerFactory.getLogger(FileRepoTransport.class);
    private static final long MAX_REMOTE_REPOSITORY_REQUESTS_QUANTITY = 100L;
    private LocalRepoManager localRepoManager;
    private final TempChunkFileManager tempChunkFileManager = TempChunkFileManager.getInstance();
    private final Map<File, FileWriteStrategy> file2FileWriteStrategy = new WeakHashMap<File, FileWriteStrategy>();

    public void close() {
        if (this.localRepoManager != null) {
            logger.debug("close: Closing localRepoManager.");
            this.localRepoManager.close();
        } else {
            logger.debug("close: There is no localRepoManager.");
        }
        super.close();
    }

    public UUID getRepositoryId() {
        return this.getLocalRepoManager().getRepositoryId();
    }

    public byte[] getPublicKey() {
        return this.getLocalRepoManager().getPublicKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRepoConnection(byte[] publicKey) {
        AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();
        try {
            RemoteRepositoryDao remoteRepositoryDao = (RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class);
            RemoteRepository remoteRepository = remoteRepositoryDao.getRemoteRepository(clientRepositoryId);
            if (remoteRepository != null) {
                throw new IllegalArgumentException("RemoteRepository already connected! repositoryId=" + clientRepositoryId);
            }
            String localPathPrefix = this.getPathPrefix();
            RemoteRepositoryRequestDao remoteRepositoryRequestDao = (RemoteRepositoryRequestDao)transaction.getDao(RemoteRepositoryRequestDao.class);
            RemoteRepositoryRequest remoteRepositoryRequest = remoteRepositoryRequestDao.getRemoteRepositoryRequest(clientRepositoryId);
            if (remoteRepositoryRequest != null) {
                logger.info("RemoteRepository already requested to be connected. repositoryId={}", (Object)clientRepositoryId);
                if (!Arrays.equals(remoteRepositoryRequest.getPublicKey(), publicKey)) {
                    throw new IllegalStateException("Cannot modify the public key! Use 'dropRepoConnection' to drop the old request or wait until it expired.");
                }
                if (!remoteRepositoryRequest.getLocalPathPrefix().equals(localPathPrefix)) {
                    throw new IllegalStateException("Cannot modify the local path-prefix! Use 'dropRepoConnection' to drop the old request or wait until it expired.");
                }
                remoteRepositoryRequest.setChanged(new Date());
            } else {
                long remoteRepositoryRequestsCount = remoteRepositoryRequestDao.getObjectsCount();
                if (remoteRepositoryRequestsCount >= 100L) {
                    throw new IllegalStateException(String.format("The maximum number of connection requests (%s) is reached or exceeded! Please retry later, when old requests were accepted or expired.", 100L));
                }
                remoteRepositoryRequest = new RemoteRepositoryRequest();
                remoteRepositoryRequest.setRepositoryId(clientRepositoryId);
                remoteRepositoryRequest.setPublicKey(publicKey);
                remoteRepositoryRequest.setLocalPathPrefix(localPathPrefix);
                remoteRepositoryRequestDao.makePersistent(remoteRepositoryRequest);
            }
            transaction.commit();
        }
        finally {
            transaction.rollbackIfActive();
        }
    }

    public RepositoryDto getRepositoryDto() {
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginReadTransaction();){
            LocalRepositoryDao localRepositoryDao = (LocalRepositoryDao)transaction.getDao(LocalRepositoryDao.class);
            LocalRepository localRepository = localRepositoryDao.getLocalRepositoryOrFail();
            RepositoryDto repositoryDto = RepositoryDtoConverter.create().toRepositoryDto(localRepository);
            transaction.commit();
            RepositoryDto repositoryDto2 = repositoryDto;
            return repositoryDto2;
        }
    }

    public ChangeSetDto getChangeSetDto(boolean localSync) {
        if (localSync) {
            this.getLocalRepoManager().localSync((ProgressMonitor)new LoggerProgressMonitor(logger));
        }
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            ChangeSetDto changeSetDto = ChangeSetDtoBuilder.create(transaction, (RepoTransport)this).buildChangeSetDto();
            transaction.commit();
            ChangeSetDto changeSetDto2 = changeSetDto;
            return changeSetDto2;
        }
    }

    public void prepareForChangeSetDto(ChangeSetDto changeSetDto) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeDirectory(String path, Date lastModified) {
        path = this.prefixPath(path);
        File file = this.getFile(path);
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();
        try {
            this.assertNoDeleteModificationCollision(transaction, clientRepositoryId, path);
            this.mkDir(transaction, clientRepositoryId, file, lastModified);
            transaction.commit();
        }
        finally {
            transaction.rollbackIfActive();
        }
    }

    public void makeSymlink(String path, String target, Date lastModified) {
        path = this.prefixPath(path);
        AssertUtil.assertNotNull((String)"target", (Object)target);
        File file = this.getFile(path);
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
            File parentFile = file.getParentFile();
            ParentFileLastModifiedManager.getInstance().backupParentFileLastModified(parentFile);
            try {
                this.assertNoDeleteModificationCollision(transaction, clientRepositoryId, path);
                if (file.existsNoFollow() && !file.isSymbolicLink()) {
                    this.handleFileTypeCollision(transaction, clientRepositoryId, file, SymlinkDto.class);
                }
                if (file.existsNoFollow() && !file.isSymbolicLink()) {
                    throw new IllegalStateException("Could not rename file! It is still in the way: " + file);
                }
                File localRoot = this.getLocalRepoManager().getLocalRoot();
                try {
                    boolean currentTargetEqualsNewTarget;
                    if (file.isSymbolicLink()) {
                        String currentTarget = file.readSymbolicLinkToPathString();
                        currentTargetEqualsNewTarget = currentTarget.equals(target);
                        if (!currentTargetEqualsNewTarget) {
                            RepoFile repoFile = repoFileDao.getRepoFile(localRoot, file);
                            if (repoFile == null) {
                                this.handleFileCollision(transaction, clientRepositoryId, file);
                            } else {
                                this.detectAndHandleFileCollision(transaction, clientRepositoryId, parentFile, repoFile);
                            }
                            file.delete();
                        }
                    } else {
                        currentTargetEqualsNewTarget = false;
                    }
                    if (!currentTargetEqualsNewTarget) {
                        file.createSymbolicLink(target);
                    }
                    if (lastModified != null) {
                        file.setLastModifiedNoFollow(lastModified.getTime());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                RepoFile repoFile = this.syncRepoFile(transaction, file);
                if (repoFile == null) {
                    throw new IllegalStateException("LocalRepoSync.sync(...) did not create the RepoFile for file: " + file);
                }
                if (!(repoFile instanceof Symlink)) {
                    throw new IllegalStateException("LocalRepoSync.sync(...) created an instance of " + repoFile.getClass().getName() + " instead  of a Symlink for file: " + file);
                }
                repoFile.setLastSyncFromRepositoryId(clientRepositoryId);
                Collection<TempChunkFileWithDtoFile> tempChunkFileWithDtoFiles = this.tempChunkFileManager.getOffset2TempChunkFileWithDtoFile(file).values();
                for (TempChunkFileWithDtoFile tempChunkFileWithDtoFile : tempChunkFileWithDtoFiles) {
                    if (tempChunkFileWithDtoFile.getTempChunkFileDtoFile() != null) {
                        IOUtil.deleteOrFail((File)tempChunkFileWithDtoFile.getTempChunkFileDtoFile());
                    }
                    if (tempChunkFileWithDtoFile.getTempChunkFile() == null) continue;
                    IOUtil.deleteOrFail((File)tempChunkFileWithDtoFile.getTempChunkFile());
                }
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
            finally {
                ParentFileLastModifiedManager.getInstance().restoreParentFileLastModified(parentFile);
            }
            transaction.commit();
        }
    }

    protected void assertNoDeleteModificationCollision(LocalRepoTransaction transaction, UUID fromRepositoryId, String path) throws CollisionException {
        DeleteModificationDao deleteModificationDao;
        Collection<DeleteModification> deleteModifications;
        RemoteRepository fromRemoteRepository = ((RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryOrFail(fromRepositoryId);
        long lastSyncFromRemoteRepositoryLocalRevision = fromRemoteRepository.getLocalRevision();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!(deleteModifications = (deleteModificationDao = (DeleteModificationDao)transaction.getDao(DeleteModificationDao.class)).getDeleteModificationsForPathOrParentOfPathAfter(path, lastSyncFromRemoteRepositoryLocalRevision, fromRemoteRepository)).isEmpty()) {
            throw new DeleteModificationCollisionException(String.format("There is at least one DeleteModification for repositoryId=%s path='%s'", fromRepositoryId, path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(String fromPath, String toPath) {
        fromPath = this.prefixPath(fromPath);
        toPath = this.prefixPath(toPath);
        File fromFile = this.getFile(fromPath);
        File toFile = this.getFile(toPath);
        if (!fromFile.isFile()) {
            return;
        }
        if (toFile.existsNoFollow()) {
            return;
        }
        File toParentFile = toFile.getParentFile();
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            ParentFileLastModifiedManager.getInstance().backupParentFileLastModified(toParentFile);
            try {
                try {
                    if (!toParentFile.isDirectory()) {
                        toParentFile.mkdirs();
                    }
                    fromFile.copyToCopyAttributes(toFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                LocalRepoSync localRepoSync = LocalRepoSync.create(transaction);
                RepoFile toRepoFile = localRepoSync.sync(toFile, (ProgressMonitor)new NullProgressMonitor(), true);
                AssertUtil.assertNotNull((String)"toRepoFile", (Object)toRepoFile);
                toRepoFile.setLastSyncFromRepositoryId(this.getClientRepositoryIdOrFail());
            }
            finally {
                ParentFileLastModifiedManager.getInstance().restoreParentFileLastModified(toParentFile);
            }
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String fromPath, String toPath) {
        fromPath = this.prefixPath(fromPath);
        toPath = this.prefixPath(toPath);
        File fromFile = this.getFile(fromPath);
        File toFile = this.getFile(toPath);
        if (!fromFile.isFile()) {
            return;
        }
        if (toFile.existsNoFollow()) {
            return;
        }
        File fromParentFile = fromFile.getParentFile();
        File toParentFile = toFile.getParentFile();
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            ParentFileLastModifiedManager.getInstance().backupParentFileLastModified(fromParentFile);
            ParentFileLastModifiedManager.getInstance().backupParentFileLastModified(toParentFile);
            try {
                try {
                    if (!toParentFile.isDirectory()) {
                        toParentFile.mkdirs();
                    }
                    fromFile.move(toFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                LocalRepoSync localRepoSync = LocalRepoSync.create(transaction);
                RepoFile toRepoFile = localRepoSync.sync(toFile, (ProgressMonitor)new NullProgressMonitor(), true);
                RepoFile fromRepoFile = ((RepoFileDao)transaction.getDao(RepoFileDao.class)).getRepoFile(this.getLocalRepoManager().getLocalRoot(), fromFile);
                if (fromRepoFile != null) {
                    localRepoSync.deleteRepoFile(fromRepoFile);
                }
                AssertUtil.assertNotNull((String)"toRepoFile", (Object)toRepoFile);
                toRepoFile.setLastSyncFromRepositoryId(this.getClientRepositoryIdOrFail());
            }
            finally {
                ParentFileLastModifiedManager.getInstance().restoreParentFileLastModified(fromParentFile);
                ParentFileLastModifiedManager.getInstance().restoreParentFileLastModified(toParentFile);
            }
            transaction.commit();
        }
        this.moveFileInProgressLocalRepo(this.getClientRepositoryId(), this.getRepositoryId(), fromPath, toPath);
        this.tempChunkFileManager.moveChunks(fromFile, toFile);
    }

    private void moveFileInProgressLocalRepo(UUID fromRepositoryId, UUID toRepositoryId, String fromPath, String toPath) {
        fromPath = this.prefixPath(fromPath);
        toPath = this.prefixPath(toPath);
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            FileInProgressMarkerDao fileInProgressMarkerDao = (FileInProgressMarkerDao)transaction.getDao(FileInProgressMarkerDao.class);
            FileInProgressMarker toFileInProgressMarker = fileInProgressMarkerDao.getFileInProgressMarker(fromRepositoryId, toRepositoryId, fromPath);
            if (toFileInProgressMarker != null) {
                logger.info("Updating FileInProgressMarker: {}, new toPath={}", (Object)toFileInProgressMarker, (Object)toPath);
                toFileInProgressMarker.setPath(toPath);
            }
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path) {
        path = this.prefixPath(path);
        File file = this.getFile(path);
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        boolean fileIsLocalRoot = this.getLocalRepoManager().getLocalRoot().equals(file);
        File parentFile = file.getParentFile();
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            block21: {
                ParentFileLastModifiedManager.getInstance().backupParentFileLastModified(parentFile);
                try {
                    LocalRepoSync localRepoSync = LocalRepoSync.create(transaction);
                    localRepoSync.sync(file, (ProgressMonitor)new NullProgressMonitor(), true);
                    if (fileIsLocalRoot) {
                        long fileLastModified = file.lastModified();
                        try {
                            File[] children = file.listFiles((FilenameFilter)new FilenameFilterSkipMetaDir());
                            if (children == null) {
                                throw new IllegalStateException("File-listing localRoot returned null: " + file);
                            }
                            for (File child : children) {
                                this.delete(transaction, localRepoSync, clientRepositoryId, child);
                            }
                            break block21;
                        }
                        finally {
                            file.setLastModified(fileLastModified);
                        }
                    }
                    this.delete(transaction, localRepoSync, clientRepositoryId, file);
                }
                finally {
                    ParentFileLastModifiedManager.getInstance().restoreParentFileLastModified(parentFile);
                }
            }
            transaction.commit();
        }
    }

    private void delete(LocalRepoTransaction transaction, LocalRepoSync localRepoSync, UUID fromRepositoryId, File file) {
        if (this.detectFileCollisionRecursively(transaction, fromRepositoryId, file)) {
            this.handleFileCollision(transaction, fromRepositoryId, file);
        }
        if (!IOUtil.deleteDirectoryRecursively((File)file)) {
            throw new IllegalStateException("Deleting file or directory failed: " + file);
        }
        RepoFile repoFile = ((RepoFileDao)transaction.getDao(RepoFileDao.class)).getRepoFile(this.getLocalRepoManager().getLocalRoot(), file);
        if (repoFile != null) {
            localRepoSync.deleteRepoFile(repoFile);
        }
    }

    public RepoFileDto getRepoFileDto(String path) {
        RepoFileDto repoFileDto = null;
        path = this.prefixPath(path);
        File file = this.getFile(path);
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            LocalRepoSync localRepoSync = LocalRepoSync.create(transaction);
            localRepoSync.sync(file, (ProgressMonitor)new NullProgressMonitor(), false);
            RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
            RepoFile repoFile = repoFileDao.getRepoFile(this.getLocalRepoManager().getLocalRoot(), file);
            if (repoFile != null) {
                RepoFileDtoConverter converter = RepoFileDtoConverter.create(transaction);
                repoFileDto = converter.toRepoFileDto(repoFile, Integer.MAX_VALUE);
            }
            transaction.commit();
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        return repoFileDto;
    }

    public LocalRepoManager getLocalRepoManager() {
        if (this.localRepoManager == null) {
            File remoteRootFile;
            logger.debug("getLocalRepoManager: Creating a new LocalRepoManager.");
            try {
                remoteRootFile = OioFileFactory.createFile((URI)this.getRemoteRootWithoutPathPrefix().toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(remoteRootFile);
        }
        return this.localRepoManager;
    }

    protected URL determineRemoteRootWithoutPathPrefix() {
        File remoteRootFile = UrlUtil.getFile((URL)this.getRemoteRoot());
        File localRootFile = LocalRepoHelper.getLocalRootContainingFile((File)remoteRootFile);
        if (localRootFile == null) {
            throw new IllegalStateException(String.format("remoteRoot='%s' does not point to a file or directory within an existing repository (nor its root directory)!", this.getRemoteRoot()));
        }
        try {
            return localRootFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mkDir(LocalRepoTransaction transaction, UUID clientRepositoryId, File file, Date lastModified) {
        File parentFile;
        AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
        AssertUtil.assertNotNull((String)"file", (Object)file);
        File localRoot = this.getLocalRepoManager().getLocalRoot();
        File file2 = parentFile = localRoot.equals(file) ? null : file.getParentFile();
        if (parentFile != null) {
            ParentFileLastModifiedManager.getInstance().backupParentFileLastModified(parentFile);
        }
        try {
            RepoFile repoFile;
            RepoFile parentRepoFile;
            RepoFile repoFile2 = parentRepoFile = parentFile == null ? null : ((RepoFileDao)transaction.getDao(RepoFileDao.class)).getRepoFile(localRoot, parentFile);
            if (parentFile != null) {
                if (!(localRoot.equals(parentFile) || parentFile.isDirectory() && parentRepoFile != null)) {
                    this.mkDir(transaction, clientRepositoryId, parentFile, null);
                }
                if (parentRepoFile == null) {
                    parentRepoFile = ((RepoFileDao)transaction.getDao(RepoFileDao.class)).getRepoFile(localRoot, parentFile);
                }
                if (parentRepoFile == null) {
                    throw new IllegalStateException("parentRepoFile == null");
                }
            }
            if (file.existsNoFollow() && !file.isDirectory()) {
                this.handleFileTypeCollision(transaction, clientRepositoryId, file, DirectoryDto.class);
            }
            if (file.existsNoFollow() && !file.isDirectory()) {
                throw new IllegalStateException("Could not rename file! It is still in the way: " + file);
            }
            if (!file.isDirectory()) {
                file.mkdir();
            }
            if (!file.isDirectory()) {
                throw new IllegalStateException("Could not create directory (permissions?!): " + file);
            }
            if (lastModified != null) {
                file.setLastModified(lastModified.getTime());
            }
            if ((repoFile = this.syncRepoFile(transaction, file)) == null) {
                throw new IllegalStateException("Just created directory, but corresponding RepoFile still does not exist after local sync: " + file);
            }
            if (!(repoFile instanceof Directory)) {
                throw new IllegalStateException("Just created directory, and even though the corresponding RepoFile now exists, it is not an instance of Directory! It is a " + repoFile.getClass().getName() + " instead! " + file);
            }
            repoFile.setLastSyncFromRepositoryId(clientRepositoryId);
        }
        finally {
            if (parentFile != null) {
                ParentFileLastModifiedManager.getInstance().restoreParentFileLastModified(parentFile);
            }
        }
    }

    protected RepoFile syncRepoFile(LocalRepoTransaction transaction, File file) {
        AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
        AssertUtil.assertNotNull((String)"file", (Object)file);
        return LocalRepoSync.create(transaction).sync(file, (ProgressMonitor)new NullProgressMonitor(), false);
    }

    protected File getFile(String path) {
        path = ((String)AssertUtil.assertNotNull((String)"path", (Object)path)).replace('/', OioFileFactory.FILE_SEPARATOR_CHAR);
        File file = OioFileFactory.createFile((File)this.getLocalRepoManager().getLocalRoot(), (String[])new String[]{path});
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getFileData(String path, long offset, int length) {
        path = this.prefixPath(path);
        File file = this.getFile(path);
        try (RandomAccessFile raf = file.createRandomAccessFile("r");){
            int off;
            raf.seek(offset);
            if (length < 0) {
                long l = raf.length() - offset;
                if (l > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException(String.format("The data to be read from file '%s' is too large (offset=%s length=%s limit=%s). You must specify a length (and optionally an offset) to read it partially.", path, offset, length, Integer.MAX_VALUE));
                }
                length = (int)l;
            }
            byte[] bytes = new byte[length];
            int numRead = 0;
            for (off = 0; off < bytes.length && (numRead = raf.read(bytes, off, bytes.length - off)) >= 0; off += numRead) {
            }
            if (off < bytes.length) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginPutFile(String path) {
        path = this.prefixPath(path);
        File file = this.getFile(path);
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        File parentFile = file.getParentFile();
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            ParentFileLastModifiedManager.getInstance().backupParentFileLastModified(parentFile);
            try {
                if (file.isSymbolicLink() || file.exists() && !file.isFile()) {
                    this.handleFileTypeCollision(transaction, clientRepositoryId, file, NormalFileDto.class);
                }
                if (file.isSymbolicLink() || file.exists() && !file.isFile()) {
                    throw new IllegalStateException("Could not rename file! It is still in the way: " + file);
                }
                File localRoot = this.getLocalRepoManager().getLocalRoot();
                this.assertNoDeleteModificationCollision(transaction, clientRepositoryId, path);
                boolean newFile = false;
                if (!file.isFile()) {
                    newFile = true;
                    try {
                        file.createNewFile();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!file.isFile()) {
                    throw new IllegalStateException("Could not create file (permissions?!): " + file);
                }
                this.tempChunkFileManager.deleteTempChunkFilesWithoutDtoFile(this.tempChunkFileManager.getOffset2TempChunkFileWithDtoFile(file).values());
                RepoFile repoFile = this.syncRepoFile(transaction, file);
                if (repoFile == null) {
                    throw new IllegalStateException("LocalRepoSync.sync(...) did not create the RepoFile for file: " + file);
                }
                if (!(repoFile instanceof NormalFile)) {
                    throw new IllegalStateException("LocalRepoSync.sync(...) created an instance of " + repoFile.getClass().getName() + " instead  of a NormalFile for file: " + file);
                }
                NormalFile normalFile = (NormalFile)repoFile;
                if (!newFile && !normalFile.isInProgress()) {
                    this.detectAndHandleFileCollision(transaction, clientRepositoryId, file, normalFile);
                }
                normalFile.setLastSyncFromRepositoryId(clientRepositoryId);
                normalFile.setInProgress(true);
            }
            finally {
                ParentFileLastModifiedManager.getInstance().restoreParentFileLastModified(parentFile);
            }
            transaction.commit();
        }
    }

    protected void handleFileTypeCollision(LocalRepoTransaction transaction, UUID fromRepositoryId, File file, Class<? extends RepoFileDto> fromFileType) {
        Class<SymlinkDto> toFileType;
        AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
        AssertUtil.assertNotNull((String)"fromRepositoryId", (Object)fromRepositoryId);
        AssertUtil.assertNotNull((String)"file", (Object)file);
        AssertUtil.assertNotNull((String)"fromFileType", fromFileType);
        if (file.isSymbolicLink()) {
            toFileType = SymlinkDto.class;
        } else if (file.isFile()) {
            toFileType = NormalFileDto.class;
        } else if (file.isDirectory()) {
            toFileType = DirectoryDto.class;
        } else {
            throw new IllegalStateException("file has unknown type: " + file);
        }
        logger.info("handleFileTypeCollision: Collision: Destination file already exists, is modified and has a different type! toFileType={} fromFileType={} file='{}'", new Object[]{toFileType.getSimpleName(), fromFileType.getSimpleName(), file.getAbsolutePath()});
        File collisionFile = this.handleFileCollision(transaction, fromRepositoryId, file);
        LocalRepoSync.create(transaction).sync(collisionFile, (ProgressMonitor)new NullProgressMonitor(), true);
    }

    protected void detectAndHandleFileCollision(LocalRepoTransaction transaction, UUID fromRepositoryId, File file, RepoFile normalFileOrSymlink) {
        AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
        AssertUtil.assertNotNull((String)"fromRepositoryId", (Object)fromRepositoryId);
        AssertUtil.assertNotNull((String)"file", (Object)file);
        AssertUtil.assertNotNull((String)"normalFileOrSymlink", (Object)normalFileOrSymlink);
        if (this.detectFileCollision(transaction, fromRepositoryId, file, normalFileOrSymlink)) {
            File collisionFile = this.handleFileCollision(transaction, fromRepositoryId, file);
            try {
                collisionFile.copyToCopyAttributes(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            LocalRepoSync.create(transaction).sync(collisionFile, (ProgressMonitor)new NullProgressMonitor(), true);
        }
    }

    protected File handleFileCollision(LocalRepoTransaction transaction, UUID fromRepositoryId, File file) {
        AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
        AssertUtil.assertNotNull((String)"fromRepositoryId", (Object)fromRepositoryId);
        AssertUtil.assertNotNull((String)"file", (Object)file);
        File collisionFile = IOUtil.createCollisionFile((File)file);
        file.renameTo(collisionFile);
        if (file.existsNoFollow()) {
            throw new IllegalStateException("Could not rename file to resolve collision: " + file);
        }
        return collisionFile;
    }

    protected boolean detectFileCollisionRecursively(LocalRepoTransaction transaction, UUID fromRepositoryId, File fileOrDirectory) {
        AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
        AssertUtil.assertNotNull((String)"fromRepositoryId", (Object)fromRepositoryId);
        AssertUtil.assertNotNull((String)"fileOrDirectory", (Object)fileOrDirectory);
        if (fileOrDirectory.isSymbolicLink()) {
            RepoFile repoFile = ((RepoFileDao)transaction.getDao(RepoFileDao.class)).getRepoFile(this.getLocalRepoManager().getLocalRoot(), fileOrDirectory);
            if (!(repoFile instanceof Symlink)) {
                return true;
            }
            return this.detectFileCollision(transaction, fromRepositoryId, fileOrDirectory, repoFile);
        }
        if (!fileOrDirectory.exists()) {
            return false;
        }
        if (fileOrDirectory.isFile()) {
            RepoFile repoFile = ((RepoFileDao)transaction.getDao(RepoFileDao.class)).getRepoFile(this.getLocalRepoManager().getLocalRoot(), fileOrDirectory);
            if (!(repoFile instanceof NormalFile)) {
                return true;
            }
            return this.detectFileCollision(transaction, fromRepositoryId, fileOrDirectory, repoFile);
        }
        File[] children = fileOrDirectory.listFiles();
        if (children == null) {
            throw new IllegalStateException("listFiles() of directory returned null: " + fileOrDirectory);
        }
        for (File child : children) {
            if (!this.detectFileCollisionRecursively(transaction, fromRepositoryId, child)) continue;
            return true;
        }
        return false;
    }

    protected boolean detectFileCollision(LocalRepoTransaction transaction, UUID fromRepositoryId, File file, RepoFile normalFileOrSymlink) {
        AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
        AssertUtil.assertNotNull((String)"fromRepositoryId", (Object)fromRepositoryId);
        AssertUtil.assertNotNull((String)"file", (Object)file);
        AssertUtil.assertNotNull((String)"normalFileOrSymlink", (Object)normalFileOrSymlink);
        if (!file.existsNoFollow()) {
            logger.debug("detectFileCollision: path='{}': return false, because destination file does not exist.", (Object)normalFileOrSymlink.getPath());
            return false;
        }
        RemoteRepository fromRemoteRepository = ((RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryOrFail(fromRepositoryId);
        long lastSyncFromRemoteRepositoryLocalRevision = fromRemoteRepository.getLocalRevision();
        if (normalFileOrSymlink.getLocalRevision() <= lastSyncFromRemoteRepositoryLocalRevision) {
            logger.debug("detectFileCollision: path='{}': return false, because: normalFileOrSymlink.localRevision <= lastSyncFromRemoteRepositoryLocalRevision :: {} <= {}", new Object[]{normalFileOrSymlink.getPath(), normalFileOrSymlink.getLocalRevision(), lastSyncFromRemoteRepositoryLocalRevision});
            return false;
        }
        if (fromRepositoryId.equals(normalFileOrSymlink.getLastSyncFromRepositoryId())) {
            logger.debug("detectFileCollision: path='{}': return false, because: fromRepositoryId == normalFileOrSymlink.lastSyncFromRepositoryId :: fromRepositoryId='{}'", (Object)normalFileOrSymlink.getPath(), (Object)fromRemoteRepository);
            return false;
        }
        logger.debug("detectFileCollision: path='{}': return true! fromRepositoryId='{}' normalFileOrSymlink.localRevision={} lastSyncFromRemoteRepositoryLocalRevision={} normalFileOrSymlink.lastSyncFromRepositoryId='{}'", new Object[]{normalFileOrSymlink.getPath(), fromRemoteRepository, normalFileOrSymlink.getLocalRevision(), lastSyncFromRemoteRepositoryLocalRevision, normalFileOrSymlink.getLastSyncFromRepositoryId()});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void putFileData(String path, long offset, byte[] fileData) {
        path = this.prefixPath(path);
        file = this.getFile(path);
        parentFile = file.getParentFile();
        localRoot = this.getLocalRepoManager().getLocalRoot();
        transaction = this.getLocalRepoManager().beginReadTransaction();
        var9_8 = null;
        try {
            ParentFileLastModifiedManager.getInstance().backupParentFileLastModified(parentFile);
            try {
                repoFile = ((RepoFileDao)transaction.getDao(RepoFileDao.class)).getRepoFile(localRoot, file);
                if (repoFile == null) {
                    throw new IllegalStateException("No RepoFile found for file: " + file);
                }
                if (!(repoFile instanceof NormalFile)) {
                    throw new IllegalStateException("RepoFile is not an instance of NormalFile for file: " + file);
                }
                normalFile = (NormalFile)repoFile;
                if (!normalFile.isInProgress()) {
                    throw new IllegalStateException(String.format("NormalFile.inProgress == false! beginPutFile(...) not called?! repoFile=%s file=%s", new Object[]{repoFile, file}));
                }
                fileWriteStrategy = this.getFileWriteStrategy(file);
                FileRepoTransport.logger.debug("putFileData: fileWriteStrategy={}", (Object)fileWriteStrategy);
                switch (2.$SwitchMap$co$codewizards$cloudstore$core$repo$transport$FileWriteStrategy[fileWriteStrategy.ordinal()]) {
                    case 1: {
                        this.writeFileDataToDestFile(file, offset, fileData);
                        ** break;
lbl24:
                        // 1 sources

                        break;
                    }
                    case 2: 
                    case 3: {
                        this.tempChunkFileManager.writeFileDataToTempChunkFile(file, offset, fileData);
                        ** break;
lbl28:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown fileWriteStrategy: " + fileWriteStrategy);
                    }
                }
            }
            finally {
                ParentFileLastModifiedManager.getInstance().restoreParentFileLastModified(parentFile);
            }
            transaction.commit();
        }
        catch (Throwable var10_11) {
            var9_8 = var10_11;
            throw var10_11;
        }
        finally {
            if (transaction != null) {
                if (var9_8 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable var10_10) {
                        var9_8.addSuppressed(var10_10);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTempChunkFileToDestFile(File destFile, File tempChunkFile, TempChunkFileDto tempChunkFileDto) {
        AssertUtil.assertNotNull((String)"destFile", (Object)destFile);
        AssertUtil.assertNotNull((String)"tempChunkFile", (Object)tempChunkFile);
        AssertUtil.assertNotNull((String)"tempChunkFileDto", (Object)tempChunkFileDto);
        long offset = ((FileChunkDto)AssertUtil.assertNotNull((String)"tempChunkFileDto.fileChunkDto", (Object)tempChunkFileDto.getFileChunkDto())).getOffset();
        byte[] fileData = new byte[(int)tempChunkFile.length()];
        try (InputStream in = StreamUtil.castStream((IInputStream)tempChunkFile.createInputStream());){
            int off = 0;
            while (off < fileData.length) {
                int bytesRead = in.read(fileData, off, fileData.length - off);
                if (bytesRead > 0) {
                    off += bytesRead;
                    continue;
                }
                if (bytesRead >= 0) continue;
                throw new IllegalStateException("InputStream ended before expected file length!");
            }
            if (off > fileData.length || in.read() != -1) {
                throw new IllegalStateException("InputStream contained more data than expected file length!");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String sha1FromDtoFile = tempChunkFileDto.getFileChunkDto().getSha1();
        String sha1FromFileData = this.sha1(fileData);
        logger.trace("writeTempChunkFileToDestFile: Read {} bytes with SHA1 '{}' from '{}'.", new Object[]{fileData.length, sha1FromFileData, tempChunkFile.getAbsolutePath()});
        if (!sha1FromFileData.equals(sha1FromDtoFile)) {
            throw new IllegalStateException("SHA1 mismatch! Corrupt temporary chunk file or corresponding Dto file: " + tempChunkFile.getAbsolutePath());
        }
        this.writeFileDataToDestFile(destFile, offset, fileData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileDataToDestFile(File destFile, long offset, byte[] fileData) {
        AssertUtil.assertNotNull((String)"destFile", (Object)destFile);
        AssertUtil.assertNotNull((String)"fileData", (Object)fileData);
        try {
            try (RandomAccessFile raf = destFile.createRandomAccessFile("rw");){
                raf.seek(offset);
                raf.write(fileData);
            }
            logger.trace("writeFileDataToDestFile: Wrote {} bytes at offset {} to '{}'.", new Object[]{fileData.length, offset, destFile.getAbsolutePath()});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String sha1(byte[] data) {
        AssertUtil.assertNotNull((String)"data", (Object)data);
        try {
            byte[] hash = HashUtil.hash((String)"SHA", (InputStream)new ByteArrayInputStream(data));
            return HashUtil.encodeHexStr((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileWriteStrategy getFileWriteStrategy(File file) {
        AssertUtil.assertNotNull((String)"file", (Object)file);
        Map<File, FileWriteStrategy> map = this.file2FileWriteStrategy;
        synchronized (map) {
            FileWriteStrategy fileWriteStrategy = this.file2FileWriteStrategy.get(file);
            if (fileWriteStrategy == null) {
                fileWriteStrategy = (FileWriteStrategy)ConfigImpl.getInstanceForFile((File)file).getPropertyAsEnum("fileWriteStrategy", (Enum)FileWriteStrategy.CONFIG_DEFAULT_VALUE);
                this.file2FileWriteStrategy.put(file, fileWriteStrategy);
            }
            return fileWriteStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endPutFile(String path, Date lastModified, long length, String sha1) {
        path = this.prefixPath(path);
        AssertUtil.assertNotNull((String)"lastModified", (Object)lastModified);
        File file = this.getFile(path);
        File parentFile = file.getParentFile();
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            ParentFileLastModifiedManager.getInstance().backupParentFileLastModified(parentFile);
            try {
                InputStream fileIn;
                File destFile;
                RepoFile repoFile = ((RepoFileDao)transaction.getDao(RepoFileDao.class)).getRepoFile(this.getLocalRepoManager().getLocalRoot(), file);
                if (!(repoFile instanceof NormalFile)) {
                    throw new IllegalStateException(String.format("RepoFile is not an instance of NormalFile! repoFile=%s file=%s", repoFile, file));
                }
                NormalFile normalFile = (NormalFile)repoFile;
                if (!normalFile.isInProgress()) {
                    throw new IllegalStateException(String.format("NormalFile.inProgress == false! beginPutFile(...) not called?! repoFile=%s file=%s", repoFile, file));
                }
                FileWriteStrategy fileWriteStrategy = this.getFileWriteStrategy(file);
                logger.debug("endPutFile: fileWriteStrategy={}", (Object)fileWriteStrategy);
                File file2 = destFile = fileWriteStrategy == FileWriteStrategy.replaceAfterTransfer ? OioFileFactory.createFile((File)file.getParentFile(), (String[])new String[]{LocalRepoManager.TEMP_NEW_FILE_PREFIX + file.getName()}) : file;
                if (destFile != file) {
                    try {
                        fileIn = StreamUtil.castStream((IInputStream)file.createInputStream());
                        destFile.createNewFile();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    fileIn = null;
                }
                Collection<TempChunkFileWithDtoFile> tempChunkFileWithDtoFiles = this.tempChunkFileManager.getOffset2TempChunkFileWithDtoFile(file).values();
                try {
                    TempChunkFileDtoIo tempChunkFileDtoIo = new TempChunkFileDtoIo();
                    long destFileWriteOffset = 0L;
                    logger.debug("endPutFile: #tempChunkFileWithDtoFiles={}", (Object)tempChunkFileWithDtoFiles.size());
                    for (TempChunkFileWithDtoFile tempChunkFileWithDtoFile : tempChunkFileWithDtoFiles) {
                        File tempChunkFile = tempChunkFileWithDtoFile.getTempChunkFile();
                        File tempChunkFileDtoFile = tempChunkFileWithDtoFile.getTempChunkFileDtoFile();
                        if (tempChunkFileDtoFile == null) {
                            throw new IllegalStateException("No meta-data (tempChunkFileDtoFile) for file: " + (tempChunkFile == null ? null : tempChunkFile.getAbsolutePath()));
                        }
                        TempChunkFileDto tempChunkFileDto = (TempChunkFileDto)tempChunkFileDtoIo.deserialize(tempChunkFileDtoFile);
                        long offset = ((FileChunkDto)AssertUtil.assertNotNull((String)"tempChunkFileDto.fileChunkDto", (Object)tempChunkFileDto.getFileChunkDto())).getOffset();
                        if (fileIn != null) {
                            logger.info("endPutFile: writing from fileIn into destFile {}", (Object)destFile.getName());
                            this.writeFileDataToDestFile(destFile, destFileWriteOffset, fileIn, offset - destFileWriteOffset);
                            long tempChunkFileLength = tempChunkFileDto.getFileChunkDto().getLength();
                            this.skipOrFail(fileIn, tempChunkFileLength);
                            destFileWriteOffset = offset + tempChunkFileLength;
                        }
                        if (tempChunkFile == null || !tempChunkFile.exists()) continue;
                        logger.info("endPutFile: writing tempChunkFile {} into destFile {}", (Object)tempChunkFile.getName(), (Object)destFile.getName());
                        this.writeTempChunkFileToDestFile(destFile, tempChunkFile, tempChunkFileDto);
                        IOUtil.deleteOrFail((File)tempChunkFile);
                    }
                    if (fileIn != null && destFileWriteOffset < length) {
                        this.writeFileDataToDestFile(destFile, destFileWriteOffset, fileIn, length - destFileWriteOffset);
                    }
                }
                finally {
                    if (fileIn != null) {
                        fileIn.close();
                    }
                }
                try (RandomAccessFile raf = destFile.createRandomAccessFile("rw");){
                    raf.setLength(length);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (destFile != file) {
                    IOUtil.deleteOrFail((File)file);
                    destFile.renameTo(file);
                    if (!file.exists()) {
                        throw new IllegalStateException(String.format("Renaming the file from '%s' to '%s' failed: The destination file does not exist.", destFile.getAbsolutePath(), file.getAbsolutePath()));
                    }
                    if (destFile.exists()) {
                        throw new IllegalStateException(String.format("Renaming the file from '%s' to '%s' failed: The source file still exists.", destFile.getAbsolutePath(), file.getAbsolutePath()));
                    }
                }
                this.tempChunkFileManager.deleteTempChunkFiles(tempChunkFileWithDtoFiles);
                this.tempChunkFileManager.deleteTempDirIfEmpty(file);
                LocalRepoSync localRepoSync = LocalRepoSync.create(transaction);
                file.setLastModified(lastModified.getTime());
                localRepoSync.updateRepoFile(normalFile, file, (ProgressMonitor)new NullProgressMonitor());
                normalFile.setLastSyncFromRepositoryId(clientRepositoryId);
                normalFile.setInProgress(false);
                logger.trace("endPutFile: Committing: sha1='{}' file='{}'", (Object)normalFile.getSha1(), (Object)file);
                if (sha1 != null && !sha1.equals(normalFile.getSha1())) {
                    logger.warn("endPutFile: File was modified during transport (either on source or destination side): expectedSha1='{}' foundSha1='{}' file='{}'", new Object[]{sha1, normalFile.getSha1(), file});
                }
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
            finally {
                ParentFileLastModifiedManager.getInstance().restoreParentFileLastModified(parentFile);
            }
            transaction.commit();
        }
    }

    private void skipOrFail(InputStream in, long length) {
        long skippedNow;
        AssertUtil.assertNotNull((String)"in", (Object)in);
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        int skippedNowWas0Counter = 0;
        for (long skipped = 0L; skipped < length; skipped += skippedNow) {
            long toSkip = length - skipped;
            try {
                skippedNow = in.skip(toSkip);
                if (skippedNow < 0L) {
                    throw new IOException("in.skip(" + toSkip + ") returned " + skippedNow);
                }
                if (skippedNow == 0L) {
                    if (++skippedNowWas0Counter < 5) continue;
                    throw new IOException(String.format("Could not skip %s consecutive times!", skippedNowWas0Counter));
                }
                skippedNowWas0Counter = 0;
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileDataToDestFile(File destFile, long offset, InputStream in, long length) {
        AssertUtil.assertNotNull((String)"destFile", (Object)destFile);
        AssertUtil.assertNotNull((String)"in", (Object)in);
        if (offset < 0L) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (length == 0L) {
            return;
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        long lengthDone = 0L;
        try (RandomAccessFile raf = destFile.createRandomAccessFile("rw");){
            raf.seek(offset);
            byte[] buf = new byte[204800];
            while (lengthDone < length) {
                long len = Math.min(length - lengthDone, (long)buf.length);
                int bytesRead = in.read(buf, 0, (int)len);
                if (bytesRead > 0) {
                    raf.write(buf, 0, bytesRead);
                    lengthDone += (long)bytesRead;
                    continue;
                }
                if (bytesRead >= 0) continue;
                throw new IOException("Premature end of stream!");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void endSyncFromRepository() {
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            PersistenceManager pm = ((LocalRepoTransactionImpl)transaction).getPersistenceManager();
            RemoteRepositoryDao remoteRepositoryDao = (RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class);
            LastSyncToRemoteRepoDao lastSyncToRemoteRepoDao = (LastSyncToRemoteRepoDao)transaction.getDao(LastSyncToRemoteRepoDao.class);
            ModificationDao modificationDao = (ModificationDao)transaction.getDao(ModificationDao.class);
            TransferDoneMarkerDao transferDoneMarkerDao = (TransferDoneMarkerDao)transaction.getDao(TransferDoneMarkerDao.class);
            RemoteRepository toRemoteRepository = remoteRepositoryDao.getRemoteRepositoryOrFail(clientRepositoryId);
            LastSyncToRemoteRepo lastSyncToRemoteRepo = lastSyncToRemoteRepoDao.getLastSyncToRemoteRepoOrFail(toRemoteRepository);
            if (lastSyncToRemoteRepo.getLocalRepositoryRevisionInProgress() < 0L) {
                throw new IllegalStateException(String.format("lastSyncToRemoteRepo.localRepositoryRevisionInProgress < 0 :: There is no sync in progress for the RemoteRepository with entityID=%s", clientRepositoryId));
            }
            lastSyncToRemoteRepo.setLocalRepositoryRevisionSynced(lastSyncToRemoteRepo.getLocalRepositoryRevisionInProgress());
            lastSyncToRemoteRepo.setLocalRepositoryRevisionInProgress(-1L);
            pm.flush();
            Collection<Modification> modifications = modificationDao.getModificationsBeforeOrEqual(toRemoteRepository, lastSyncToRemoteRepo.getLocalRepositoryRevisionSynced());
            modificationDao.deletePersistentAll(modifications);
            pm.flush();
            transferDoneMarkerDao.deleteRepoFileTransferDones(this.getRepositoryId(), clientRepositoryId);
            FileInProgressMarkerDao fileInProgressMarkerDao = (FileInProgressMarkerDao)transaction.getDao(FileInProgressMarkerDao.class);
            fileInProgressMarkerDao.deleteFileInProgressMarkers(this.getRepositoryId(), clientRepositoryId);
            logger.info("endSyncFromRepository: localRepositoryId={} remoteRepositoryId={} localRepositoryRevisionSynced={}", new Object[]{this.getRepositoryId(), toRemoteRepository.getRepositoryId(), lastSyncToRemoteRepo.getLocalRepositoryRevisionSynced()});
            transaction.commit();
        }
    }

    public void endSyncToRepository(long fromLocalRevision) {
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            RemoteRepositoryDao remoteRepositoryDao = (RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class);
            TransferDoneMarkerDao transferDoneMarkerDao = (TransferDoneMarkerDao)transaction.getDao(TransferDoneMarkerDao.class);
            RemoteRepository remoteRepository = remoteRepositoryDao.getRemoteRepositoryOrFail(clientRepositoryId);
            remoteRepository.setRevision(fromLocalRevision);
            transferDoneMarkerDao.deleteRepoFileTransferDones(clientRepositoryId, this.getRepositoryId());
            FileInProgressMarkerDao fileInProgressMarkerDao = (FileInProgressMarkerDao)transaction.getDao(FileInProgressMarkerDao.class);
            fileInProgressMarkerDao.deleteFileInProgressMarkers(clientRepositoryId, this.getRepositoryId());
            logger.info("endSyncToRepository: localRepositoryId={} remoteRepositoryId={} transaction.localRevision={} remoteFromLocalRevision={}", new Object[]{this.getRepositoryId(), clientRepositoryId, transaction.getLocalRevision(), fromLocalRevision});
            transaction.commit();
        }
    }

    public boolean isTransferDone(UUID fromRepositoryId, UUID toRepositoryId, TransferDoneMarkerType transferDoneMarkerType, long fromEntityId, long fromLocalRevision) {
        boolean result = false;
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginReadTransaction();){
            TransferDoneMarkerDao dao = (TransferDoneMarkerDao)transaction.getDao(TransferDoneMarkerDao.class);
            TransferDoneMarker transferDoneMarker = dao.getTransferDoneMarker(fromRepositoryId, toRepositoryId, transferDoneMarkerType, fromEntityId);
            if (transferDoneMarker != null) {
                result = fromLocalRevision == transferDoneMarker.getFromLocalRevision();
            }
            transaction.commit();
        }
        return result;
    }

    public void markTransferDone(UUID fromRepositoryId, UUID toRepositoryId, TransferDoneMarkerType transferDoneMarkerType, long fromEntityId, long fromLocalRevision) {
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            TransferDoneMarkerDao dao = (TransferDoneMarkerDao)transaction.getDao(TransferDoneMarkerDao.class);
            TransferDoneMarker transferDoneMarker = dao.getTransferDoneMarker(fromRepositoryId, toRepositoryId, transferDoneMarkerType, fromEntityId);
            if (transferDoneMarker == null) {
                transferDoneMarker = new TransferDoneMarker();
                transferDoneMarker.setFromRepositoryId(fromRepositoryId);
                transferDoneMarker.setToRepositoryId(toRepositoryId);
                transferDoneMarker.setTransferDoneMarkerType(transferDoneMarkerType);
                transferDoneMarker.setFromEntityId(fromEntityId);
            }
            transferDoneMarker.setFromLocalRevision(fromLocalRevision);
            dao.makePersistent(transferDoneMarker);
            transaction.commit();
        }
    }

    public Set<String> getFileInProgressPaths(UUID fromRepository, UUID toRepository) {
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginReadTransaction();){
            FileInProgressMarkerDao dao = (FileInProgressMarkerDao)transaction.getDao(FileInProgressMarkerDao.class);
            Collection<FileInProgressMarker> fileInProgressMarkers = dao.getFileInProgressMarkers(fromRepository, toRepository);
            HashSet<String> paths = new HashSet<String>(fileInProgressMarkers.size());
            for (FileInProgressMarker fileInProgressMarker : fileInProgressMarkers) {
                paths.add(fileInProgressMarker.getPath());
            }
            transaction.commit();
            HashSet<String> hashSet = paths;
            return hashSet;
        }
    }

    public void markFileInProgress(UUID fromRepository, UUID toRepository, String path, boolean inProgress) {
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            FileInProgressMarkerDao dao = (FileInProgressMarkerDao)transaction.getDao(FileInProgressMarkerDao.class);
            FileInProgressMarker fileInProgressMarker = dao.getFileInProgressMarker(fromRepository, toRepository, path);
            if (fileInProgressMarker == null && inProgress) {
                fileInProgressMarker = new FileInProgressMarker();
                fileInProgressMarker.setFromRepositoryId(fromRepository);
                fileInProgressMarker.setToRepositoryId(toRepository);
                fileInProgressMarker.setPath(path);
                dao.makePersistent(fileInProgressMarker);
                logger.info("Storing fileInProgressMarker: {} on repo={}", (Object)fileInProgressMarker, (Object)this.getRepositoryId());
            } else if (fileInProgressMarker != null && !inProgress) {
                logger.info("Removing fileInProgressMarker: {} on repo={}", (Object)fileInProgressMarker, (Object)this.getRepositoryId());
                dao.deletePersistent(fileInProgressMarker);
            } else {
                logger.warn("Unexpected state: markFileInProgress==null='{}', inProgress='{}' on repo={}", new Object[]{fileInProgressMarker == null, inProgress, this.getRepositoryId()});
            }
            transaction.commit();
        }
    }

    public void putParentConfigPropSetDto(ConfigPropSetDto parentConfigPropSetDto) {
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            RemoteRepository remoteRepository = ((RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryOrFail(this.getClientRepositoryIdOrFail());
            if (!remoteRepository.getLocalPathPrefix().isEmpty()) {
                logger.warn("putParentConfigPropSetDto: IGNORING unsupported situation! See: https://github.com/cloudstore/cloudstore/issues/58");
                return;
            }
            File metaDir = this.getLocalRepoManager().getLocalRoot().createFile(new String[]{LocalRepoManager.META_DIR_NAME});
            if (!metaDir.isDirectory()) {
                throw new IOException("Directory does not exist: " + metaDir);
            }
            File repoParentConfigFile = metaDir.createFile(new String[]{"parent." + this.getClientRepositoryIdOrFail() + ".properties"});
            if (parentConfigPropSetDto.getConfigPropDtos().isEmpty()) {
                repoParentConfigFile.delete();
                if (repoParentConfigFile.isFile()) {
                    throw new IOException("Deleting file failed: " + repoParentConfigFile);
                }
            } else {
                Properties properties = parentConfigPropSetDto.toProperties();
                PropertiesUtil.store((File)repoParentConfigFile, (Properties)properties, null);
            }
            this.mergeRepoParentConfigFiles();
            transaction.commit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void mergeRepoParentConfigFiles() throws IOException {
        File metaDir = this.getLocalRepoManager().getLocalRoot().createFile(new String[]{LocalRepoManager.META_DIR_NAME});
        Properties properties = new Properties();
        for (File configFile : this.getRepoParentConfigFiles()) {
            InputStream in = StreamUtil.castStream((IInputStream)configFile.createInputStream());
            Throwable throwable = null;
            try {
                properties.load(in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
        File parentConfigFile = metaDir.createFile(new String[]{"parent.properties"});
        if (properties.isEmpty()) {
            parentConfigFile.delete();
            if (parentConfigFile.isFile()) {
                throw new IOException("Deleting file failed: " + parentConfigFile);
            }
        } else {
            PropertiesUtil.store((File)parentConfigFile, (Properties)properties, null);
        }
    }

    private List<File> getRepoParentConfigFiles() {
        ArrayList<File> result = new ArrayList<File>();
        File metaDir = this.getLocalRepoManager().getLocalRoot().createFile(new String[]{LocalRepoManager.META_DIR_NAME});
        Pattern repoParentConfigPattern = Pattern.compile(Pattern.quote("parent.") + "[^.]*" + Pattern.quote(".properties"));
        Matcher repoParentConfigMatcher = null;
        for (File file : metaDir.listFiles()) {
            if (repoParentConfigMatcher == null) {
                repoParentConfigMatcher = repoParentConfigPattern.matcher(file.getName());
            } else {
                repoParentConfigMatcher.reset(file.getName());
            }
            if (!repoParentConfigMatcher.matches() || !file.isFile()) continue;
            result.add(file);
        }
        Collections.sort(result, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    public VersionInfoDto getVersionInfoDto() {
        return VersionInfoProvider.getInstance().getVersionInfoDto();
    }
}

