/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.client.handler;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.client.LocalServerClient;
import co.codewizards.cloudstore.ls.client.handler.InverseServiceRequestHandler;
import co.codewizards.cloudstore.ls.client.handler.InverseServiceRequestHandlerManager;
import co.codewizards.cloudstore.ls.core.dto.ErrorResponse;
import co.codewizards.cloudstore.ls.core.dto.InverseServiceRequest;
import co.codewizards.cloudstore.ls.core.dto.InverseServiceResponse;
import co.codewizards.cloudstore.ls.core.dto.NullResponse;
import co.codewizards.cloudstore.ls.rest.client.LocalServerRestClient;
import co.codewizards.cloudstore.ls.rest.client.request.PollInverseServiceRequest;
import co.codewizards.cloudstore.ls.rest.client.request.PushInverseServiceResponse;
import co.codewizards.cloudstore.ls.rest.client.request.Request;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InverseServiceRequestHandlerThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(InverseServiceRequestHandlerThread.class);
    private static final AtomicInteger nextThreadId = new AtomicInteger();
    private volatile boolean interrupted;
    private final WeakReference<LocalServerClient> localServerClientRef;
    private final WeakReference<LocalServerRestClient> localServerRestClientRef;
    private final InverseServiceRequestHandlerManager inverseServiceRequestHandlerManager = InverseServiceRequestHandlerManager.getInstance();
    private final Executor executor = Executors.newCachedThreadPool();

    public InverseServiceRequestHandlerThread(LocalServerClient localServerClient) {
        this.localServerClientRef = new WeakReference<Object>(AssertUtil.assertNotNull((String)"localServerClient", (Object)localServerClient));
        this.localServerRestClientRef = new WeakReference<Object>(AssertUtil.assertNotNull((String)"localServerRestClient", (Object)localServerClient.getLocalServerRestClient()));
        this.setName(this.getClass().getSimpleName() + '-' + nextThreadId.getAndIncrement());
        this.setDaemon(true);
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
        super.interrupt();
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted || super.isInterrupted();
    }

    @Override
    public void run() {
        int consecutiveErrorCounter = 0;
        while (!this.isInterrupted()) {
            try {
                InverseServiceRequest inverseServiceRequest = (InverseServiceRequest)this.getLocalServerRestClientOrFail().execute((Request)new PollInverseServiceRequest());
                if (inverseServiceRequest != null) {
                    this.executor.execute(new HandlerRunnable(inverseServiceRequest));
                }
                consecutiveErrorCounter = 0;
            }
            catch (Exception x) {
                logger.error(x.toString(), (Throwable)x);
                ++consecutiveErrorCounter;
                consecutiveErrorCounter = Math.min(60, consecutiveErrorCounter);
                try {
                    Thread.sleep((long)consecutiveErrorCounter * 1000L);
                }
                catch (Exception y) {
                    Util.doNothing();
                }
            }
        }
    }

    private LocalServerClient getLocalServerClientOrFail() {
        LocalServerClient localServerClient = (LocalServerClient)this.localServerClientRef.get();
        if (localServerClient == null) {
            throw new IllegalStateException("LocalServerClient already garbage-collected!");
        }
        return localServerClient;
    }

    private LocalServerRestClient getLocalServerRestClientOrFail() {
        LocalServerRestClient localServerRestClient = (LocalServerRestClient)this.localServerRestClientRef.get();
        if (localServerRestClient == null) {
            throw new IllegalStateException("LocalServerRestClient already garbage-collected!");
        }
        return localServerRestClient;
    }

    private class HandlerRunnable
    implements Runnable {
        private final InverseServiceRequest inverseServiceRequest;

        public HandlerRunnable(InverseServiceRequest inverseServiceRequest) {
            this.inverseServiceRequest = (InverseServiceRequest)AssertUtil.assertNotNull((String)"inverseServiceRequest", (Object)inverseServiceRequest);
        }

        @Override
        public void run() {
            AssertUtil.assertNotNull((String)"inverseServiceRequest", (Object)this.inverseServiceRequest);
            Uid requestId = this.inverseServiceRequest.getRequestId();
            AssertUtil.assertNotNull((String)"inverseServiceRequest.requestId", (Object)requestId);
            LocalServerRestClient localServerRestClient = InverseServiceRequestHandlerThread.this.getLocalServerRestClientOrFail();
            NullResponse inverseServiceResponse = null;
            try {
                InverseServiceRequestHandler handler = InverseServiceRequestHandlerThread.this.inverseServiceRequestHandlerManager.getInverseServiceRequestHandlerOrFail(this.inverseServiceRequest);
                LocalServerClient localServerClient = InverseServiceRequestHandlerThread.this.getLocalServerClientOrFail();
                handler.setLocalServerClient(localServerClient);
                inverseServiceResponse = (NullResponse)handler.handle(this.inverseServiceRequest);
                if (inverseServiceResponse == null) {
                    inverseServiceResponse = new NullResponse(requestId);
                }
                if (!requestId.equals((Object)inverseServiceResponse.getRequestId())) {
                    throw new IllegalStateException(String.format("Implementation error in %s: handle(...) returned a response with a requestId different from the request!", handler.getClass().getName()));
                }
            }
            catch (Exception x) {
                logger.warn("handleInverseServiceRequest: " + x, (Throwable)x);
                ErrorResponse errorResponse = new ErrorResponse(requestId, new Error((Throwable)x));
                localServerRestClient.execute((Request)new PushInverseServiceResponse((InverseServiceResponse)errorResponse));
            }
            if (inverseServiceResponse != null) {
                localServerRestClient.execute((Request)new PushInverseServiceResponse((InverseServiceResponse)inverseServiceResponse));
            }
        }
    }
}

